/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.common.buffers;

import io.helidon.common.buffers.BufferData;
import io.helidon.common.buffers.ReadOnlyBufferData;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;

class CompositeArrayBufferData
extends ReadOnlyBufferData {
    private final BufferData[] data;

    CompositeArrayBufferData(BufferData[] data) {
        this.data = data;
    }

    @Override
    public BufferData rewind() {
        for (BufferData datum : this.data) {
            datum.rewind();
        }
        return this;
    }

    @Override
    public void writeTo(OutputStream out) {
        this.copy().writeTo(out);
    }

    @Override
    public int readFrom(InputStream in) {
        for (BufferData datum : this.data) {
            if (datum.capacity() <= 0) continue;
            return datum.readFrom(in);
        }
        throw new IllegalStateException("The composite buffer is fully written, cannot write additional bytes");
    }

    @Override
    public int read() {
        for (BufferData datum : this.data) {
            if (datum.consumed()) continue;
            return datum.read();
        }
        throw new ArrayIndexOutOfBoundsException("This buffer has no more bytes");
    }

    @Override
    public int read(byte[] buffer, int position, int length) {
        int myPosition = position;
        int remaining = length;
        for (BufferData datum : this.data) {
            if (datum.available() <= 0) continue;
            int read = datum.read(buffer, myPosition, remaining);
            myPosition += read;
            if ((remaining -= read) == 0) break;
        }
        return myPosition - position;
    }

    @Override
    public String readString(int length, Charset charset) {
        int read;
        int current;
        if (length > this.available()) {
            throw new ArrayIndexOutOfBoundsException("Requested " + length + " bytes, but only " + this.available() + " were available\n" + this.debugDataHex(false));
        }
        byte[] buffer = new byte[length];
        for (read = 0; read != length && this.available() > 0; read += current) {
            current = this.read(buffer, 0, length);
            if (current != 0) continue;
            throw new IllegalStateException("Read 0 bytes when available: " + this.available() + "\n" + this.debugDataHex(false));
        }
        if (read != length) {
            throw new ArrayIndexOutOfBoundsException("Requested " + length + " bytes, but only " + read + " were available");
        }
        return new String(buffer, charset);
    }

    @Override
    public boolean consumed() {
        boolean consumed = true;
        for (BufferData datum : this.data) {
            if (datum.consumed()) continue;
            consumed = false;
        }
        return consumed;
    }

    @Override
    public int writeTo(ByteBuffer writeBuffer, int limit) {
        int written = 0;
        for (BufferData datum : this.data) {
            if (datum.consumed()) continue;
            int datumWrote = datum.writeTo(writeBuffer, limit - written);
            if (datumWrote == 0) break;
            written += datumWrote;
        }
        return written;
    }

    @Override
    public String debugDataBinary() {
        StringBuilder result = new StringBuilder();
        for (BufferData datum : this.data) {
            result.append(datum.debugDataBinary());
        }
        return result.toString();
    }

    @Override
    public String debugDataHex(boolean fullBuffer) {
        StringBuilder result = new StringBuilder();
        for (BufferData datum : this.data) {
            result.append(datum.debugDataHex(fullBuffer));
        }
        return result.toString();
    }

    @Override
    public int available() {
        int available = 0;
        for (BufferData datum : this.data) {
            available += datum.available();
        }
        return available;
    }

    @Override
    public void skip(int length) {
        int remaining = length;
        for (BufferData datum : this.data) {
            int toSkip = Math.min(datum.available(), remaining);
            datum.skip(toSkip);
            if ((remaining -= toSkip) > 0) continue;
            return;
        }
    }

    @Override
    public int indexOf(byte aByte) {
        int indexPrefix = 0;
        for (BufferData datum : this.data) {
            int index = datum.indexOf(aByte);
            if (index > -1) {
                return indexPrefix + index;
            }
            indexPrefix += datum.available();
        }
        return -1;
    }

    @Override
    public int lastIndexOf(byte aByte, int length) {
        int lengthRemaining = length;
        for (int i = this.data.length - 1; i >= 0; --i) {
            BufferData datum = this.data[i];
            int index = datum.lastIndexOf(aByte, Math.min(lengthRemaining, datum.available()));
            if (index > -1) {
                return index;
            }
            if ((lengthRemaining -= datum.available()) <= 0) break;
        }
        return -1;
    }

    @Override
    public BufferData trim(int x) {
        if (this.available() < x) {
            throw new IllegalArgumentException("Trimming more bytes than available");
        }
        int toRemove = x;
        for (int i = this.data.length - 1; i > -1; --i) {
            if (toRemove == 0) {
                return this;
            }
            BufferData datum = this.data[i];
            if (datum.available() <= 0) continue;
            int removed = Math.min(datum.available(), toRemove);
            toRemove -= removed;
            datum.trim(removed);
        }
        if (toRemove == 0) {
            return this;
        }
        throw new IllegalStateException("Could not trim buffer by " + x + " bytes");
    }

    @Override
    public int get(int index) {
        int inDataIndex = index;
        for (BufferData datum : this.data) {
            int available = datum.available();
            if (available <= inDataIndex) {
                inDataIndex -= available;
                continue;
            }
            return datum.get(inDataIndex);
        }
        throw new ArrayIndexOutOfBoundsException("Invalid index to get: " + index);
    }

    public String toString() {
        return "comp-array: a=" + this.available();
    }
}

