/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.common.buffers;

import io.helidon.common.buffers.BufferData;
import io.helidon.common.buffers.BufferUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;

class FixedBufferData
implements BufferData {
    private final byte[] bytes;
    private final int length;
    private int writePosition;
    private int readPosition;

    FixedBufferData(int length) {
        this.bytes = new byte[length];
        this.length = length;
    }

    FixedBufferData(byte[] bytes) {
        this.bytes = bytes;
        this.writePosition = this.length = bytes.length;
    }

    FixedBufferData(byte[] bytes, int position, int length) {
        this.bytes = bytes;
        this.length = length;
        this.writePosition = length;
        this.readPosition = position;
    }

    @Override
    public FixedBufferData reset() {
        this.writePosition = 0;
        this.readPosition = 0;
        return this;
    }

    @Override
    public BufferData rewind() {
        this.readPosition = 0;
        return this;
    }

    @Override
    public BufferData clear() {
        return this.reset();
    }

    @Override
    public void writeTo(OutputStream out) {
        try {
            out.write(this.bytes, this.readPosition, this.writePosition);
            this.readPosition = this.writePosition;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public int readFrom(InputStream in) {
        int read;
        int toRead = this.length - this.writePosition;
        try {
            read = in.read(this.bytes, this.writePosition, toRead);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        if (read == -1) {
            return read;
        }
        this.writePosition += read;
        return read;
    }

    @Override
    public int read() {
        if (this.readPosition >= this.writePosition) {
            throw new ArrayIndexOutOfBoundsException("This buffer has " + this.length + " bytes, requested to read at " + this.readPosition);
        }
        return this.bytes[this.readPosition++] & 0xFF;
    }

    @Override
    public int read(byte[] bytes, int position, int length) {
        int available = this.writePosition - this.readPosition;
        int toRead = Math.min(length, available);
        System.arraycopy(this.bytes, this.readPosition, bytes, position, toRead);
        this.readPosition += toRead;
        return toRead;
    }

    @Override
    public String readString(int length, Charset charset) {
        String result = new String(this.bytes, this.readPosition, length, charset);
        this.readPosition += length;
        return result;
    }

    @Override
    public boolean consumed() {
        return this.readPosition == this.writePosition;
    }

    @Override
    public FixedBufferData write(int value) {
        this.bytes[this.writePosition++] = (byte)value;
        return this;
    }

    @Override
    public int writeTo(ByteBuffer writeBuffer, int length) {
        int toWrite = Math.min(writeBuffer.limit() - writeBuffer.position(), this.length - this.readPosition);
        if ((toWrite = Math.min(toWrite, length)) == 0) {
            return 0;
        }
        writeBuffer.put(this.bytes, this.readPosition, toWrite);
        this.readPosition += toWrite;
        return toWrite;
    }

    @Override
    public void write(byte[] bytes, int offset, int length) {
        System.arraycopy(bytes, offset, this.bytes, this.writePosition, length);
        this.writePosition += length;
    }

    @Override
    public void write(BufferData toWrite) {
        byte[] buffer = new byte[this.length - this.writePosition];
        int read = toWrite.read(buffer);
        System.arraycopy(buffer, 0, this.bytes, this.writePosition, read);
        this.writePosition += read;
    }

    @Override
    public void write(BufferData toWrite, int length) {
        byte[] buffer = new byte[length];
        int read = toWrite.read(buffer);
        System.arraycopy(buffer, 0, this.bytes, this.writePosition, read);
        this.writePosition += read;
    }

    @Override
    public String debugDataBinary() {
        return BufferUtil.debugDataBinary(this.bytes, 0, this.writePosition);
    }

    @Override
    public String debugDataHex(boolean fullBuffer) {
        if (fullBuffer) {
            return BufferUtil.debugDataHex(this.bytes, 0, this.writePosition);
        }
        return BufferUtil.debugDataHex(this.bytes, this.readPosition, this.writePosition);
    }

    @Override
    public int available() {
        return this.writePosition - this.readPosition;
    }

    @Override
    public void skip(int length) {
        this.readPosition += length;
    }

    @Override
    public int indexOf(byte aByte) {
        for (int i = this.readPosition; i < this.readPosition + this.available(); ++i) {
            if (aByte != this.bytes[i]) continue;
            return i - this.readPosition;
        }
        return -1;
    }

    @Override
    public int lastIndexOf(byte aByte, int length) {
        for (int i = this.readPosition + length - 1; i >= this.readPosition; --i) {
            byte b = this.bytes[i];
            if (b != aByte) continue;
            return i - this.readPosition;
        }
        return -1;
    }

    @Override
    public BufferData trim(int x) {
        if (this.available() < x) {
            throw new IllegalArgumentException("Trimming more bytes than available");
        }
        this.writePosition -= x;
        return this;
    }

    @Override
    public int capacity() {
        return this.length - this.writePosition;
    }

    @Override
    public int get(int index) {
        return this.bytes[this.readPosition + index];
    }

    public String toString() {
        return "fixed: l=" + this.length + ", r=" + this.readPosition + ", w=" + this.writePosition;
    }
}

