/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.common.socket;

import io.helidon.builder.api.Option;
import io.helidon.builder.api.Prototype;
import io.helidon.common.socket.SocketOptions;
import io.helidon.config.metadata.Configured;
import io.helidon.config.metadata.ConfiguredOption;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.Socket;
import java.net.SocketOption;
import java.net.StandardSocketOptions;
import java.time.Duration;
import java.util.Map;
import java.util.Optional;

@Configured
@Prototype.Blueprint(decorator=BuilderDecorator.class)
interface SocketOptionsBlueprint {
    @Option.Singular
    @Option.SameGeneric
    public Map<SocketOption<?>, Object> socketOptions();

    @ConfiguredOption(value="PT10S")
    public Duration connectTimeout();

    @ConfiguredOption(value="PT30S")
    public Duration readTimeout();

    @ConfiguredOption
    public Optional<Integer> socketReceiveBufferSize();

    @ConfiguredOption
    public Optional<Integer> socketSendBufferSize();

    @ConfiguredOption(value="true")
    public boolean socketReuseAddress();

    @ConfiguredOption(value="true")
    public boolean socketKeepAlive();

    @ConfiguredOption(value="false")
    public boolean tcpNoDelay();

    default public void configureSocket(Socket socket) {
        for (Map.Entry<SocketOption<?>, Object> entry : this.socketOptions().entrySet()) {
            try {
                SocketOption<?> opt = entry.getKey();
                socket.setOption(opt, entry.getValue());
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
    }

    public static class BuilderDecorator
    implements Prototype.BuilderDecorator<SocketOptions.BuilderBase<?, ?>> {
        public void decorate(SocketOptions.BuilderBase<?, ?> target) {
            target.socketReceiveBufferSize().ifPresent(i -> target.putSocketOption(StandardSocketOptions.SO_RCVBUF, i));
            target.socketSendBufferSize().ifPresent(i -> target.putSocketOption(StandardSocketOptions.SO_SNDBUF, i));
            target.putSocketOption(StandardSocketOptions.SO_REUSEADDR, target.socketReuseAddress());
            target.putSocketOption(StandardSocketOptions.SO_KEEPALIVE, target.socketKeepAlive());
            target.putSocketOption(StandardSocketOptions.TCP_NODELAY, target.tcpNoDelay());
        }
    }
}

