/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.common.socket;

import io.helidon.common.socket.PeerInfo;
import io.helidon.common.socket.PeerInfoImpl;
import io.helidon.common.socket.PlainSocket;
import java.security.Principal;
import java.security.cert.Certificate;
import java.util.Optional;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSocket;

public final class TlsSocket
extends PlainSocket {
    private final SSLSocket sslSocket;

    private TlsSocket(SSLSocket socket, String channelId, String serverChannelId) {
        super(socket, channelId, serverChannelId);
        this.sslSocket = socket;
    }

    public static TlsSocket server(SSLSocket delegate, String channelId, String serverChannelId) {
        return new TlsSocket(delegate, channelId, serverChannelId);
    }

    public static TlsSocket client(SSLSocket delegate, String channelId) {
        return new TlsSocket(delegate, channelId, "client");
    }

    @Override
    public PeerInfo remotePeer() {
        return PeerInfoImpl.createRemote(this);
    }

    @Override
    public PeerInfo localPeer() {
        return PeerInfoImpl.createLocal(this);
    }

    @Override
    public boolean isSecure() {
        return true;
    }

    @Override
    public boolean protocolNegotiated() {
        String protocol = this.sslSocket.getApplicationProtocol();
        return protocol != null && !protocol.isBlank();
    }

    @Override
    public String protocol() {
        return this.sslSocket.getApplicationProtocol();
    }

    Optional<Principal> tlsPeerPrincipal() {
        try {
            return Optional.of(this.sslSocket.getSession().getPeerPrincipal());
        }
        catch (SSLPeerUnverifiedException e) {
            return Optional.empty();
        }
    }

    Optional<Certificate[]> tlsPeerCertificates() {
        try {
            return Optional.of(this.sslSocket.getSession().getPeerCertificates());
        }
        catch (SSLPeerUnverifiedException e) {
            return Optional.empty();
        }
    }

    Optional<Principal> tlsPrincipal() {
        return Optional.of(this.sslSocket.getSession().getLocalPrincipal());
    }

    Optional<Certificate[]> tlsCertificates() {
        return Optional.of(this.sslSocket.getSession().getLocalCertificates());
    }
}

