/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.common.testing.junit5;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeMatcher;

public final class MapMatcher {
    private MapMatcher() {
    }

    public static <K, V> Matcher<Map<K, V>> mapEqualTo(Map<K, V> expected) {
        return new DiffMatcher<K, V>(expected);
    }

    private static final class DiffMatcher<K, V>
    extends TypeSafeMatcher<Map<K, V>> {
        private final Map<K, V> expected;
        private volatile Map<K, V> actual;
        private volatile List<Diff> diffs;

        private DiffMatcher(Map<K, V> expected) {
            this.expected = expected;
        }

        protected boolean matchesSafely(Map<K, V> actual) {
            this.actual = actual;
            this.diffs = DiffMatcher.diffs(this.expected, actual);
            return this.diffs.isEmpty();
        }

        public void describeTo(Description description) {
            description.appendText("deep map equality");
        }

        protected void describeMismatchSafely(Map<K, V> item, Description mismatchDescription) {
            List<Diff> diffs = this.actual == item ? this.diffs : DiffMatcher.diffs(this.expected, item);
            mismatchDescription.appendText("found differences" + System.lineSeparator()).appendText(String.join((CharSequence)System.lineSeparator(), diffs.stream().map(Diff::toString).toList()));
        }

        private static List<Diff> diffs(Map<?, ?> left, Map<?, ?> right) {
            ArrayList<Diff> diffs = new ArrayList<Diff>();
            Iterator<Map.Entry<String, String>> leftEntries = DiffMatcher.flattenEntries(left, "").iterator();
            Iterator<Map.Entry<String, String>> rightEntries = DiffMatcher.flattenEntries(right, "").iterator();
            while (true) {
                boolean hasLeft = leftEntries.hasNext();
                boolean hasRight = rightEntries.hasNext();
                if (hasLeft && hasRight) {
                    Map.Entry<String, String> rightEntry;
                    Map.Entry<String, String> leftEntry = leftEntries.next();
                    if (leftEntry.equals(rightEntry = rightEntries.next())) continue;
                    diffs.add(new Diff(leftEntry, rightEntry));
                    continue;
                }
                if (hasLeft) {
                    diffs.add(new Diff(leftEntries.next(), null));
                    continue;
                }
                if (!hasRight) break;
                diffs.add(new Diff(null, rightEntries.next()));
            }
            return diffs;
        }

        private static List<Map.Entry<String, String>> flattenEntries(Map<?, ?> map, String prefix) {
            ArrayList<Map.Entry<String, String>> result = new ArrayList<Map.Entry<String, String>>();
            for (Map.Entry<?, ?> entry : map.entrySet()) {
                Object obj = entry.getValue();
                if (obj instanceof Map) {
                    Map node = (Map)obj;
                    result.addAll(DiffMatcher.flattenEntries(node, prefix + String.valueOf(entry.getKey()) + "."));
                    continue;
                }
                result.add(Map.entry(prefix + String.valueOf(entry.getKey()), entry.getValue().toString()));
            }
            result.sort(Map.Entry.comparingByKey());
            return result;
        }

        private record Diff(Map.Entry<String, String> left, Map.Entry<String, String> right) {
            @Override
            public String toString() {
                if (this.left == null && this.right != null) {
                    return "ADDED   >> " + String.valueOf(this.right);
                }
                if (this.left != null && this.right == null) {
                    return "REMOVED << " + String.valueOf(this.left);
                }
                if (this.left != null) {
                    return "ADDED   >> " + String.valueOf(this.left) + System.lineSeparator() + "REMOVED << " + String.valueOf(this.right);
                }
                return "?";
            }
        }
    }
}

