/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.health.checks;

import io.helidon.common.NativeImageHelper;
import io.helidon.common.config.Config;
import io.helidon.health.HealthCheck;
import io.helidon.health.checks.DeadlockHealthCheck;
import io.helidon.health.checks.DiskSpaceHealthCheck;
import io.helidon.health.checks.HeapMemoryHealthCheck;
import io.helidon.health.spi.HealthCheckProvider;
import java.lang.management.ManagementFactory;
import java.util.List;

public class BuiltInHealthCheckProvider
implements HealthCheckProvider {
    public List<HealthCheck> healthChecks(Config config) {
        if (NativeImageHelper.isNativeImage()) {
            return List.of(this.diskSpace(config), this.heapMemory(config));
        }
        return List.of(this.diskSpace(config), this.heapMemory(config), this.deadlock());
    }

    private DeadlockHealthCheck deadlock() {
        return DeadlockHealthCheck.create(ManagementFactory.getThreadMXBean());
    }

    private HeapMemoryHealthCheck heapMemory(Config config) {
        return HeapMemoryHealthCheck.builder().config(config).build();
    }

    private DiskSpaceHealthCheck diskSpace(Config config) {
        return DiskSpaceHealthCheck.builder().config(config).build();
    }
}

