/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.http.media.jackson;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.helidon.common.GenericType;
import io.helidon.http.Headers;
import io.helidon.http.HttpMediaType;
import io.helidon.http.media.EntityReader;
import io.helidon.http.media.jackson.JacksonRuntimeException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;

class JacksonReader<T>
implements EntityReader<T> {
    private final ObjectMapper objectMapper;

    JacksonReader(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    public T read(GenericType<T> type, InputStream stream, Headers headers) {
        return this.read(type, stream, this.contentTypeCharset(headers));
    }

    public T read(GenericType<T> type, InputStream stream, Headers requestHeaders, Headers responseHeaders) {
        return this.read(type, stream, this.contentTypeCharset(responseHeaders));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private T read(GenericType<T> type, InputStream in, Charset charset) {
        try (InputStreamReader r = new InputStreamReader(in, charset);){
            Type t = type.type();
            if (t instanceof ParameterizedType) {
                JavaType javaType = this.objectMapper.getTypeFactory().constructType(t);
                Object object = this.objectMapper.readValue((Reader)r, javaType);
                return (T)object;
            }
            Object object = this.objectMapper.readValue((Reader)r, type.rawType());
            return (T)object;
        }
        catch (IOException e) {
            throw new JacksonRuntimeException("Failed to deserialize JSON to " + String.valueOf(type), e);
        }
    }

    private Charset contentTypeCharset(Headers headers) {
        return headers.contentType().flatMap(HttpMediaType::charset).map(Charset::forName).orElse(StandardCharsets.UTF_8);
    }
}

