/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.http.media.jackson;

import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jdk8.Jdk8Module;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.fasterxml.jackson.module.paramnames.ParameterNamesModule;
import io.helidon.common.GenericType;
import io.helidon.common.config.Config;
import io.helidon.common.media.type.MediaTypes;
import io.helidon.http.HeaderNames;
import io.helidon.http.HeaderValues;
import io.helidon.http.Headers;
import io.helidon.http.HttpMediaType;
import io.helidon.http.WritableHeaders;
import io.helidon.http.media.EntityReader;
import io.helidon.http.media.EntityWriter;
import io.helidon.http.media.MediaSupport;
import io.helidon.http.media.jackson.JacksonReader;
import io.helidon.http.media.jackson.JacksonWriter;
import java.util.Objects;

public class JacksonSupport
implements MediaSupport {
    private final ObjectMapper objectMapper;
    private final JacksonReader reader;
    private final JacksonWriter writer;
    private final String name;

    private JacksonSupport(ObjectMapper objectMapper, JacksonReader reader, JacksonWriter writer, String name) {
        this.objectMapper = objectMapper;
        this.reader = reader;
        this.writer = writer;
        this.name = name;
    }

    public static MediaSupport create(Config config) {
        return JacksonSupport.create(config, "jackson");
    }

    public static MediaSupport create(Config config, String name) {
        Objects.requireNonNull(config);
        Objects.requireNonNull(name);
        ObjectMapper objectMapper = new ObjectMapper().registerModule((Module)new ParameterNamesModule()).registerModule((Module)new Jdk8Module()).registerModule((Module)new JavaTimeModule());
        return JacksonSupport.create(objectMapper, name);
    }

    public static MediaSupport create(ObjectMapper objectMapper) {
        return JacksonSupport.create(objectMapper, "jackson");
    }

    public static MediaSupport create(ObjectMapper objectMapper, String name) {
        Objects.requireNonNull(objectMapper);
        Objects.requireNonNull(name);
        JacksonReader reader = new JacksonReader(objectMapper);
        JacksonWriter writer = new JacksonWriter(objectMapper);
        return new JacksonSupport(objectMapper, reader, writer, name);
    }

    public String name() {
        return this.name;
    }

    public String type() {
        return "jackson";
    }

    public <T> MediaSupport.ReaderResponse<T> reader(GenericType<T> type, Headers requestHeaders) {
        if (requestHeaders.contentType().map(it -> it.test(MediaTypes.APPLICATION_JSON)).orElse(true).booleanValue() && this.objectMapper.canDeserialize(this.objectMapper.constructType(type.type()))) {
            return new MediaSupport.ReaderResponse(MediaSupport.SupportLevel.COMPATIBLE, this::reader);
        }
        return MediaSupport.ReaderResponse.unsupported();
    }

    public <T> MediaSupport.WriterResponse<T> writer(GenericType<T> type, Headers requestHeaders, WritableHeaders<?> responseHeaders) {
        for (HttpMediaType acceptedType : requestHeaders.acceptedTypes()) {
            if (!acceptedType.test(MediaTypes.APPLICATION_JSON)) continue;
            if (this.objectMapper.canSerialize(type.rawType())) {
                return new MediaSupport.WriterResponse(MediaSupport.SupportLevel.COMPATIBLE, this::writer);
            }
            return MediaSupport.WriterResponse.unsupported();
        }
        if (requestHeaders.acceptedTypes().isEmpty() && this.objectMapper.canSerialize(type.rawType())) {
            return new MediaSupport.WriterResponse(MediaSupport.SupportLevel.COMPATIBLE, this::writer);
        }
        return MediaSupport.WriterResponse.unsupported();
    }

    public <T> MediaSupport.ReaderResponse<T> reader(GenericType<T> type, Headers requestHeaders, Headers responseHeaders) {
        for (HttpMediaType acceptedType : requestHeaders.acceptedTypes()) {
            if (!acceptedType.test(MediaTypes.APPLICATION_JSON) && !acceptedType.mediaType().isWildcardType() || !this.objectMapper.canDeserialize(this.objectMapper.constructType(type.type()))) continue;
            return new MediaSupport.ReaderResponse(MediaSupport.SupportLevel.COMPATIBLE, this::reader);
        }
        if (requestHeaders.acceptedTypes().isEmpty() && this.objectMapper.canDeserialize(this.objectMapper.constructType(type.type()))) {
            return new MediaSupport.ReaderResponse(MediaSupport.SupportLevel.COMPATIBLE, this::reader);
        }
        return MediaSupport.ReaderResponse.unsupported();
    }

    public <T> MediaSupport.WriterResponse<T> writer(GenericType<T> type, WritableHeaders<?> requestHeaders) {
        if (requestHeaders.contains(HeaderNames.CONTENT_TYPE)) {
            if (requestHeaders.contains(HeaderValues.CONTENT_TYPE_JSON)) {
                if (this.objectMapper.canSerialize(type.rawType())) {
                    return new MediaSupport.WriterResponse(MediaSupport.SupportLevel.COMPATIBLE, this::writer);
                }
                return MediaSupport.WriterResponse.unsupported();
            }
        } else {
            if (this.objectMapper.canSerialize(type.rawType())) {
                return new MediaSupport.WriterResponse(MediaSupport.SupportLevel.SUPPORTED, this::writer);
            }
            return MediaSupport.WriterResponse.unsupported();
        }
        return MediaSupport.WriterResponse.unsupported();
    }

    <T> EntityReader<T> reader() {
        return this.reader;
    }

    <T> EntityWriter<T> writer() {
        return this.writer;
    }
}

