/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.http.media.jackson;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import io.helidon.common.GenericType;
import io.helidon.common.media.type.MediaTypes;
import io.helidon.http.HeaderValues;
import io.helidon.http.Headers;
import io.helidon.http.HttpMediaType;
import io.helidon.http.WritableHeaders;
import io.helidon.http.media.EntityWriter;
import io.helidon.http.media.jackson.JacksonRuntimeException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import java.util.Optional;

class JacksonWriter<T>
implements EntityWriter<T> {
    private final ObjectMapper objectMapper;

    JacksonWriter(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    public void write(GenericType<T> type, T object, OutputStream outputStream, Headers requestHeaders, WritableHeaders<?> responseHeaders) {
        responseHeaders.setIfAbsent(HeaderValues.CONTENT_TYPE_JSON);
        for (HttpMediaType acceptedType : requestHeaders.acceptedTypes()) {
            if (!acceptedType.test(MediaTypes.APPLICATION_JSON)) continue;
            Optional charset = acceptedType.charset();
            if (charset.isPresent()) {
                Charset characterSet = Charset.forName((String)charset.get());
                this.write(type, object, new OutputStreamWriter(outputStream, characterSet));
            } else {
                this.write(type, object, outputStream);
            }
            return;
        }
        this.write(type, object, outputStream);
    }

    public void write(GenericType<T> type, T object, OutputStream outputStream, WritableHeaders<?> headers) {
        headers.setIfAbsent(HeaderValues.CONTENT_TYPE_JSON);
        this.write(type, object, outputStream);
    }

    private void write(GenericType<T> type, T object, Writer out) {
        try {
            this.writer(type).writeValue(out, object);
            out.flush();
        }
        catch (IOException e) {
            throw new JacksonRuntimeException("Failed to serialize to JSON: " + String.valueOf(type), e);
        }
    }

    private void write(GenericType<T> type, T object, OutputStream out) {
        try (OutputStream outputStream = out;){
            this.writer(type).writeValue(out, object);
        }
        catch (IOException e) {
            throw new JacksonRuntimeException("Failed to serialize to JSON: " + String.valueOf(type), e);
        }
    }

    private ObjectWriter writer(GenericType<T> type) {
        Type t = type.type();
        if (t instanceof ParameterizedType) {
            JavaType javaType = this.objectMapper.getTypeFactory().constructType(t);
            return this.objectMapper.writerFor(javaType);
        }
        return this.objectMapper.writerFor(type.rawType());
    }
}

