/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.cj.x;

import com.mysql.cj.api.x.NodeSession;
import com.mysql.cj.api.x.XSession;
import com.mysql.cj.api.x.XSessionFactory;
import com.mysql.cj.core.conf.url.ConnectionUrl;
import com.mysql.cj.core.conf.url.HostInfo;
import com.mysql.cj.core.exceptions.CJCommunicationsException;
import com.mysql.cj.core.exceptions.ExceptionFactory;
import com.mysql.cj.core.exceptions.InvalidConnectionAttributeException;
import com.mysql.cj.mysqlx.devapi.NodeSessionImpl;
import com.mysql.cj.mysqlx.devapi.SessionImpl;
import java.util.Properties;

public class MysqlxSessionFactory
implements XSessionFactory {
    private ConnectionUrl parseUrl(String url) {
        ConnectionUrl connUrl = ConnectionUrl.getConnectionUrlInstance(url, null);
        if (connUrl.getType() != ConnectionUrl.Type.MYSQLX_SESSION) {
            throw ExceptionFactory.createException(InvalidConnectionAttributeException.class, "Initialization via URL failed for \"" + url + "\"");
        }
        return connUrl;
    }

    @Override
    public XSession getSession(String url) {
        CJCommunicationsException latestException = null;
        ConnectionUrl connUrl = this.parseUrl(url);
        for (HostInfo hi : connUrl.getHostsList()) {
            try {
                return new SessionImpl(hi.exposeAsProperties());
            }
            catch (CJCommunicationsException e) {
                latestException = e;
            }
        }
        if (latestException != null) {
            throw latestException;
        }
        return null;
    }

    @Override
    public XSession getSession(Properties properties) {
        return new SessionImpl(properties);
    }

    @Override
    public NodeSession getNodeSession(String url) {
        ConnectionUrl connUrl = this.parseUrl(url);
        if (connUrl.getHostsList().size() > 1) {
            throw ExceptionFactory.createException(InvalidConnectionAttributeException.class, "A NodeSession cannot be initialized with a multi-host URL.");
        }
        return new NodeSessionImpl(connUrl.getMainHost().exposeAsProperties());
    }

    @Override
    public NodeSession getNodeSession(Properties properties) {
        return new NodeSessionImpl(properties);
    }
}

