/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.net;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.cassandra.net.Message;
import org.apache.cassandra.net.MessageProducer;

public class CachingMessageProducer
implements MessageProducer {
    private final MessageProducer prod;
    private final Map<Integer, Message> messages = new HashMap<Integer, Message>(2);

    public CachingMessageProducer(MessageProducer prod) {
        this.prod = prod;
    }

    @Override
    public synchronized Message getMessage(Integer version) throws IOException {
        Message msg = this.messages.get(version);
        if (msg == null) {
            msg = this.prod.getMessage(version);
            this.messages.put(version, msg);
        }
        return msg;
    }
}

