/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.service;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Map;
import org.apache.cassandra.db.ColumnFamily;
import org.apache.cassandra.db.ReadResponse;
import org.apache.cassandra.db.Row;
import org.apache.cassandra.service.AbstractRowResolver;
import org.apache.cassandra.service.DigestMismatchException;

public class RowDigestResolver
extends AbstractRowResolver {
    public RowDigestResolver(String table, ByteBuffer key) {
        super(key, table);
    }

    @Override
    public Row getData() throws IOException {
        for (Map.Entry entry : this.replies.entrySet()) {
            ReadResponse result = (ReadResponse)entry.getValue();
            if (result.isDigestQuery()) continue;
            return result.row();
        }
        throw new AssertionError((Object)"getData should not be invoked when no data is present");
    }

    @Override
    public Row resolve() throws DigestMismatchException, IOException {
        if (logger.isDebugEnabled()) {
            logger.debug("resolving " + this.replies.size() + " responses");
        }
        long startTime = System.currentTimeMillis();
        ColumnFamily data = null;
        ByteBuffer digest = null;
        for (Map.Entry entry : this.replies.entrySet()) {
            ReadResponse response = (ReadResponse)entry.getValue();
            if (response.isDigestQuery()) {
                if (digest == null) {
                    digest = response.digest();
                    continue;
                }
                ByteBuffer digest2 = response.digest();
                if (digest.equals(digest2)) continue;
                throw new DigestMismatchException(this.key, digest, digest2);
            }
            data = response.row().cf;
        }
        if (digest != null) {
            ByteBuffer digest2 = ColumnFamily.digest(data);
            if (!digest.equals(digest2)) {
                throw new DigestMismatchException(this.key, digest, digest2);
            }
            if (logger.isDebugEnabled()) {
                logger.debug("digests verified");
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug("resolve: " + (System.currentTimeMillis() - startTime) + " ms.");
        }
        return new Row(this.key, data);
    }

    @Override
    public boolean isDataPresent() {
        for (ReadResponse result : this.replies.values()) {
            if (result.isDigestQuery()) continue;
            return true;
        }
        return false;
    }
}

