/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.tools.rumen;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.TaskStatus;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.JobID;
import org.apache.hadoop.mapreduce.TaskAttemptID;
import org.apache.hadoop.mapreduce.TaskID;
import org.apache.hadoop.mapreduce.TaskType;
import org.apache.hadoop.mapreduce.lib.input.FileSplit;
import org.apache.hadoop.tools.rumen.CDFPiecewiseLinearRandomGenerator;
import org.apache.hadoop.tools.rumen.CDFRandomGenerator;
import org.apache.hadoop.tools.rumen.ClusterStory;
import org.apache.hadoop.tools.rumen.JobStory;
import org.apache.hadoop.tools.rumen.LoggedDiscreteCDF;
import org.apache.hadoop.tools.rumen.LoggedJob;
import org.apache.hadoop.tools.rumen.LoggedLocation;
import org.apache.hadoop.tools.rumen.LoggedTask;
import org.apache.hadoop.tools.rumen.LoggedTaskAttempt;
import org.apache.hadoop.tools.rumen.MachineNode;
import org.apache.hadoop.tools.rumen.MapTaskAttemptInfo;
import org.apache.hadoop.tools.rumen.ParsedHost;
import org.apache.hadoop.tools.rumen.Pre21JobHistoryConstants;
import org.apache.hadoop.tools.rumen.RandomSeedGenerator;
import org.apache.hadoop.tools.rumen.ReduceTaskAttemptInfo;
import org.apache.hadoop.tools.rumen.TaskAttemptInfo;
import org.apache.hadoop.tools.rumen.TaskInfo;

public class ZombieJob
implements JobStory {
    static final Log LOG = LogFactory.getLog(ZombieJob.class);
    private final LoggedJob job;
    private Map<TaskID, LoggedTask> loggedTaskMap;
    private Map<TaskAttemptID, LoggedTaskAttempt> loggedTaskAttemptMap;
    private final Random random;
    private InputSplit[] splits;
    private final ClusterStory cluster;
    private JobConf jobConf;
    private long seed;
    private long numRandomSeeds = 0L;
    private boolean hasRandomSeed = false;
    private Map<LoggedDiscreteCDF, CDFRandomGenerator> interpolatorMap = new HashMap<LoggedDiscreteCDF, CDFRandomGenerator>();
    double rackLocalOverNodeLocal = 1.5;
    double rackRemoteOverNodeLocal = 3.0;

    public ZombieJob(LoggedJob job, ClusterStory cluster, long seed) {
        if (job == null) {
            throw new IllegalArgumentException("job is null");
        }
        this.job = job;
        this.cluster = cluster;
        this.random = new Random(seed);
        this.seed = seed;
        this.hasRandomSeed = true;
    }

    public ZombieJob(LoggedJob job, ClusterStory cluster) {
        this(job, cluster, System.nanoTime());
    }

    private static TaskStatus.State convertState(Pre21JobHistoryConstants.Values status) {
        if (status == Pre21JobHistoryConstants.Values.SUCCESS) {
            return TaskStatus.State.SUCCEEDED;
        }
        if (status == Pre21JobHistoryConstants.Values.FAILED) {
            return TaskStatus.State.FAILED;
        }
        if (status == Pre21JobHistoryConstants.Values.KILLED) {
            return TaskStatus.State.KILLED;
        }
        throw new IllegalArgumentException("unknown status " + (Object)((Object)status));
    }

    @Override
    public synchronized JobConf getJobConf() {
        if (this.jobConf == null) {
            this.jobConf = new JobConf();
            this.jobConf.setJobName(this.getName());
            this.jobConf.setUser(this.getUser());
            this.jobConf.setNumMapTasks(this.getNumberMaps());
            this.jobConf.setNumReduceTasks(this.getNumberReduces());
            this.jobConf.setQueueName(this.getQueueName());
        }
        return this.jobConf;
    }

    @Override
    public InputSplit[] getInputSplits() {
        if (this.splits == null) {
            int avgHostPerSplit;
            ArrayList<FileSplit> splitsList = new ArrayList<FileSplit>();
            Path emptyPath = new Path("/");
            int totalHosts = 0;
            for (LoggedTask mapTask : this.job.getMapTasks()) {
                Pre21JobHistoryConstants.Values taskType = mapTask.getTaskType();
                if (taskType != Pre21JobHistoryConstants.Values.MAP) {
                    LOG.warn((Object)("TaskType for a MapTask is not Map. task=" + mapTask.getTaskID() + " type=" + (taskType == null ? "null" : taskType.toString())));
                    continue;
                }
                List<LoggedLocation> locations = mapTask.getPreferredLocations();
                ArrayList<String> hostList = new ArrayList<String>();
                if (locations != null) {
                    for (LoggedLocation location : locations) {
                        List<String> layers = location.getLayers();
                        if (layers.size() == 0) {
                            LOG.warn((Object)("Bad location layer format for task " + mapTask.getTaskID()));
                            continue;
                        }
                        String host = layers.get(layers.size() - 1);
                        if (host == null) {
                            LOG.warn((Object)("Bad location layer format for task " + mapTask.getTaskID() + ": " + layers));
                            continue;
                        }
                        hostList.add(host);
                    }
                }
                String[] hosts = hostList.toArray(new String[hostList.size()]);
                totalHosts += hosts.length;
                long mapInputBytes = this.getTaskInfo(mapTask).getInputBytes();
                if (mapInputBytes < 0L) {
                    LOG.warn((Object)("InputBytes for task " + mapTask.getTaskID() + " is not defined."));
                    mapInputBytes = 0L;
                }
                splitsList.add(new FileSplit(emptyPath, 0L, mapInputBytes, hosts));
            }
            int totalMaps = this.job.getTotalMaps();
            if (totalMaps < splitsList.size()) {
                LOG.warn((Object)("TotalMaps for job " + this.job.getJobID() + " is less than the total number of map task descriptions (" + totalMaps + "<" + splitsList.size() + ")."));
            }
            if (splitsList.size() == 0) {
                avgHostPerSplit = 3;
            } else {
                avgHostPerSplit = totalHosts / splitsList.size();
                if (avgHostPerSplit == 0) {
                    avgHostPerSplit = 3;
                }
            }
            for (int i = splitsList.size(); i < totalMaps; ++i) {
                if (this.cluster == null) {
                    splitsList.add(new FileSplit(emptyPath, 0L, 0L, new String[0]));
                    continue;
                }
                MachineNode[] mNodes = this.cluster.getRandomMachines(avgHostPerSplit, this.random);
                String[] hosts = new String[mNodes.length];
                for (int j = 0; j < hosts.length; ++j) {
                    hosts[j] = mNodes[j].getName();
                }
                splitsList.add(new FileSplit(emptyPath, 0L, 0L, hosts));
            }
            this.splits = splitsList.toArray(new InputSplit[splitsList.size()]);
        }
        return this.splits;
    }

    @Override
    public String getName() {
        String jobName = this.job.getJobName();
        if (jobName == null) {
            return "(name unknown)";
        }
        return jobName;
    }

    @Override
    public JobID getJobID() {
        return JobID.forName((String)this.getLoggedJob().getJobID());
    }

    private int sanitizeValue(int oldVal, int defaultVal, String name, String id) {
        if (oldVal == -1) {
            LOG.warn((Object)(name + " not defined for " + id));
            return defaultVal;
        }
        return oldVal;
    }

    @Override
    public int getNumberMaps() {
        return this.sanitizeValue(this.job.getTotalMaps(), 0, "NumberMaps", this.job.getJobID());
    }

    @Override
    public int getNumberReduces() {
        return this.sanitizeValue(this.job.getTotalReduces(), 0, "NumberReduces", this.job.getJobID());
    }

    @Override
    public Pre21JobHistoryConstants.Values getOutcome() {
        return this.job.getOutcome();
    }

    @Override
    public long getSubmissionTime() {
        return this.job.getSubmitTime() - this.job.getRelativeTime();
    }

    @Override
    public String getQueueName() {
        String queue = this.job.getQueue();
        return queue == null ? "default" : queue;
    }

    public int getNumLoggedMaps() {
        return this.job.getMapTasks().size();
    }

    public int getNumLoggedReduces() {
        return this.job.getReduceTasks().size();
    }

    private TaskID maskTaskID(TaskID taskId) {
        JobID jobId = new JobID();
        return new TaskID(jobId, taskId.isMap(), taskId.getId());
    }

    private TaskAttemptID maskAttemptID(TaskAttemptID attemptId) {
        JobID jobId = new JobID();
        TaskID taskId = attemptId.getTaskID();
        return new TaskAttemptID(jobId.getJtIdentifier(), jobId.getId(), taskId.isMap(), taskId.getId(), attemptId.getId());
    }

    private LoggedTask sanitizeLoggedTask(LoggedTask task) {
        if (task == null) {
            return null;
        }
        if (task.getTaskType() == null) {
            LOG.warn((Object)("Task " + task.getTaskID() + " has nulll TaskType"));
            return null;
        }
        if (task.getTaskStatus() == null) {
            LOG.warn((Object)("Task " + task.getTaskID() + " has nulll TaskStatus"));
            return null;
        }
        return task;
    }

    private LoggedTaskAttempt sanitizeLoggedTaskAttempt(LoggedTaskAttempt attempt) {
        if (attempt == null) {
            return null;
        }
        if (attempt.getResult() == null) {
            LOG.warn((Object)("TaskAttempt " + (Object)((Object)attempt.getResult()) + " has nulll Result"));
            return null;
        }
        return attempt;
    }

    private synchronized void buildMaps() {
        if (this.loggedTaskMap == null) {
            TaskAttemptID id;
            this.loggedTaskMap = new HashMap<TaskID, LoggedTask>();
            this.loggedTaskAttemptMap = new HashMap<TaskAttemptID, LoggedTaskAttempt>();
            for (LoggedTask map : this.job.getMapTasks()) {
                if ((map = this.sanitizeLoggedTask(map)) == null) continue;
                this.loggedTaskMap.put(this.maskTaskID(TaskID.forName((String)map.taskID)), map);
                for (LoggedTaskAttempt mapAttempt : map.getAttempts()) {
                    if ((mapAttempt = this.sanitizeLoggedTaskAttempt(mapAttempt)) == null) continue;
                    id = TaskAttemptID.forName((String)mapAttempt.getAttemptID());
                    this.loggedTaskAttemptMap.put(this.maskAttemptID(id), mapAttempt);
                }
            }
            for (LoggedTask reduce : this.job.getReduceTasks()) {
                if ((reduce = this.sanitizeLoggedTask(reduce)) == null) continue;
                this.loggedTaskMap.put(this.maskTaskID(TaskID.forName((String)reduce.taskID)), reduce);
                for (LoggedTaskAttempt reduceAttempt : reduce.getAttempts()) {
                    if ((reduceAttempt = this.sanitizeLoggedTaskAttempt(reduceAttempt)) == null) continue;
                    id = TaskAttemptID.forName((String)reduceAttempt.getAttemptID());
                    this.loggedTaskAttemptMap.put(this.maskAttemptID(id), reduceAttempt);
                }
            }
        }
    }

    @Override
    public String getUser() {
        String retval = this.job.getUser();
        return retval == null ? "(unknown)" : retval;
    }

    public LoggedJob getLoggedJob() {
        return this.job;
    }

    @Override
    public TaskAttemptInfo getTaskAttemptInfo(TaskType taskType, int taskNumber, int taskAttemptNumber) {
        int locality = 0;
        LoggedTask loggedTask = this.getLoggedTask(taskType, taskNumber);
        if (loggedTask == null) {
            TaskInfo taskInfo = new TaskInfo(0L, 0, 0L, 0, 0L);
            return this.makeUpTaskAttemptInfo(taskType, taskInfo, taskAttemptNumber, taskNumber, locality);
        }
        LoggedTaskAttempt loggedAttempt = this.getLoggedTaskAttempt(taskType, taskNumber, taskAttemptNumber);
        if (loggedAttempt == null) {
            TaskInfo taskInfo = this.getTaskInfo(loggedTask);
            return this.makeUpTaskAttemptInfo(taskType, taskInfo, taskAttemptNumber, taskNumber, locality);
        }
        if (loggedAttempt.getResult() == Pre21JobHistoryConstants.Values.KILLED) {
            TaskInfo taskInfo = this.getTaskInfo(loggedTask);
            return this.makeUpTaskAttemptInfo(taskType, taskInfo, taskAttemptNumber, taskNumber, locality);
        }
        return this.getTaskAttemptInfo(loggedTask, loggedAttempt);
    }

    @Override
    public TaskInfo getTaskInfo(TaskType taskType, int taskNumber) {
        return this.getTaskInfo(this.getLoggedTask(taskType, taskNumber));
    }

    @Override
    public TaskAttemptInfo getMapTaskAttemptInfoAdjusted(int taskNumber, int taskAttemptNumber, int locality) {
        TaskType taskType = TaskType.MAP;
        LoggedTask loggedTask = this.getLoggedTask(taskType, taskNumber);
        if (loggedTask == null) {
            TaskInfo taskInfo = new TaskInfo(0L, 0, 0L, 0, 0L);
            return this.makeUpTaskAttemptInfo(taskType, taskInfo, taskAttemptNumber, taskNumber, locality);
        }
        LoggedTaskAttempt loggedAttempt = this.getLoggedTaskAttempt(taskType, taskNumber, taskAttemptNumber);
        if (loggedAttempt == null) {
            TaskInfo taskInfo = this.getTaskInfo(loggedTask);
            return this.makeUpTaskAttemptInfo(taskType, taskInfo, taskAttemptNumber, taskNumber, locality);
        }
        if (loggedAttempt.getResult() == Pre21JobHistoryConstants.Values.KILLED) {
            TaskInfo taskInfo = this.getTaskInfo(loggedTask);
            return this.makeUpTaskAttemptInfo(taskType, taskInfo, taskAttemptNumber, taskNumber, locality);
        }
        if (loggedAttempt.getResult() == Pre21JobHistoryConstants.Values.FAILED) {
            return this.getTaskAttemptInfo(loggedTask, loggedAttempt);
        }
        if (loggedAttempt.getResult() == Pre21JobHistoryConstants.Values.SUCCESS) {
            int loggedLocality = this.getLocality(loggedTask, loggedAttempt);
            if (locality == loggedLocality) {
                return this.getTaskAttemptInfo(loggedTask, loggedAttempt);
            }
            return this.scaleInfo(loggedTask, loggedAttempt, locality, loggedLocality, this.rackLocalOverNodeLocal, this.rackRemoteOverNodeLocal);
        }
        throw new IllegalArgumentException("attempt result is not SUCCEEDED, FAILED or KILLED: " + (Object)((Object)loggedAttempt.getResult()));
    }

    private long sanitizeTaskRuntime(long time, String id) {
        if (time < 0L) {
            LOG.warn((Object)("Negative running time for task " + id + ": " + time));
            return 100L;
        }
        return time;
    }

    private TaskAttemptInfo scaleInfo(LoggedTask loggedTask, LoggedTaskAttempt loggedAttempt, int locality, int loggedLocality, double rackLocalOverNodeLocal, double rackRemoteOverNodeLocal) {
        TaskInfo taskInfo = this.getTaskInfo(loggedTask);
        double[] factors = new double[]{1.0, rackLocalOverNodeLocal, rackRemoteOverNodeLocal};
        double scaleFactor = factors[locality] / factors[loggedLocality];
        TaskStatus.State state = ZombieJob.convertState(loggedAttempt.getResult());
        if (loggedTask.getTaskType() == Pre21JobHistoryConstants.Values.MAP) {
            long taskTime = 0L;
            taskTime = loggedAttempt.getStartTime() == 0L ? this.makeUpMapRuntime(state, locality) : loggedAttempt.getFinishTime() - loggedAttempt.getStartTime();
            taskTime = this.sanitizeTaskRuntime(taskTime, loggedAttempt.getAttemptID());
            taskTime = (long)((double)taskTime * scaleFactor);
            return new MapTaskAttemptInfo(state, taskInfo, taskTime);
        }
        throw new IllegalArgumentException("taskType can only be MAP: " + (Object)((Object)loggedTask.getTaskType()));
    }

    private int getLocality(LoggedTask loggedTask, LoggedTaskAttempt loggedAttempt) {
        int distance = this.cluster.getMaximumDistance();
        String rackHostName = loggedAttempt.getHostName();
        if (rackHostName == null) {
            return distance;
        }
        MachineNode mn = this.getMachineNode(rackHostName);
        if (mn == null) {
            return distance;
        }
        List<LoggedLocation> locations = loggedTask.getPreferredLocations();
        if (locations != null) {
            for (LoggedLocation location : locations) {
                String dataNodeName;
                MachineNode dataNode;
                List<String> layers = location.getLayers();
                if (layers == null || layers.isEmpty() || (dataNode = this.cluster.getMachineByName(dataNodeName = layers.get(layers.size() - 1))) == null) continue;
                distance = Math.min(distance, this.cluster.distance(mn, dataNode));
            }
        }
        return distance;
    }

    private MachineNode getMachineNode(String rackHostName) {
        String hostName;
        ParsedHost parsedHost = ParsedHost.parse(rackHostName);
        String string = hostName = parsedHost == null ? rackHostName : parsedHost.getNodeName();
        if (hostName == null) {
            return null;
        }
        return this.cluster == null ? null : this.cluster.getMachineByName(hostName);
    }

    private TaskAttemptInfo getTaskAttemptInfo(LoggedTask loggedTask, LoggedTaskAttempt loggedAttempt) {
        TaskInfo taskInfo = this.getTaskInfo(loggedTask);
        TaskStatus.State state = ZombieJob.convertState(loggedAttempt.getResult());
        if (loggedTask.getTaskType() == Pre21JobHistoryConstants.Values.MAP) {
            long taskTime;
            if (loggedAttempt.getStartTime() == 0L) {
                int locality = this.getLocality(loggedTask, loggedAttempt);
                taskTime = this.makeUpMapRuntime(state, locality);
            } else {
                taskTime = loggedAttempt.getFinishTime() - loggedAttempt.getStartTime();
            }
            taskTime = this.sanitizeTaskRuntime(taskTime, loggedAttempt.getAttemptID());
            return new MapTaskAttemptInfo(state, taskInfo, taskTime);
        }
        if (loggedTask.getTaskType() == Pre21JobHistoryConstants.Values.REDUCE) {
            long startTime = loggedAttempt.getStartTime();
            long mergeDone = loggedAttempt.getSortFinished();
            long shuffleDone = loggedAttempt.getShuffleFinished();
            long finishTime = loggedAttempt.getFinishTime();
            if (startTime <= 0L || startTime >= finishTime) {
                long reduceTime = this.makeUpReduceRuntime(state);
                return new ReduceTaskAttemptInfo(state, taskInfo, 0L, 0L, reduceTime);
            }
            if (shuffleDone <= 0L) {
                shuffleDone = startTime;
            }
            if (mergeDone <= 0L) {
                mergeDone = finishTime;
            }
            long shuffleTime = shuffleDone - startTime;
            long mergeTime = mergeDone - shuffleDone;
            long reduceTime = finishTime - mergeDone;
            reduceTime = this.sanitizeTaskRuntime(reduceTime, loggedAttempt.getAttemptID());
            return new ReduceTaskAttemptInfo(state, taskInfo, shuffleTime, mergeTime, reduceTime);
        }
        throw new IllegalArgumentException("taskType for " + loggedTask.getTaskID() + " is neither MAP nor REDUCE: " + (Object)((Object)loggedTask.getTaskType()));
    }

    private TaskInfo getTaskInfo(LoggedTask loggedTask) {
        List<LoggedTaskAttempt> attempts = loggedTask.getAttempts();
        long inputBytes = -1L;
        long inputRecords = -1L;
        long outputBytes = -1L;
        long outputRecords = -1L;
        long heapMegabytes = -1L;
        Pre21JobHistoryConstants.Values type = loggedTask.getTaskType();
        if (type != Pre21JobHistoryConstants.Values.MAP && type != Pre21JobHistoryConstants.Values.REDUCE) {
            throw new IllegalArgumentException("getTaskInfo only supports MAP or REDUCE tasks: " + type.toString() + " for task = " + loggedTask.getTaskID());
        }
        for (LoggedTaskAttempt attempt : attempts) {
            if ((attempt = this.sanitizeLoggedTaskAttempt(attempt)) == null || attempt.getResult() != Pre21JobHistoryConstants.Values.SUCCESS) continue;
            if (type == Pre21JobHistoryConstants.Values.MAP) {
                inputBytes = attempt.getHdfsBytesRead();
                inputRecords = attempt.getMapInputRecords();
                outputBytes = this.job.getTotalReduces() > 0 ? attempt.getMapOutputBytes() : attempt.getHdfsBytesWritten();
                outputRecords = attempt.getMapOutputRecords();
                heapMegabytes = this.job.getJobMapMB() > 0 ? (long)this.job.getJobMapMB() : (long)this.job.getHeapMegabytes();
                break;
            }
            inputBytes = attempt.getReduceShuffleBytes();
            inputRecords = attempt.getReduceInputRecords();
            outputBytes = attempt.getHdfsBytesWritten();
            outputRecords = attempt.getReduceOutputRecords();
            heapMegabytes = this.job.getJobReduceMB() > 0 ? (long)this.job.getJobReduceMB() : (long)this.job.getHeapMegabytes();
            break;
        }
        TaskInfo taskInfo = new TaskInfo(inputBytes, (int)inputRecords, outputBytes, (int)outputRecords, (int)heapMegabytes);
        return taskInfo;
    }

    private TaskAttemptID makeTaskAttemptID(TaskType taskType, int taskNumber, int taskAttemptNumber) {
        return new TaskAttemptID(new TaskID(JobID.forName((String)this.job.getJobID()), taskType == TaskType.MAP, taskNumber), taskAttemptNumber);
    }

    private TaskAttemptInfo makeUpTaskAttemptInfo(TaskType taskType, TaskInfo taskInfo, int taskAttemptNumber, int taskNumber, int locality) {
        if (taskType == TaskType.MAP) {
            TaskStatus.State state = TaskStatus.State.SUCCEEDED;
            long runtime = 0L;
            state = this.makeUpState(taskAttemptNumber, this.job.getMapperTriesToSucceed());
            runtime = this.makeUpMapRuntime(state, locality);
            runtime = this.sanitizeTaskRuntime(runtime, this.makeTaskAttemptID(taskType, taskNumber, taskAttemptNumber).toString());
            MapTaskAttemptInfo tai = new MapTaskAttemptInfo(state, taskInfo, runtime);
            return tai;
        }
        if (taskType == TaskType.REDUCE) {
            TaskStatus.State state = TaskStatus.State.SUCCEEDED;
            long shuffleTime = 0L;
            long sortTime = 0L;
            long reduceTime = 0L;
            reduceTime = this.makeUpReduceRuntime(state);
            ReduceTaskAttemptInfo tai = new ReduceTaskAttemptInfo(state, taskInfo, shuffleTime, sortTime, reduceTime);
            return tai;
        }
        throw new IllegalArgumentException("taskType is neither MAP nor REDUCE: " + taskType);
    }

    private long makeUpReduceRuntime(TaskStatus.State state) {
        long reduceTime = 0L;
        for (int i = 0; i < 5; ++i) {
            reduceTime = this.doMakeUpReduceRuntime(state);
            if (reduceTime < 0L) continue;
            return reduceTime;
        }
        return 0L;
    }

    private long doMakeUpReduceRuntime(TaskStatus.State state) {
        try {
            long reduceTime;
            if (state == TaskStatus.State.SUCCEEDED) {
                reduceTime = this.makeUpRuntime(this.job.getSuccessfulReduceAttemptCDF());
            } else if (state == TaskStatus.State.FAILED) {
                reduceTime = this.makeUpRuntime(this.job.getFailedReduceAttemptCDF());
            } else {
                throw new IllegalArgumentException("state is neither SUCCEEDED nor FAILED: " + state);
            }
            return reduceTime;
        }
        catch (NoValueToMakeUpRuntime e) {
            return 0L;
        }
    }

    private long makeUpMapRuntime(TaskStatus.State state, int locality) {
        long runtime;
        if (state == TaskStatus.State.SUCCEEDED || state == TaskStatus.State.FAILED) {
            ArrayList<LoggedDiscreteCDF> cdfList = state == TaskStatus.State.SUCCEEDED ? this.job.getSuccessfulMapAttemptCDFs() : this.job.getFailedMapAttemptCDFs();
            try {
                runtime = this.makeUpRuntime((LoggedDiscreteCDF)cdfList.get(locality));
            }
            catch (NoValueToMakeUpRuntime e) {
                runtime = this.makeUpRuntime(cdfList);
            }
        } else {
            throw new IllegalArgumentException("state is neither SUCCEEDED nor FAILED: " + state);
        }
        return runtime;
    }

    private long makeUpRuntime(List<LoggedDiscreteCDF> mapAttemptCDFs) {
        int total = 0;
        for (LoggedDiscreteCDF cdf : mapAttemptCDFs) {
            total = (int)((long)total + cdf.getNumberValues());
        }
        if (total == 0) {
            return -1L;
        }
        int index = this.random.nextInt(total);
        for (LoggedDiscreteCDF cdf : mapAttemptCDFs) {
            if ((long)index >= cdf.getNumberValues()) {
                index = (int)((long)index - cdf.getNumberValues());
                continue;
            }
            if (index < 0) {
                throw new IllegalStateException("application error");
            }
            return this.makeUpRuntime(cdf);
        }
        throw new IllegalStateException("not possible to get here");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long makeUpRuntime(LoggedDiscreteCDF loggedDiscreteCDF) {
        if (this.hasRandomSeed) {
            Map<LoggedDiscreteCDF, CDFRandomGenerator> map = this.interpolatorMap;
            synchronized (map) {
                return this.makeUpRuntimeCore(loggedDiscreteCDF);
            }
        }
        return this.makeUpRuntimeCore(loggedDiscreteCDF);
    }

    private synchronized long getNextRandomSeed() {
        ++this.numRandomSeeds;
        return RandomSeedGenerator.getSeed("forZombieJob" + this.job.getJobID(), this.numRandomSeeds);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long makeUpRuntimeCore(LoggedDiscreteCDF loggedDiscreteCDF) {
        CDFRandomGenerator interpolator;
        Map<LoggedDiscreteCDF, CDFRandomGenerator> map = this.interpolatorMap;
        synchronized (map) {
            interpolator = this.interpolatorMap.get(loggedDiscreteCDF);
        }
        if (interpolator == null) {
            if (loggedDiscreteCDF.getNumberValues() == 0L) {
                throw new NoValueToMakeUpRuntime("no value to use to make up runtime");
            }
            interpolator = this.hasRandomSeed ? new CDFPiecewiseLinearRandomGenerator(loggedDiscreteCDF, this.getNextRandomSeed()) : new CDFPiecewiseLinearRandomGenerator(loggedDiscreteCDF);
            map = this.interpolatorMap;
            synchronized (map) {
                this.interpolatorMap.put(loggedDiscreteCDF, interpolator);
            }
        }
        return interpolator.randomValue();
    }

    private TaskStatus.State makeUpState(int taskAttemptNumber, double[] numAttempts) {
        if (taskAttemptNumber >= numAttempts.length - 1) {
            return TaskStatus.State.SUCCEEDED;
        }
        double pSucceed = numAttempts[taskAttemptNumber];
        double pFail = 0.0;
        for (int i = taskAttemptNumber + 1; i < numAttempts.length; ++i) {
            pFail += numAttempts[i];
        }
        return this.random.nextDouble() < pSucceed / (pSucceed + pFail) ? TaskStatus.State.SUCCEEDED : TaskStatus.State.FAILED;
    }

    private TaskID getMaskedTaskID(TaskType taskType, int taskNumber) {
        return new TaskID(new JobID(), taskType == TaskType.MAP, taskNumber);
    }

    private LoggedTask getLoggedTask(TaskType taskType, int taskNumber) {
        this.buildMaps();
        return this.loggedTaskMap.get(this.getMaskedTaskID(taskType, taskNumber));
    }

    private LoggedTaskAttempt getLoggedTaskAttempt(TaskType taskType, int taskNumber, int taskAttemptNumber) {
        this.buildMaps();
        TaskAttemptID id = new TaskAttemptID(this.getMaskedTaskID(taskType, taskNumber), taskAttemptNumber);
        return this.loggedTaskAttemptMap.get(id);
    }

    private static class NoValueToMakeUpRuntime
    extends IllegalArgumentException {
        static final long serialVersionUID = 1L;

        NoValueToMakeUpRuntime() {
        }

        NoValueToMakeUpRuntime(String detailMessage) {
            super(detailMessage);
        }

        NoValueToMakeUpRuntime(String detailMessage, Throwable cause) {
            super(detailMessage, cause);
        }

        NoValueToMakeUpRuntime(Throwable cause) {
            super(cause);
        }
    }
}

