/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.index.solr.util;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.StringWriter;
import javax.jcr.Session;
import javax.jcr.nodetype.NodeType;
import javax.jcr.nodetype.NodeTypeIterator;

public class NodeTypeIndexingUtils {
    public static File createPrimaryTypeSynonymsFile(String path, Session session) throws Exception {
        File file = new File(path);
        StringWriter stringWriter = new StringWriter();
        NodeTypeIterator allNodeTypes = session.getWorkspace().getNodeTypeManager().getAllNodeTypes();
        while (allNodeTypes.hasNext()) {
            NodeType nodeType = allNodeTypes.nextNodeType();
            NodeType[] superTypes = nodeType.getSupertypes();
            if (superTypes == null || superTypes.length <= 0) continue;
            stringWriter.append(nodeType.getName()).append(" => ");
            for (int i = 0; i < superTypes.length; ++i) {
                stringWriter.append(superTypes[i].getName());
                if (i < superTypes.length - 1) {
                    stringWriter.append(',');
                }
                stringWriter.append(' ');
            }
            stringWriter.append('\n');
        }
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        fileOutputStream.write(stringWriter.toString().getBytes("UTF-8"));
        fileOutputStream.flush();
        fileOutputStream.close();
        if (file.exists() || file.createNewFile()) {
            return file;
        }
        throw new IOException("primary types synonyms file could not be created");
    }
}

