/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.join;

import java.io.IOException;
import org.apache.lucene.index.AtomicReaderContext;
import org.apache.lucene.index.BinaryDocValues;
import org.apache.lucene.index.SortedSetDocValues;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.FieldCache;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.join.ScoreMode;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefHash;

abstract class TermsWithScoreCollector
extends Collector {
    private static final int INITIAL_ARRAY_SIZE = 256;
    final String field;
    final BytesRefHash collectedTerms = new BytesRefHash();
    final ScoreMode scoreMode;
    Scorer scorer;
    float[] scoreSums = new float[256];

    TermsWithScoreCollector(String field, ScoreMode scoreMode) {
        this.field = field;
        this.scoreMode = scoreMode;
    }

    public BytesRefHash getCollectedTerms() {
        return this.collectedTerms;
    }

    public float[] getScoresPerTerm() {
        return this.scoreSums;
    }

    @Override
    public void setScorer(Scorer scorer) throws IOException {
        this.scorer = scorer;
    }

    @Override
    public boolean acceptsDocsOutOfOrder() {
        return true;
    }

    static TermsWithScoreCollector create(String field, boolean multipleValuesPerDocument, ScoreMode scoreMode) {
        if (multipleValuesPerDocument) {
            switch (scoreMode) {
                case Avg: {
                    return new MV.Avg(field);
                }
            }
            return new MV(field, scoreMode);
        }
        switch (scoreMode) {
            case Avg: {
                return new SV.Avg(field);
            }
        }
        return new SV(field, scoreMode);
    }

    static class MV
    extends TermsWithScoreCollector {
        SortedSetDocValues fromDocTermOrds;
        final BytesRef scratch = new BytesRef();

        MV(String field, ScoreMode scoreMode) {
            super(field, scoreMode);
        }

        @Override
        public void collect(int doc) throws IOException {
            long ord;
            this.fromDocTermOrds.setDocument(doc);
            while ((ord = this.fromDocTermOrds.nextOrd()) != -1L) {
                this.fromDocTermOrds.lookupOrd(ord, this.scratch);
                int termID = this.collectedTerms.add(this.scratch);
                if (termID < 0) {
                    termID = -termID - 1;
                } else if (termID >= this.scoreSums.length) {
                    this.scoreSums = ArrayUtil.grow(this.scoreSums);
                }
                switch (this.scoreMode) {
                    case Total: {
                        int n = termID;
                        this.scoreSums[n] = this.scoreSums[n] + this.scorer.score();
                        break;
                    }
                    case Max: {
                        this.scoreSums[termID] = Math.max(this.scoreSums[termID], this.scorer.score());
                    }
                }
            }
        }

        @Override
        public void setNextReader(AtomicReaderContext context) throws IOException {
            this.fromDocTermOrds = FieldCache.DEFAULT.getDocTermOrds(context.reader(), this.field);
        }

        static class Avg
        extends MV {
            int[] scoreCounts = new int[256];

            Avg(String field) {
                super(field, ScoreMode.Avg);
            }

            @Override
            public void collect(int doc) throws IOException {
                long ord;
                this.fromDocTermOrds.setDocument(doc);
                while ((ord = this.fromDocTermOrds.nextOrd()) != -1L) {
                    this.fromDocTermOrds.lookupOrd(ord, this.scratch);
                    int termID = this.collectedTerms.add(this.scratch);
                    if (termID < 0) {
                        termID = -termID - 1;
                    } else if (termID >= this.scoreSums.length) {
                        this.scoreSums = ArrayUtil.grow(this.scoreSums);
                    }
                    int n = termID;
                    this.scoreSums[n] = this.scoreSums[n] + this.scorer.score();
                    int n2 = termID;
                    this.scoreCounts[n2] = this.scoreCounts[n2] + 1;
                }
            }

            @Override
            public float[] getScoresPerTerm() {
                if (this.scoreCounts != null) {
                    for (int i = 0; i < this.scoreCounts.length; ++i) {
                        this.scoreSums[i] = this.scoreSums[i] / (float)this.scoreCounts[i];
                    }
                    this.scoreCounts = null;
                }
                return this.scoreSums;
            }
        }
    }

    static class SV
    extends TermsWithScoreCollector {
        final BytesRef spare = new BytesRef();
        BinaryDocValues fromDocTerms;

        SV(String field, ScoreMode scoreMode) {
            super(field, scoreMode);
        }

        @Override
        public void collect(int doc) throws IOException {
            this.fromDocTerms.get(doc, this.spare);
            int ord = this.collectedTerms.add(this.spare);
            if (ord < 0) {
                ord = -ord - 1;
            } else if (ord >= this.scoreSums.length) {
                this.scoreSums = ArrayUtil.grow(this.scoreSums);
            }
            float current = this.scorer.score();
            float existing = this.scoreSums[ord];
            if (Float.compare(existing, 0.0f) == 0) {
                this.scoreSums[ord] = current;
            } else {
                switch (this.scoreMode) {
                    case Total: {
                        this.scoreSums[ord] = this.scoreSums[ord] + current;
                        break;
                    }
                    case Max: {
                        if (!(current > existing)) break;
                        this.scoreSums[ord] = current;
                    }
                }
            }
        }

        @Override
        public void setNextReader(AtomicReaderContext context) throws IOException {
            this.fromDocTerms = FieldCache.DEFAULT.getTerms(context.reader(), this.field, false);
        }

        static class Avg
        extends SV {
            int[] scoreCounts = new int[256];

            Avg(String field) {
                super(field, ScoreMode.Avg);
            }

            @Override
            public void collect(int doc) throws IOException {
                this.fromDocTerms.get(doc, this.spare);
                int ord = this.collectedTerms.add(this.spare);
                if (ord < 0) {
                    ord = -ord - 1;
                } else if (ord >= this.scoreSums.length) {
                    this.scoreSums = ArrayUtil.grow(this.scoreSums);
                    this.scoreCounts = ArrayUtil.grow(this.scoreCounts);
                }
                float current = this.scorer.score();
                float existing = this.scoreSums[ord];
                if (Float.compare(existing, 0.0f) == 0) {
                    this.scoreSums[ord] = current;
                    this.scoreCounts[ord] = 1;
                } else {
                    this.scoreSums[ord] = this.scoreSums[ord] + current;
                    int n = ord;
                    this.scoreCounts[n] = this.scoreCounts[n] + 1;
                }
            }

            @Override
            public float[] getScoresPerTerm() {
                if (this.scoreCounts != null) {
                    for (int i = 0; i < this.scoreCounts.length; ++i) {
                        this.scoreSums[i] = this.scoreSums[i] / (float)this.scoreCounts[i];
                    }
                    this.scoreCounts = null;
                }
                return this.scoreSums;
            }
        }
    }
}

