/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.suggest;

import java.io.File;
import java.io.IOException;
import java.util.Comparator;
import org.apache.lucene.search.suggest.InputIterator;
import org.apache.lucene.search.suggest.Sort;
import org.apache.lucene.store.ByteArrayDataInput;
import org.apache.lucene.store.ByteArrayDataOutput;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.IOUtils;

public class SortedInputIterator
implements InputIterator {
    private final InputIterator source;
    private File tempInput;
    private File tempSorted;
    private final Sort.ByteSequencesReader reader;
    private final Comparator<BytesRef> comparator;
    private final boolean hasPayloads;
    private boolean done = false;
    private long weight;
    private final BytesRef scratch = new BytesRef();
    private BytesRef payload = new BytesRef();
    private final Comparator<BytesRef> tieBreakByCostComparator = new Comparator<BytesRef>(){
        private final BytesRef leftScratch = new BytesRef();
        private final BytesRef rightScratch = new BytesRef();
        private final ByteArrayDataInput input = new ByteArrayDataInput();

        @Override
        public int compare(BytesRef left, BytesRef right) {
            int cmp;
            this.leftScratch.bytes = left.bytes;
            this.leftScratch.offset = left.offset;
            this.leftScratch.length = left.length;
            this.rightScratch.bytes = right.bytes;
            this.rightScratch.offset = right.offset;
            this.rightScratch.length = right.length;
            long leftCost = SortedInputIterator.this.decode(this.leftScratch, this.input);
            long rightCost = SortedInputIterator.this.decode(this.rightScratch, this.input);
            if (SortedInputIterator.this.hasPayloads) {
                SortedInputIterator.this.decodePayload(this.leftScratch, this.input);
                SortedInputIterator.this.decodePayload(this.rightScratch, this.input);
            }
            if ((cmp = SortedInputIterator.this.comparator.compare(this.leftScratch, this.rightScratch)) != 0) {
                return cmp;
            }
            if (leftCost < rightCost) {
                return -1;
            }
            if (leftCost > rightCost) {
                return 1;
            }
            return 0;
        }
    };

    public SortedInputIterator(InputIterator source) throws IOException {
        this(source, BytesRef.getUTF8SortedAsUnicodeComparator());
    }

    public SortedInputIterator(InputIterator source, Comparator<BytesRef> comparator) throws IOException {
        this.hasPayloads = source.hasPayloads();
        this.source = source;
        this.comparator = comparator;
        this.reader = this.sort();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BytesRef next() throws IOException {
        boolean success = false;
        if (this.done) {
            return null;
        }
        try {
            ByteArrayDataInput input = new ByteArrayDataInput();
            if (this.reader.read(this.scratch)) {
                this.weight = this.decode(this.scratch, input);
                if (this.hasPayloads) {
                    this.payload = this.decodePayload(this.scratch, input);
                }
                success = true;
                BytesRef bytesRef = this.scratch;
                return bytesRef;
            }
            this.close();
            this.done = true;
            success = true;
            BytesRef bytesRef = null;
            return bytesRef;
        }
        finally {
            if (!success) {
                this.done = true;
                this.close();
            }
        }
    }

    @Override
    public long weight() {
        return this.weight;
    }

    @Override
    public BytesRef payload() {
        if (this.hasPayloads) {
            return this.payload;
        }
        return null;
    }

    @Override
    public boolean hasPayloads() {
        return this.hasPayloads;
    }

    @Override
    public Comparator<BytesRef> getComparator() {
        return this.tieBreakByCostComparator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Sort.ByteSequencesReader sort() throws IOException {
        Sort.ByteSequencesReader byteSequencesReader;
        block12: {
            Sort.ByteSequencesWriter writer;
            block11: {
                String prefix = this.getClass().getSimpleName();
                File directory = Sort.defaultTempDir();
                this.tempInput = File.createTempFile(prefix, ".input", directory);
                this.tempSorted = File.createTempFile(prefix, ".sorted", directory);
                writer = new Sort.ByteSequencesWriter(this.tempInput);
                boolean success = false;
                try {
                    BytesRef spare;
                    byte[] buffer = new byte[]{};
                    ByteArrayDataOutput output = new ByteArrayDataOutput(buffer);
                    while ((spare = this.source.next()) != null) {
                        this.encode(writer, output, buffer, spare, this.source.payload(), this.source.weight());
                    }
                    writer.close();
                    new Sort(this.tieBreakByCostComparator).sort(this.tempInput, this.tempSorted);
                    Sort.ByteSequencesReader reader = new Sort.ByteSequencesReader(this.tempSorted);
                    success = true;
                    byteSequencesReader = reader;
                    if (!success) break block11;
                }
                catch (Throwable throwable) {
                    if (success) {
                        IOUtils.close(writer);
                    } else {
                        try {
                            IOUtils.closeWhileHandlingException(writer);
                        }
                        finally {
                            this.close();
                        }
                    }
                    throw throwable;
                }
                IOUtils.close(writer);
                break block12;
            }
            try {
                IOUtils.closeWhileHandlingException(writer);
            }
            finally {
                this.close();
            }
        }
        return byteSequencesReader;
    }

    private void close() throws IOException {
        IOUtils.close(this.reader);
        if (this.tempInput != null) {
            this.tempInput.delete();
        }
        if (this.tempSorted != null) {
            this.tempSorted.delete();
        }
    }

    protected void encode(Sort.ByteSequencesWriter writer, ByteArrayDataOutput output, byte[] buffer, BytesRef spare, BytesRef payload, long weight) throws IOException {
        int requiredLength = spare.length + 8 + (this.hasPayloads ? 2 + payload.length : 0);
        if (requiredLength >= buffer.length) {
            buffer = ArrayUtil.grow(buffer, requiredLength);
        }
        output.reset(buffer);
        output.writeBytes(spare.bytes, spare.offset, spare.length);
        if (this.hasPayloads) {
            output.writeBytes(payload.bytes, payload.offset, payload.length);
            output.writeShort((short)payload.length);
        }
        output.writeLong(weight);
        writer.write(buffer, 0, output.getPosition());
    }

    protected long decode(BytesRef scratch, ByteArrayDataInput tmpInput) {
        tmpInput.reset(scratch.bytes);
        tmpInput.skipBytes(scratch.length - 8);
        scratch.length -= 8;
        return tmpInput.readLong();
    }

    protected BytesRef decodePayload(BytesRef scratch, ByteArrayDataInput tmpInput) {
        tmpInput.reset(scratch.bytes);
        tmpInput.skipBytes(scratch.length - 2);
        short payloadLength = tmpInput.readShort();
        tmpInput.setPosition(scratch.length - 2 - payloadLength);
        BytesRef payloadScratch = new BytesRef(payloadLength);
        tmpInput.readBytes(payloadScratch.bytes, 0, payloadLength);
        payloadScratch.length = payloadLength;
        scratch.length -= 2;
        scratch.length -= payloadLength;
        return payloadScratch;
    }
}

