/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.spatial.util;

import java.io.IOException;
import org.apache.lucene.index.AtomicReaderContext;
import org.apache.lucene.queries.function.FunctionValues;
import org.apache.lucene.queries.function.ValueSource;
import org.apache.lucene.search.DocIdSet;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.FilteredDocIdSet;
import org.apache.lucene.util.Bits;

public class ValueSourceFilter
extends Filter {
    final Filter startingFilter;
    final ValueSource source;
    final double min;
    final double max;

    public ValueSourceFilter(Filter startingFilter, ValueSource source, double min, double max) {
        if (startingFilter == null) {
            throw new IllegalArgumentException("please provide a non-null startingFilter; you can use QueryWrapperFilter(MatchAllDocsQuery) as a no-op filter");
        }
        this.startingFilter = startingFilter;
        this.source = source;
        this.min = min;
        this.max = max;
    }

    @Override
    public DocIdSet getDocIdSet(AtomicReaderContext context, Bits acceptDocs) throws IOException {
        final FunctionValues values = this.source.getValues(null, context);
        return new FilteredDocIdSet(this.startingFilter.getDocIdSet(context, acceptDocs)){

            @Override
            public boolean match(int doc) {
                double val = values.doubleVal(doc);
                return val >= ValueSourceFilter.this.min && val <= ValueSourceFilter.this.max;
            }
        };
    }
}

