/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.cloud;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.solr.cloud.ElectionContext;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.cloud.SolrZkClient;
import org.apache.solr.common.cloud.ZkCmdExecutor;
import org.apache.solr.common.cloud.ZooKeeperException;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LeaderElector {
    private static Logger log = LoggerFactory.getLogger(LeaderElector.class);
    static final String ELECTION_NODE = "/election";
    private static final Pattern LEADER_SEQ = Pattern.compile(".*?/?.*?-n_(\\d+)");
    private static final Pattern SESSION_ID = Pattern.compile(".*?/?(.*?-.*?)-n_\\d+");
    private static final Pattern NODE_NAME = Pattern.compile(".*?/?(.*?-)(.*?)-n_\\d+");
    protected SolrZkClient zkClient;
    private ZkCmdExecutor zkCmdExecutor;
    private volatile ElectionContext context;

    public LeaderElector(SolrZkClient zkClient) {
        this.zkClient = zkClient;
        this.zkCmdExecutor = new ZkCmdExecutor(zkClient.getZkClientTimeout());
    }

    public ElectionContext getContext() {
        return this.context;
    }

    private void checkIfIamLeader(final int seq, final ElectionContext context, boolean replacement) throws KeeperException, InterruptedException, IOException {
        context.checkIfIamLeaderFired();
        String holdElectionPath = context.electionPath + ELECTION_NODE;
        List<String> seqs = this.zkClient.getChildren(holdElectionPath, null, true);
        LeaderElector.sortSeqs(seqs);
        List<Integer> intSeqs = this.getSeqs(seqs);
        if (intSeqs.size() == 0) {
            log.warn("Our node is no longer in line to be leader");
            return;
        }
        if (seq <= intSeqs.get(0)) {
            try {
                this.zkClient.delete(context.leaderPath, -1, true);
            }
            catch (Exception e) {
                // empty catch block
            }
            this.runIamLeaderProcess(context, replacement);
        } else {
            int s;
            int i;
            for (i = 1; i < intSeqs.size() && seq >= (s = intSeqs.get(i).intValue()); ++i) {
            }
            int index = i - 2;
            if (index < 0) {
                log.warn("Our node is no longer in line to be leader");
                return;
            }
            try {
                this.zkClient.getData(holdElectionPath + "/" + seqs.get(index), new Watcher(){

                    @Override
                    public void process(WatchedEvent event) {
                        if (Watcher.Event.EventType.None.equals((Object)event.getType())) {
                            return;
                        }
                        try {
                            LeaderElector.this.checkIfIamLeader(seq, context, true);
                        }
                        catch (InterruptedException e) {
                            Thread.currentThread().interrupt();
                            log.warn("", (Throwable)e);
                        }
                        catch (IOException e) {
                            log.warn("", (Throwable)e);
                        }
                        catch (Exception e) {
                            log.warn("", (Throwable)e);
                        }
                    }
                }, null, true);
            }
            catch (KeeperException.SessionExpiredException e) {
                throw e;
            }
            catch (KeeperException e) {
                log.warn("Failed setting watch", (Throwable)e);
                this.checkIfIamLeader(seq, context, true);
            }
        }
    }

    protected void runIamLeaderProcess(ElectionContext context, boolean weAreReplacement) throws KeeperException, InterruptedException, IOException {
        context.runLeaderProcess(weAreReplacement, 0);
    }

    public static int getSeq(String nStringSequence) {
        int seq = 0;
        Matcher m = LEADER_SEQ.matcher(nStringSequence);
        if (!m.matches()) {
            throw new IllegalStateException("Could not find regex match in:" + nStringSequence);
        }
        seq = Integer.parseInt(m.group(1));
        return seq;
    }

    private String getNodeId(String nStringSequence) {
        Matcher m = SESSION_ID.matcher(nStringSequence);
        if (!m.matches()) {
            throw new IllegalStateException("Could not find regex match in:" + nStringSequence);
        }
        String id = m.group(1);
        return id;
    }

    public static String getNodeName(String nStringSequence) {
        Matcher m = NODE_NAME.matcher(nStringSequence);
        if (!m.matches()) {
            throw new IllegalStateException("Could not find regex match in:" + nStringSequence);
        }
        String result = m.group(2);
        return result;
    }

    private List<Integer> getSeqs(List<String> seqs) {
        ArrayList<Integer> intSeqs = new ArrayList<Integer>(seqs.size());
        for (String seq : seqs) {
            intSeqs.add(LeaderElector.getSeq(seq));
        }
        return intSeqs;
    }

    public int joinElection(ElectionContext context, boolean replacement) throws KeeperException, InterruptedException, IOException {
        context.joinedElectionFired();
        String shardsElectZkPath = context.electionPath + ELECTION_NODE;
        long sessionId = this.zkClient.getSolrZooKeeper().getSessionId();
        String id = sessionId + "-" + context.id;
        String leaderSeqPath = null;
        boolean cont = true;
        int tries = 0;
        while (cont) {
            try {
                context.leaderSeqPath = leaderSeqPath = this.zkClient.create(shardsElectZkPath + "/" + id + "-n_", null, CreateMode.EPHEMERAL_SEQUENTIAL, false);
                cont = false;
            }
            catch (KeeperException.ConnectionLossException e) {
                List<String> entries = this.zkClient.getChildren(shardsElectZkPath, null, true);
                boolean foundId = false;
                for (String entry : entries) {
                    String nodeId = this.getNodeId(entry);
                    if (!id.equals(nodeId)) continue;
                    foundId = true;
                    break;
                }
                if (foundId) continue;
                cont = true;
                if (tries++ > 20) {
                    throw new ZooKeeperException(SolrException.ErrorCode.SERVER_ERROR, "", (Throwable)e);
                }
                try {
                    Thread.sleep(50L);
                }
                catch (InterruptedException e2) {
                    Thread.currentThread().interrupt();
                }
            }
            catch (KeeperException.NoNodeException e) {
                if (tries++ > 20) {
                    throw new ZooKeeperException(SolrException.ErrorCode.SERVER_ERROR, "", (Throwable)e);
                }
                cont = true;
                try {
                    Thread.sleep(50L);
                }
                catch (InterruptedException e2) {
                    Thread.currentThread().interrupt();
                }
            }
        }
        int seq = LeaderElector.getSeq(leaderSeqPath);
        this.checkIfIamLeader(seq, context, replacement);
        return seq;
    }

    public void setup(ElectionContext context) throws InterruptedException, KeeperException {
        this.context = context;
        String electZKPath = context.electionPath + ELECTION_NODE;
        this.zkCmdExecutor.ensureExists(electZKPath, this.zkClient);
    }

    public static void sortSeqs(List<String> seqs) {
        Collections.sort(seqs, new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                return Integer.valueOf(LeaderElector.getSeq(o1)).compareTo(LeaderElector.getSeq(o2));
            }
        });
    }

    void retryElection() throws KeeperException, InterruptedException, IOException {
        this.context.cancelElection();
        this.joinElection(this.context, true);
    }
}

