/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.component;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CompletionService;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang.StringUtils;
import org.apache.http.client.HttpClient;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.impl.HttpClientUtil;
import org.apache.solr.client.solrj.impl.LBHttpSolrServer;
import org.apache.solr.client.solrj.request.QueryRequest;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.util.ExecutorUtil;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.StrUtils;
import org.apache.solr.common.util.URLUtil;
import org.apache.solr.core.PluginInfo;
import org.apache.solr.handler.component.HttpShardHandler;
import org.apache.solr.handler.component.ShardHandler;
import org.apache.solr.handler.component.ShardHandlerFactory;
import org.apache.solr.util.DefaultSolrThreadFactory;
import org.apache.solr.util.plugin.PluginInfoInitialized;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpShardHandlerFactory
extends ShardHandlerFactory
implements PluginInfoInitialized {
    protected static Logger log = LoggerFactory.getLogger(HttpShardHandlerFactory.class);
    private static final String DEFAULT_SCHEME = "http";
    private ThreadPoolExecutor commExecutor = new ThreadPoolExecutor(0, Integer.MAX_VALUE, 5L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), new DefaultSolrThreadFactory("httpShardExecutor"));
    protected HttpClient defaultClient;
    private LBHttpSolrServer loadbalancer;
    int soTimeout = 0;
    int connectionTimeout = 0;
    int maxConnectionsPerHost = 20;
    int corePoolSize = 0;
    int maximumPoolSize = Integer.MAX_VALUE;
    int keepAliveTime = 5;
    int queueSize = -1;
    boolean accessPolicy = false;
    private String scheme = null;
    private final Random r = new Random();
    static final String INIT_URL_SCHEME = "urlScheme";
    static final String INIT_CORE_POOL_SIZE = "corePoolSize";
    static final String INIT_MAX_POOL_SIZE = "maximumPoolSize";
    static final String MAX_THREAD_IDLE_TIME = "maxThreadIdleTime";
    static final String INIT_SIZE_OF_QUEUE = "sizeOfQueue";
    static final String INIT_FAIRNESS_POLICY = "fairnessPolicy";

    @Override
    public ShardHandler getShardHandler() {
        return this.getShardHandler(this.defaultClient);
    }

    public ShardHandler getShardHandler(HttpClient httpClient) {
        return new HttpShardHandler(this, httpClient);
    }

    @Override
    public void init(PluginInfo info) {
        NamedList args = info.initArgs;
        this.soTimeout = this.getParameter(args, "socketTimeout", this.soTimeout);
        this.scheme = this.getParameter(args, INIT_URL_SCHEME, null);
        if (StringUtils.endsWith(this.scheme, "://")) {
            this.scheme = StringUtils.removeEnd(this.scheme, "://");
        }
        this.connectionTimeout = this.getParameter(args, "connTimeout", this.connectionTimeout);
        this.maxConnectionsPerHost = this.getParameter(args, "maxConnectionsPerHost", this.maxConnectionsPerHost);
        this.corePoolSize = this.getParameter(args, INIT_CORE_POOL_SIZE, this.corePoolSize);
        this.maximumPoolSize = this.getParameter(args, INIT_MAX_POOL_SIZE, this.maximumPoolSize);
        this.keepAliveTime = this.getParameter(args, MAX_THREAD_IDLE_TIME, this.keepAliveTime);
        this.queueSize = this.getParameter(args, INIT_SIZE_OF_QUEUE, this.queueSize);
        this.accessPolicy = this.getParameter(args, INIT_FAIRNESS_POLICY, this.accessPolicy);
        String v = System.getProperty("tests.shardhandler.randomSeed");
        if (v != null) {
            this.r.setSeed(Long.parseLong(v));
        }
        BlockingQueue blockingQueue = (BlockingQueue)((Object)(this.queueSize == -1 ? new SynchronousQueue(this.accessPolicy) : new ArrayBlockingQueue(this.queueSize, this.accessPolicy)));
        this.commExecutor = new ThreadPoolExecutor(this.corePoolSize, this.maximumPoolSize, (long)this.keepAliveTime, TimeUnit.SECONDS, (BlockingQueue<Runnable>)blockingQueue, new DefaultSolrThreadFactory("httpShardExecutor"));
        ModifiableSolrParams clientParams = new ModifiableSolrParams();
        clientParams.set("maxConnectionsPerHost", this.maxConnectionsPerHost);
        clientParams.set("maxConnections", 10000);
        clientParams.set("socketTimeout", this.soTimeout);
        clientParams.set("connTimeout", this.connectionTimeout);
        clientParams.set("retry", false);
        this.defaultClient = HttpClientUtil.createClient(clientParams);
        this.loadbalancer = this.createLoadbalancer(this.defaultClient);
    }

    protected ThreadPoolExecutor getThreadPoolExecutor() {
        return this.commExecutor;
    }

    protected LBHttpSolrServer createLoadbalancer(HttpClient httpClient) {
        return new LBHttpSolrServer(httpClient, new String[0]);
    }

    protected <T> T getParameter(NamedList initArgs, String configKey, T defaultValue) {
        T toReturn = defaultValue;
        if (initArgs != null) {
            Object temp = initArgs.get(configKey);
            toReturn = temp != null ? temp : defaultValue;
        }
        log.info("Setting {} to: {}", (Object)configKey, toReturn);
        return toReturn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        try {
            ExecutorUtil.shutdownNowAndAwaitTermination(this.commExecutor);
        }
        finally {
            try {
                if (this.defaultClient != null) {
                    this.defaultClient.getConnectionManager().shutdown();
                }
            }
            finally {
                if (this.loadbalancer != null) {
                    this.loadbalancer.shutdown();
                }
            }
        }
    }

    public LBHttpSolrServer.Rsp makeLoadBalancedRequest(QueryRequest req, List<String> urls) throws SolrServerException, IOException {
        return this.loadbalancer.request(new LBHttpSolrServer.Req(req, urls));
    }

    public List<String> makeURLList(String shard) {
        List<String> urls = StrUtils.splitSmart(shard, "|", true);
        for (int i = 0; i < urls.size(); ++i) {
            urls.set(i, this.buildUrl(urls.get(i)));
        }
        if (urls.size() > 1) {
            Collections.shuffle(urls, this.r);
        }
        return urls;
    }

    public CompletionService newCompletionService() {
        return new ExecutorCompletionService(this.commExecutor);
    }

    private String buildUrl(String url) {
        if (!URLUtil.hasScheme(url)) {
            return StringUtils.defaultIfEmpty(this.scheme, DEFAULT_SCHEME) + "://" + url;
        }
        if (StringUtils.isNotEmpty(this.scheme)) {
            return this.scheme + "://" + URLUtil.removeScheme(url);
        }
        return url;
    }
}

