/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.highlight;

import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.OffsetAttribute;
import org.apache.lucene.analysis.tokenattributes.PositionIncrementAttribute;
import org.apache.lucene.search.highlight.SimpleFragmenter;

class LuceneGapFragmenter
extends SimpleFragmenter {
    public static final int INCREMENT_THRESHOLD = 50;
    protected int fragOffset = 0;
    private OffsetAttribute offsetAtt;
    private PositionIncrementAttribute posIncAtt;

    public LuceneGapFragmenter() {
    }

    public LuceneGapFragmenter(int fragsize) {
        super(fragsize);
    }

    @Override
    public void start(String originalText, TokenStream tokenStream) {
        this.offsetAtt = tokenStream.getAttribute(OffsetAttribute.class);
        this.posIncAtt = tokenStream.getAttribute(PositionIncrementAttribute.class);
        this.fragOffset = 0;
    }

    @Override
    public boolean isNewFragment() {
        boolean isNewFrag;
        int endOffset = this.offsetAtt.endOffset();
        boolean bl = isNewFrag = endOffset >= this.fragOffset + this.getFragmentSize() || this.posIncAtt.getPositionIncrement() > 50;
        if (isNewFrag) {
            this.fragOffset = endOffset;
        }
        return isNewFrag;
    }
}

