/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search;

import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.CachingWrapperFilter;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.QueryWrapperFilter;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TopDocs;
import org.apache.solr.search.SolrIndexSearcher;

class LuceneQueryOptimizer {
    private LinkedHashMap cache;
    private float threshold;

    public LuceneQueryOptimizer(final int cacheSize, float threshold) {
        this.cache = new LinkedHashMap(cacheSize, 0.75f, true){

            protected boolean removeEldestEntry(Map.Entry eldest) {
                return this.size() > cacheSize;
            }
        };
        this.threshold = threshold;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TopDocs optimize(BooleanQuery original, SolrIndexSearcher searcher, int numHits, Query[] queryOut, Filter[] filterOut) throws IOException {
        BooleanQuery query = new BooleanQuery();
        BooleanQuery filterQuery = null;
        for (BooleanClause c : original.clauses()) {
            Query q = c.getQuery();
            if (c.isRequired() && q.getBoost() == 0.0f && q instanceof TermQuery && (float)searcher.docFreq(((TermQuery)q).getTerm()) / (float)searcher.maxDoc() >= this.threshold) {
                if (filterQuery == null) {
                    filterQuery = new BooleanQuery();
                }
                filterQuery.add(q, BooleanClause.Occur.MUST);
                continue;
            }
            query.add(c);
        }
        Filter filter = null;
        if (filterQuery != null) {
            LinkedHashMap linkedHashMap = this.cache;
            synchronized (linkedHashMap) {
                filter = (Filter)this.cache.get(filterQuery);
            }
            if (filter == null) {
                filter = new CachingWrapperFilter(new QueryWrapperFilter(filterQuery));
                linkedHashMap = this.cache;
                synchronized (linkedHashMap) {
                    this.cache.put(filterQuery, filter);
                }
            }
        }
        if (queryOut != null && filterOut != null) {
            queryOut[0] = query;
            filterOut[0] = filter;
            return null;
        }
        return searcher.search((Query)query, filter, numHits);
    }
}

