/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search;

import java.util.List;
import org.apache.lucene.search.Query;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.StrUtils;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.search.LuceneQParser;
import org.apache.solr.search.QueryParsing;
import org.apache.solr.search.SortSpec;
import org.apache.solr.search.SyntaxError;

class OldLuceneQParser
extends LuceneQParser {
    String sortStr;

    public OldLuceneQParser(String qstr, SolrParams localParams, SolrParams params, SolrQueryRequest req) {
        super(qstr, localParams, params, req);
    }

    @Override
    public Query parse() throws SyntaxError {
        if (this.getLocalParams() == null) {
            String qstr = this.getString();
            if (qstr == null || qstr.length() == 0) {
                return null;
            }
            this.sortStr = this.getParams().get("sort");
            if (this.sortStr == null) {
                List<String> commands = StrUtils.splitSmart(qstr, ';');
                if (commands.size() == 2) {
                    qstr = commands.get(0);
                    this.sortStr = commands.get(1);
                } else if (commands.size() == 1) {
                    qstr = commands.get(0);
                } else if (commands.size() > 2) {
                    throw new SyntaxError("If you want to use multiple ';' in the query, use the 'sort' param.");
                }
            }
            this.setString(qstr);
        }
        return super.parse();
    }

    @Override
    public SortSpec getSort(boolean useGlobal) throws SyntaxError {
        SortSpec oldSort;
        SortSpec sort = super.getSort(useGlobal);
        if (this.sortStr != null && this.sortStr.length() > 0 && sort.getSort() == null && (oldSort = QueryParsing.parseSortSpec(this.sortStr, this.getReq())).getSort() != null) {
            sort.setSortAndFields(oldSort.getSort(), oldSort.getSchemaFields());
        }
        return sort;
    }
}

