/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search.function.distance;

import org.apache.lucene.queries.function.FunctionValues;
import org.apache.lucene.queries.function.valuesource.MultiValueSource;
import org.apache.solr.search.function.distance.VectorDistanceFunction;

public class SquaredEuclideanFunction
extends VectorDistanceFunction {
    protected String name = "sqedist";

    public SquaredEuclideanFunction(MultiValueSource source1, MultiValueSource source2) {
        super(-1.0f, source1, source2);
    }

    @Override
    protected String name() {
        return this.name;
    }

    @Override
    protected double distance(int doc, FunctionValues dv1, FunctionValues dv2) {
        double[] vals1 = new double[this.source1.dimension()];
        double[] vals2 = new double[this.source1.dimension()];
        dv1.doubleVal(doc, vals1);
        dv2.doubleVal(doc, vals2);
        return SquaredEuclideanFunction.distSquaredCartesian(vals1, vals2);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SquaredEuclideanFunction)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        SquaredEuclideanFunction that = (SquaredEuclideanFunction)o;
        return this.name.equals(that.name);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.name.hashCode();
        return result;
    }
}

