/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search.grouping.collector;

import java.io.IOException;
import org.apache.lucene.index.AtomicReaderContext;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.Scorer;
import org.apache.solr.search.DocSet;

public class FilterCollector
extends Collector {
    private final DocSet filter;
    private final Collector delegate;
    private int docBase;
    private int matches;

    public FilterCollector(DocSet filter, Collector delegate) {
        this.filter = filter;
        this.delegate = delegate;
    }

    @Override
    public void setScorer(Scorer scorer) throws IOException {
        this.delegate.setScorer(scorer);
    }

    @Override
    public void collect(int doc) throws IOException {
        ++this.matches;
        if (this.filter.exists(doc + this.docBase)) {
            this.delegate.collect(doc);
        }
    }

    @Override
    public void setNextReader(AtomicReaderContext context) throws IOException {
        this.docBase = context.docBase;
        this.delegate.setNextReader(context);
    }

    @Override
    public boolean acceptsDocsOutOfOrder() {
        return this.delegate.acceptsDocsOutOfOrder();
    }

    public int getMatches() {
        return this.matches;
    }

    public Collector getDelegate() {
        return this.delegate;
    }
}

