/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search.grouping.distributed.shardresultserializer;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.grouping.SearchGroup;
import org.apache.lucene.util.BytesRef;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.schema.FieldType;
import org.apache.solr.schema.SchemaField;
import org.apache.solr.search.SolrIndexSearcher;
import org.apache.solr.search.grouping.Command;
import org.apache.solr.search.grouping.distributed.command.Pair;
import org.apache.solr.search.grouping.distributed.command.SearchGroupsFieldCommand;
import org.apache.solr.search.grouping.distributed.shardresultserializer.ShardResultTransformer;

public class SearchGroupsResultTransformer
implements ShardResultTransformer<List<Command>, Map<String, Pair<Integer, Collection<SearchGroup<BytesRef>>>>> {
    private final SolrIndexSearcher searcher;

    public SearchGroupsResultTransformer(SolrIndexSearcher searcher) {
        this.searcher = searcher;
    }

    @Override
    public NamedList transform(List<Command> data) throws IOException {
        NamedList result = new NamedList();
        for (Command command : data) {
            NamedList<Serializable> commandResult = new NamedList<Serializable>();
            if (!SearchGroupsFieldCommand.class.isInstance(command)) continue;
            SearchGroupsFieldCommand fieldCommand = (SearchGroupsFieldCommand)command;
            Object pair = fieldCommand.result();
            Integer groupedCount = (Integer)((Pair)pair).getA();
            Collection searchGroups = (Collection)((Pair)pair).getB();
            if (searchGroups != null) {
                commandResult.add("topGroups", this.serializeSearchGroup(searchGroups, fieldCommand.getGroupSort()));
            }
            if (groupedCount != null) {
                commandResult.add("groupCount", groupedCount);
            }
            result.add(command.getKey(), commandResult);
        }
        return result;
    }

    @Override
    public Map<String, Pair<Integer, Collection<SearchGroup<BytesRef>>>> transformToNative(NamedList<NamedList> shardResponse, Sort groupSort, Sort sortWithinGroup, String shard) {
        HashMap<String, Pair<Integer, Collection<SearchGroup<BytesRef>>>> result = new HashMap<String, Pair<Integer, Collection<SearchGroup<BytesRef>>>>();
        for (Map.Entry<String, NamedList> entry : shardResponse) {
            ArrayList searchGroups = new ArrayList();
            NamedList topGroupsAndGroupCount = entry.getValue();
            NamedList rawSearchGroups = (NamedList)topGroupsAndGroupCount.get("topGroups");
            if (rawSearchGroups != null) {
                for (Map.Entry rawSearchGroup : rawSearchGroups) {
                    SearchGroup searchGroup = new SearchGroup();
                    searchGroup.groupValue = rawSearchGroup.getKey() != null ? new BytesRef(rawSearchGroup.getKey()) : null;
                    searchGroup.sortValues = ((List)rawSearchGroup.getValue()).toArray(new Comparable[((List)rawSearchGroup.getValue()).size()]);
                    for (int i = 0; i < searchGroup.sortValues.length; ++i) {
                        SchemaField field;
                        SchemaField schemaField = field = groupSort.getSort()[i].getField() != null ? this.searcher.getSchema().getFieldOrNull(groupSort.getSort()[i].getField()) : null;
                        if (field == null) continue;
                        FieldType fieldType = field.getType();
                        if (searchGroup.sortValues[i] == null) continue;
                        searchGroup.sortValues[i] = fieldType.unmarshalSortValue(searchGroup.sortValues[i]);
                    }
                    searchGroups.add(searchGroup);
                }
            }
            Integer groupCount = (Integer)topGroupsAndGroupCount.get("groupCount");
            result.put(entry.getKey(), new Pair(groupCount, searchGroups));
        }
        return result;
    }

    private NamedList serializeSearchGroup(Collection<SearchGroup<BytesRef>> data, Sort groupSort) {
        NamedList<Object[]> result = new NamedList<Object[]>();
        for (SearchGroup<BytesRef> searchGroup : data) {
            Object[] convertedSortValues = new Object[searchGroup.sortValues.length];
            for (int i = 0; i < searchGroup.sortValues.length; ++i) {
                SchemaField field;
                Object sortValue = searchGroup.sortValues[i];
                SchemaField schemaField = field = groupSort.getSort()[i].getField() != null ? this.searcher.getSchema().getFieldOrNull(groupSort.getSort()[i].getField()) : null;
                if (field != null) {
                    FieldType fieldType = field.getType();
                    if (sortValue != null) {
                        sortValue = fieldType.marshalSortValue(sortValue);
                    }
                }
                convertedSortValues[i] = sortValue;
            }
            String groupValue = searchGroup.groupValue != null ? ((BytesRef)searchGroup.groupValue).utf8ToString() : null;
            result.add(groupValue, convertedSortValues);
        }
        return result;
    }
}

