/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.update;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import org.apache.solr.common.util.FastInputStream;

class ChannelFastInputStream
extends FastInputStream {
    private FileChannel ch;

    public ChannelFastInputStream(FileChannel ch, long chPosition) {
        super(null);
        this.ch = ch;
        this.readFromStream = chPosition;
    }

    @Override
    public int readWrappedStream(byte[] target, int offset, int len) throws IOException {
        ByteBuffer bb = ByteBuffer.wrap(target, offset, len);
        int ret = this.ch.read(bb, this.readFromStream);
        return ret;
    }

    public void seek(long position) throws IOException {
        if (position <= this.readFromStream && position >= this.getBufferPos()) {
            this.pos = (int)(position - this.getBufferPos());
        } else {
            this.readFromStream = position;
            this.pos = 0;
            this.end = 0;
        }
        assert (this.position() == position);
    }

    public long getBufferPos() {
        return this.readFromStream - (long)this.end;
    }

    public int getBufferSize() {
        return this.buf.length;
    }

    @Override
    public void close() throws IOException {
        this.ch.close();
    }

    public String toString() {
        return "readFromStream=" + this.readFromStream + " pos=" + this.pos + " end=" + this.end + " bufferPos=" + this.getBufferPos() + " position=" + this.position();
    }
}

