/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.update;

import java.util.List;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.index.IndexableField;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.SolrInputDocument;
import org.apache.solr.common.SolrInputField;
import org.apache.solr.schema.CopyField;
import org.apache.solr.schema.IndexSchema;
import org.apache.solr.schema.SchemaField;

public class DocumentBuilder {
    private static void addField(Document doc, SchemaField field, Object val, float boost) {
        if (val instanceof IndexableField) {
            ((Field)val).setBoost(boost);
            doc.add((Field)val);
            return;
        }
        for (IndexableField f : field.getType().createFields(field, val, boost)) {
            if (f == null) continue;
            doc.add((Field)f);
        }
    }

    private static String getID(SolrInputDocument doc, IndexSchema schema) {
        String id = "";
        SchemaField sf = schema.getUniqueKeyField();
        if (sf != null) {
            id = "[doc=" + doc.getFieldValue(sf.getName()) + "] ";
        }
        return id;
    }

    public static Document toDocument(SolrInputDocument doc, IndexSchema schema) {
        Document out = new Document();
        float docBoost = doc.getDocumentBoost();
        for (SolrInputField solrInputField : doc) {
            boolean applyBoost;
            String name = solrInputField.getName();
            SchemaField sfield = schema.getFieldOrNull(name);
            boolean used = false;
            if (sfield != null && !sfield.multiValued() && solrInputField.getValueCount() > 1) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "ERROR: " + DocumentBuilder.getID(doc, schema) + "multiple values encountered for non multiValued field " + sfield.getName() + ": " + solrInputField.getValue());
            }
            float fieldBoost = solrInputField.getBoost();
            boolean bl = applyBoost = sfield != null && sfield.indexed() && !sfield.omitNorms();
            if (!applyBoost && fieldBoost != 1.0f) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "ERROR: " + DocumentBuilder.getID(doc, schema) + "cannot set an index-time boost, unindexed or norms are omitted for field " + sfield.getName() + ": " + solrInputField.getValue());
            }
            float compoundBoost = fieldBoost * docBoost;
            boolean hasField = false;
            try {
                for (Object v : solrInputField) {
                    if (v == null) continue;
                    hasField = true;
                    if (sfield != null) {
                        used = true;
                        DocumentBuilder.addField(out, sfield, v, applyBoost ? compoundBoost : 1.0f);
                    }
                    List<CopyField> copyFields = schema.getCopyFieldsList(name);
                    for (CopyField cf : copyFields) {
                        boolean destHasValues;
                        SchemaField destinationField = cf.getDestination();
                        boolean bl2 = destHasValues = null != out.getField(destinationField.getName());
                        if (!destinationField.multiValued() && destHasValues) {
                            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "ERROR: " + DocumentBuilder.getID(doc, schema) + "multiple values encountered for non multiValued copy field " + destinationField.getName() + ": " + v);
                        }
                        used = true;
                        Object val = v;
                        if (val instanceof String && cf.getMaxChars() > 0) {
                            val = cf.getLimitedValue((String)val);
                        }
                        float destBoost = destinationField.indexed() && !destinationField.omitNorms() ? (destHasValues ? fieldBoost : compoundBoost) : 1.0f;
                        DocumentBuilder.addField(out, destinationField, val, destBoost);
                    }
                    compoundBoost = 1.0f;
                    fieldBoost = 1.0f;
                }
            }
            catch (SolrException ex) {
                throw ex;
            }
            catch (Exception ex) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "ERROR: " + DocumentBuilder.getID(doc, schema) + "Error adding field '" + solrInputField.getName() + "'='" + solrInputField.getValue() + "' msg=" + ex.getMessage(), (Throwable)ex);
            }
            if (used || !hasField) continue;
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "ERROR: " + DocumentBuilder.getID(doc, schema) + "unknown field '" + name + "'");
        }
        for (SchemaField schemaField : schema.getRequiredFields()) {
            if (out.getField(schemaField.getName()) != null) continue;
            if (schemaField.getDefaultValue() != null) {
                DocumentBuilder.addField(out, schemaField, schemaField.getDefaultValue(), 1.0f);
                continue;
            }
            String msg = DocumentBuilder.getID(doc, schema) + "missing required field: " + schemaField.getName();
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, msg);
        }
        return out;
    }
}

