/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.update.processor;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.core.SolrCore;
import org.apache.solr.update.processor.FieldMutatingUpdateProcessor;
import org.apache.solr.update.processor.UpdateRequestProcessorFactory;
import org.apache.solr.util.plugin.SolrCoreAware;

public abstract class FieldMutatingUpdateProcessorFactory
extends UpdateRequestProcessorFactory
implements SolrCoreAware {
    private SelectorParams inclusions = new SelectorParams();
    private Collection<SelectorParams> exclusions = new ArrayList<SelectorParams>();
    private FieldMutatingUpdateProcessor.FieldNameSelector selector = null;

    protected final FieldMutatingUpdateProcessor.FieldNameSelector getSelector() {
        if (null != this.selector) {
            return this.selector;
        }
        throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "selector was never initialized, inform(SolrCore) never called???");
    }

    public static SelectorParams parseSelectorParams(NamedList args) {
        SelectorParams params = new SelectorParams();
        params.fieldName = new HashSet<String>(args.removeConfigArgs("fieldName"));
        params.typeName = new HashSet<String>(args.removeConfigArgs("typeName"));
        Collection<String> patterns = args.removeConfigArgs("fieldRegex");
        if (!patterns.isEmpty()) {
            params.fieldRegex = new ArrayList<Pattern>(patterns.size());
            for (String s : patterns) {
                try {
                    params.fieldRegex.add(Pattern.compile(s));
                }
                catch (PatternSyntaxException e) {
                    throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Invalid 'fieldRegex' pattern: " + s, (Throwable)e);
                }
            }
        }
        params.typeClass = args.removeConfigArgs("typeClass");
        params.fieldNameMatchesSchemaField = args.removeBooleanArg("fieldNameMatchesSchemaField");
        return params;
    }

    public static Collection<SelectorParams> parseSelectorExclusionParams(NamedList args) {
        ArrayList<SelectorParams> exclusions = new ArrayList<SelectorParams>();
        List excList = args.getAll("exclude");
        for (Object excObj : excList) {
            if (null == excObj) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "'exclude' init param can not be null");
            }
            if (!(excObj instanceof NamedList)) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "'exclude' init param must be <lst/>");
            }
            NamedList exc = (NamedList)excObj;
            exclusions.add(FieldMutatingUpdateProcessorFactory.parseSelectorParams(exc));
            if (0 < exc.size()) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Unexpected 'exclude' init sub-param(s): '" + args.getName(0) + "'");
            }
            args.remove("exclude");
        }
        return exclusions;
    }

    @Override
    public void init(NamedList args) {
        this.inclusions = FieldMutatingUpdateProcessorFactory.parseSelectorParams(args);
        this.exclusions = FieldMutatingUpdateProcessorFactory.parseSelectorExclusionParams(args);
        if (0 < args.size()) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Unexpected init param(s): '" + args.getName(0) + "'");
        }
    }

    @Override
    public void inform(SolrCore core) {
        this.selector = FieldMutatingUpdateProcessor.createFieldNameSelector(core.getResourceLoader(), core, this.inclusions, this.getDefaultSelector(core));
        for (SelectorParams exc : this.exclusions) {
            this.selector = FieldMutatingUpdateProcessor.wrap(this.selector, FieldMutatingUpdateProcessor.createFieldNameSelector(core.getResourceLoader(), core, exc, FieldMutatingUpdateProcessor.SELECT_NO_FIELDS));
        }
    }

    protected FieldMutatingUpdateProcessor.FieldNameSelector getDefaultSelector(SolrCore core) {
        return FieldMutatingUpdateProcessor.SELECT_ALL_FIELDS;
    }

    @Deprecated
    public static Collection<String> oneOrMany(NamedList args, String key) {
        ArrayList<String> result = new ArrayList<String>(args.size() / 2);
        String err = "init arg '" + key + "' must be a string " + "(ie: 'str'), or an array (ie: 'arr') containing strings; found: ";
        Object o = args.remove(key);
        while (null != o) {
            if (o instanceof String) {
                result.add((String)o);
            } else {
                if (o instanceof Object[]) {
                    o = Arrays.asList((Object[])o);
                }
                if (o instanceof Collection) {
                    for (Object item : (Collection)o) {
                        if (!(item instanceof String)) {
                            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, err + item.getClass());
                        }
                        result.add((String)item);
                    }
                } else {
                    throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, err + o.getClass());
                }
            }
            o = args.remove(key);
        }
        return result;
    }

    @Deprecated
    public static Boolean getBooleanArg(NamedList args, String key) {
        Boolean bool;
        List values = args.getAll(key);
        if (0 == values.size()) {
            return null;
        }
        if (values.size() > 1) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Only one '" + key + "' is allowed");
        }
        Object o = args.remove(key);
        if (o instanceof Boolean) {
            bool = (Boolean)o;
        } else if (o instanceof CharSequence) {
            bool = Boolean.parseBoolean(o.toString());
        } else {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "'" + key + "' must have type 'bool' or 'str'; found " + o.getClass());
        }
        return bool;
    }

    public static final class SelectorParams {
        public Set<String> fieldName = Collections.emptySet();
        public Set<String> typeName = Collections.emptySet();
        public Collection<String> typeClass = Collections.emptyList();
        public Collection<Pattern> fieldRegex = Collections.emptyList();
        public Boolean fieldNameMatchesSchemaField = null;

        public boolean noSelectorsSpecified() {
            return this.typeClass.isEmpty() && this.typeName.isEmpty() && this.fieldRegex.isEmpty() && this.fieldName.isEmpty() && null == this.fieldNameMatchesSchemaField;
        }
    }
}

