/*
 * Decompiled with CFR 0.152.
 */
package org.noggit;

import java.io.IOException;
import java.io.Reader;
import org.noggit.CharArr;
import org.noggit.JSONUtil;
import org.noggit.NullCharArr;

public class JSONParser {
    public static final int STRING = 1;
    public static final int LONG = 2;
    public static final int NUMBER = 3;
    public static final int BIGNUMBER = 4;
    public static final int BOOLEAN = 5;
    public static final int NULL = 6;
    public static final int OBJECT_START = 7;
    public static final int OBJECT_END = 8;
    public static final int ARRAY_START = 9;
    public static final int ARRAY_END = 10;
    public static final int EOF = 11;
    private static final CharArr devNull = new NullCharArr();
    final char[] buf;
    int start;
    int end;
    final Reader in;
    boolean eof = false;
    long gpos;
    int event;
    private final CharArr out = new CharArr(64);
    private byte[] stack = new byte[16];
    private int ptr = 0;
    private byte state = 0;
    private static final byte DID_OBJSTART = 1;
    private static final byte DID_ARRSTART = 2;
    private static final byte DID_ARRELEM = 3;
    private static final byte DID_MEMNAME = 4;
    private static final byte DID_MEMVAL = 5;
    private int valstate;
    private boolean bool;
    private long lval;
    private int nstate;
    private static final int HAS_FRACTION = 1;
    private static final int HAS_EXPONENT = 2;
    private final CharArr tmp = new CharArr(null, 0, 0);

    public static String getEventString(int e) {
        switch (e) {
            case 1: {
                return "STRING";
            }
            case 2: {
                return "LONG";
            }
            case 3: {
                return "NUMBER";
            }
            case 4: {
                return "BIGNUMBER";
            }
            case 5: {
                return "BOOLEAN";
            }
            case 6: {
                return "NULL";
            }
            case 7: {
                return "OBJECT_START";
            }
            case 8: {
                return "OBJECT_END";
            }
            case 9: {
                return "ARRAY_START";
            }
            case 10: {
                return "ARRAY_END";
            }
            case 11: {
                return "EOF";
            }
        }
        return "Unknown: " + e;
    }

    public JSONParser(Reader in) {
        this(in, new char[8192]);
    }

    public JSONParser(Reader in, char[] buffer) {
        this.in = in;
        this.buf = buffer;
    }

    public JSONParser(char[] data, int start, int end) {
        this.in = null;
        this.buf = data;
        this.start = start;
        this.end = end;
    }

    public JSONParser(String data) {
        this(data, 0, data.length());
    }

    public JSONParser(String data, int start, int end) {
        this.in = null;
        this.start = start;
        this.end = end;
        this.buf = new char[end - start];
        data.getChars(start, end, this.buf, 0);
    }

    private final void push() {
        if (this.ptr >= this.stack.length) {
            byte[] newstack = new byte[this.stack.length << 1];
            System.arraycopy(this.stack, 0, newstack, 0, this.stack.length);
            this.stack = newstack;
        }
        this.stack[this.ptr++] = this.state;
    }

    private final void pop() {
        if (--this.ptr < 0) {
            throw this.err("Unbalanced container");
        }
        this.state = this.stack[this.ptr];
    }

    protected void fill() throws IOException {
        if (this.in != null) {
            this.gpos += (long)this.end;
            this.start = 0;
            int num = this.in.read(this.buf, 0, this.buf.length);
            int n = this.end = num >= 0 ? num : 0;
        }
        if (this.start >= this.end) {
            this.eof = true;
        }
    }

    private void getMore() throws IOException {
        this.fill();
        if (this.start >= this.end) {
            throw this.err(null);
        }
    }

    protected int getChar() throws IOException {
        if (this.start >= this.end) {
            this.fill();
            if (this.start >= this.end) {
                return -1;
            }
        }
        return this.buf[this.start++];
    }

    private int getCharNWS() throws IOException {
        int ch;
        while ((ch = this.getChar()) == 32 || ch == 9 || ch == 10 || ch == 13) {
        }
        return ch;
    }

    private void expect(char[] arr) throws IOException {
        for (int i = 1; i < arr.length; ++i) {
            int ch = this.getChar();
            if (ch == arr[i]) continue;
            throw this.err("Expected " + new String(arr));
        }
    }

    private ParseException err(String msg) {
        if (!this.eof && this.start > 0) {
            --this.start;
        }
        String chs = "char=" + (this.start >= this.end ? "(EOF)" : "" + this.buf[this.start]);
        String pos = "position=" + (this.gpos + (long)this.start);
        String tot = chs + ',' + pos + this.getContext();
        if (msg == null) {
            msg = this.start >= this.end ? "Unexpected EOF" : "JSON Parse Error";
        }
        return new ParseException(msg + ": " + tot);
    }

    private String getContext() {
        String context = "";
        if (this.start >= 0) {
            context = context + " BEFORE='" + this.errEscape(Math.max(this.start - 60, 0), this.start + 1) + "'";
        }
        if (this.start < this.end) {
            context = context + " AFTER='" + this.errEscape(this.start + 1, this.start + 40) + "'";
        }
        return context;
    }

    private String errEscape(int a, int b) {
        if (a >= (b = Math.min(b, this.end))) {
            return "";
        }
        return new String(this.buf, a, b - a).replaceAll("\\s+", " ");
    }

    private long readNumber(int firstChar, boolean isNeg) throws IOException {
        long maxval;
        int i;
        this.out.unsafeWrite(firstChar);
        long v = 48 - firstChar;
        block10: for (i = 0; i < 17; ++i) {
            int ch = this.getChar();
            switch (ch) {
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: {
                    v = v * 10L - (long)(ch - 48);
                    this.out.unsafeWrite(ch);
                    continue block10;
                }
                case 46: {
                    this.out.unsafeWrite('.');
                    this.valstate = this.readFrac(this.out, 22 - i);
                    return 0L;
                }
                case 69: 
                case 101: {
                    this.out.unsafeWrite(ch);
                    this.nstate = 0;
                    this.valstate = this.readExp(this.out, 22 - i);
                    return 0L;
                }
                default: {
                    if (ch != -1) {
                        --this.start;
                    }
                    this.valstate = 2;
                    return isNeg ? v : -v;
                }
            }
        }
        boolean overflow = false;
        long l = maxval = isNeg ? Long.MIN_VALUE : -9223372036854775807L;
        while (i < 22) {
            int ch = this.getChar();
            switch (ch) {
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: {
                    int digit;
                    if (v < -922337203685477580L) {
                        overflow = true;
                    }
                    if ((v *= 10L) < maxval + (long)(digit = ch - 48)) {
                        overflow = true;
                    }
                    v -= (long)digit;
                    this.out.unsafeWrite(ch);
                    break;
                }
                case 46: {
                    this.out.unsafeWrite('.');
                    this.valstate = this.readFrac(this.out, 22 - i);
                    return 0L;
                }
                case 69: 
                case 101: {
                    this.out.unsafeWrite(ch);
                    this.nstate = 0;
                    this.valstate = this.readExp(this.out, 22 - i);
                    return 0L;
                }
                default: {
                    if (ch != -1) {
                        --this.start;
                    }
                    this.valstate = overflow ? 4 : 2;
                    return isNeg ? v : -v;
                }
            }
            ++i;
        }
        this.nstate = 0;
        this.valstate = 4;
        return 0L;
    }

    private int readFrac(CharArr arr, int lim) throws IOException {
        this.nstate = 1;
        while (--lim >= 0) {
            int ch = this.getChar();
            if (ch >= 48 && ch <= 57) {
                arr.write(ch);
                continue;
            }
            if (ch == 101 || ch == 69) {
                arr.write(ch);
                return this.readExp(arr, lim);
            }
            if (ch != -1) {
                --this.start;
            }
            return 3;
        }
        return 4;
    }

    private int readExp(CharArr arr, int lim) throws IOException {
        this.nstate |= 2;
        int ch = this.getChar();
        --lim;
        if (ch == 43 || ch == 45) {
            arr.write(ch);
            ch = this.getChar();
            --lim;
        }
        if (ch < 48 || ch > 57) {
            throw this.err("missing exponent number");
        }
        arr.write(ch);
        return this.readExpDigits(arr, lim);
    }

    private int readExpDigits(CharArr arr, int lim) throws IOException {
        while (--lim >= 0) {
            int ch = this.getChar();
            if (ch >= 48 && ch <= 57) {
                arr.write(ch);
                continue;
            }
            if (ch != -1) {
                --this.start;
            }
            return 3;
        }
        return 4;
    }

    private void continueNumber(CharArr arr) throws IOException {
        int ch;
        if (arr != this.out) {
            arr.write(this.out);
        }
        if ((this.nstate & 2) != 0) {
            this.readExpDigits(arr, Integer.MAX_VALUE);
            return;
        }
        if (this.nstate != 0) {
            this.readFrac(arr, Integer.MAX_VALUE);
            return;
        }
        while ((ch = this.getChar()) >= 48 && ch <= 57) {
            arr.write(ch);
        }
        if (ch == 46) {
            arr.write(ch);
            this.readFrac(arr, Integer.MAX_VALUE);
            return;
        }
        if (ch == 101 || ch == 69) {
            arr.write(ch);
            this.readExp(arr, Integer.MAX_VALUE);
            return;
        }
        if (ch != -1) {
            --this.start;
        }
    }

    private int hexval(int hexdig) {
        if (hexdig >= 48 && hexdig <= 57) {
            return hexdig - 48;
        }
        if (hexdig >= 65 && hexdig <= 70) {
            return hexdig + -55;
        }
        if (hexdig >= 97 && hexdig <= 102) {
            return hexdig + -87;
        }
        throw this.err("invalid hex digit");
    }

    private char readEscapedChar() throws IOException {
        switch (this.getChar()) {
            case 34: {
                return '\"';
            }
            case 92: {
                return '\\';
            }
            case 47: {
                return '/';
            }
            case 110: {
                return '\n';
            }
            case 114: {
                return '\r';
            }
            case 116: {
                return '\t';
            }
            case 102: {
                return '\f';
            }
            case 98: {
                return '\b';
            }
            case 117: {
                return (char)(this.hexval(this.getChar()) << 12 | this.hexval(this.getChar()) << 8 | this.hexval(this.getChar()) << 4 | this.hexval(this.getChar()));
            }
        }
        throw this.err("Invalid character escape in string");
    }

    private CharArr readStringChars() throws IOException {
        int i;
        char c = '\u0000';
        for (i = this.start; i < this.end; ++i) {
            c = this.buf[i];
            if (c == '\"') {
                this.tmp.set(this.buf, this.start, i);
                this.start = i + 1;
                return this.tmp;
            }
            if (c == '\\') break;
        }
        this.out.reset();
        this.readStringChars2(this.out, i);
        return this.out;
    }

    private void readStringChars2(CharArr arr, int middle) throws IOException {
        while (true) {
            int len;
            char ch;
            if (middle >= this.end) {
                arr.write(this.buf, this.start, middle - this.start);
                this.start = middle;
                this.getMore();
                middle = this.start;
            }
            if ((ch = this.buf[middle++]) == '\"') {
                len = middle - this.start - 1;
                if (len > 0) {
                    arr.write(this.buf, this.start, len);
                }
                this.start = middle;
                return;
            }
            if (ch != '\\') continue;
            len = middle - this.start - 1;
            if (len > 0) {
                arr.write(this.buf, this.start, len);
            }
            this.start = middle;
            arr.write(this.readEscapedChar());
            middle = this.start;
        }
    }

    private int next(int ch) throws IOException {
        while (true) {
            switch (ch) {
                case 9: 
                case 32: {
                    break;
                }
                case 10: 
                case 13: {
                    break;
                }
                case 34: {
                    this.valstate = 1;
                    return 1;
                }
                case 123: {
                    this.push();
                    this.state = 1;
                    return 7;
                }
                case 91: {
                    this.push();
                    this.state = (byte)2;
                    return 9;
                }
                case 48: {
                    this.out.reset();
                    ch = this.getChar();
                    if (ch == 46) {
                        --this.start;
                        ch = 48;
                        this.readNumber(48, false);
                        return this.valstate;
                    }
                    if (ch > 57 || ch < 48) {
                        this.out.unsafeWrite('0');
                        if (ch != -1) {
                            --this.start;
                        }
                        this.lval = 0L;
                        this.valstate = 2;
                        return 2;
                    }
                    throw this.err("Leading zeros not allowed");
                }
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: {
                    this.out.reset();
                    this.lval = this.readNumber(ch, false);
                    return this.valstate;
                }
                case 45: {
                    this.out.reset();
                    this.out.unsafeWrite('-');
                    ch = this.getChar();
                    if (ch < 48 || ch > 57) {
                        throw this.err("expected digit after '-'");
                    }
                    this.lval = this.readNumber(ch, true);
                    return this.valstate;
                }
                case 116: {
                    this.valstate = 5;
                    this.expect(JSONUtil.TRUE_CHARS);
                    this.bool = true;
                    return 5;
                }
                case 102: {
                    this.valstate = 5;
                    this.expect(JSONUtil.FALSE_CHARS);
                    this.bool = false;
                    return 5;
                }
                case 110: {
                    this.valstate = 6;
                    this.expect(JSONUtil.NULL_CHARS);
                    return 6;
                }
                case -1: {
                    if (this.getLevel() > 0) {
                        throw this.err("Premature EOF");
                    }
                    return 11;
                }
                default: {
                    throw this.err(null);
                }
            }
            ch = this.getChar();
        }
    }

    public String toString() {
        return "start=" + this.start + ",end=" + this.end + ",state=" + this.state + "valstate=" + this.valstate;
    }

    public int nextEvent() throws IOException {
        if (this.valstate == 1) {
            this.readStringChars2(devNull, this.start);
        } else if (this.valstate == 4) {
            this.continueNumber(devNull);
        }
        this.valstate = 0;
        switch (this.state) {
            case 0: {
                this.event = this.next(this.getCharNWS());
                return this.event;
            }
            case 1: {
                int ch = this.getCharNWS();
                if (ch == 125) {
                    this.pop();
                    this.event = 8;
                    return 8;
                }
                if (ch != 34) {
                    throw this.err("Expected string");
                }
                this.state = (byte)4;
                this.valstate = 1;
                this.event = 1;
                return 1;
            }
            case 4: {
                int ch = this.getCharNWS();
                if (ch != 58) {
                    throw this.err("Expected key,value separator ':'");
                }
                this.state = (byte)5;
                this.event = this.next(this.getChar());
                return this.event;
            }
            case 5: {
                int ch = this.getCharNWS();
                if (ch == 125) {
                    this.pop();
                    this.event = 8;
                    return 8;
                }
                if (ch != 44) {
                    throw this.err("Expected ',' or '}'");
                }
                ch = this.getCharNWS();
                if (ch != 34) {
                    throw this.err("Expected string");
                }
                this.state = (byte)4;
                this.valstate = 1;
                this.event = 1;
                return 1;
            }
            case 2: {
                int ch = this.getCharNWS();
                if (ch == 93) {
                    this.pop();
                    this.event = 10;
                    return 10;
                }
                this.state = (byte)3;
                this.event = this.next(ch);
                return this.event;
            }
            case 3: {
                int ch = this.getCharNWS();
                if (ch == 93) {
                    this.pop();
                    this.event = 10;
                    return 10;
                }
                if (ch != 44) {
                    throw this.err("Expected ',' or ']'");
                }
                this.event = this.next(this.getChar());
                return this.event;
            }
        }
        return 0;
    }

    public int lastEvent() {
        return this.event;
    }

    public boolean wasKey() {
        return this.state == 4;
    }

    private void goTo(int what) throws IOException {
        if (this.valstate == what) {
            this.valstate = 0;
            return;
        }
        if (this.valstate == 0) {
            int ev = this.nextEvent();
            if (this.valstate != what) {
                throw this.err("type mismatch");
            }
        } else {
            throw this.err("type mismatch");
        }
        this.valstate = 0;
    }

    public String getString() throws IOException {
        return this.getStringChars().toString();
    }

    public CharArr getStringChars() throws IOException {
        this.goTo(1);
        return this.readStringChars();
    }

    public void getString(CharArr output) throws IOException {
        this.goTo(1);
        this.readStringChars2(output, this.start);
    }

    public long getLong() throws IOException {
        this.goTo(2);
        return this.lval;
    }

    public double getDouble() throws IOException {
        return Double.parseDouble(this.getNumberChars().toString());
    }

    public CharArr getNumberChars() throws IOException {
        int ev = 0;
        if (this.valstate == 0) {
            ev = this.nextEvent();
        }
        if (this.valstate == 2 || this.valstate == 3) {
            this.valstate = 0;
            return this.out;
        }
        if (this.valstate == 4) {
            this.continueNumber(this.out);
            this.valstate = 0;
            return this.out;
        }
        throw this.err("Unexpected " + ev);
    }

    public void getNumberChars(CharArr output) throws IOException {
        int ev = 0;
        if (this.valstate == 0) {
            ev = this.nextEvent();
        }
        if (this.valstate == 2 || this.valstate == 3) {
            output.write(this.out);
        } else if (this.valstate == 4) {
            this.continueNumber(output);
        } else {
            throw this.err("Unexpected " + ev);
        }
        this.valstate = 0;
    }

    public boolean getBoolean() throws IOException {
        this.goTo(5);
        return this.bool;
    }

    public void getNull() throws IOException {
        this.goTo(6);
    }

    public int getLevel() {
        return this.ptr;
    }

    public long getPosition() {
        return this.gpos + (long)this.start;
    }

    public static class ParseException
    extends RuntimeException {
        public ParseException(String msg) {
            super(msg);
        }
    }
}

