/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.index.solr.server;

import java.io.IOException;
import javax.annotation.Nonnull;
import org.apache.jackrabbit.oak.plugins.index.solr.configuration.EmbeddedSolrServerConfiguration;
import org.apache.jackrabbit.oak.plugins.index.solr.configuration.SolrServerConfiguration;
import org.apache.jackrabbit.oak.plugins.index.solr.configuration.SolrServerConfigurationProvider;
import org.apache.jackrabbit.oak.plugins.index.solr.server.SolrServerProvider;
import org.apache.jackrabbit.oak.plugins.index.solr.server.SolrServerRegistry;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.client.solrj.SolrServer;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.common.util.NamedList;

public class OakSolrServer
extends SolrServer {
    private final SolrServerConfiguration solrServerConfiguration;
    private final SolrServerProvider solrServerProvider;

    public OakSolrServer(@Nonnull SolrServerConfigurationProvider solrServerConfigurationProvider) {
        this.solrServerConfiguration = solrServerConfigurationProvider.getSolrServerConfiguration();
        try {
            this.solrServerProvider = this.solrServerConfiguration.getProvider();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public NamedList<Object> request(SolrRequest request) throws SolrServerException, IOException {
        try {
            SolrServer server = this.getServer(request);
            return server.request(request);
        }
        catch (Exception e) {
            throw new SolrServerException(e);
        }
    }

    private synchronized SolrServer getServer(SolrRequest request) throws Exception {
        boolean isIndex = request.getPath().contains("/update");
        SolrServerRegistry.Strategy strategy = isIndex ? SolrServerRegistry.Strategy.INDEXING : SolrServerRegistry.Strategy.SEARCHING;
        SolrServer solrServer = SolrServerRegistry.get(this.solrServerConfiguration, strategy);
        if (solrServer == null) {
            if (this.solrServerConfiguration instanceof EmbeddedSolrServerConfiguration) {
                solrServer = this.solrServerProvider.getSolrServer();
                SolrServerRegistry.register(this.solrServerConfiguration, solrServer, SolrServerRegistry.Strategy.INDEXING);
                SolrServerRegistry.register(this.solrServerConfiguration, solrServer, SolrServerRegistry.Strategy.SEARCHING);
            } else {
                solrServer = isIndex ? this.solrServerProvider.getIndexingSolrServer() : this.solrServerProvider.getSearchingSolrServer();
                SolrServerRegistry.register(this.solrServerConfiguration, solrServer, strategy);
            }
        }
        return solrServer;
    }

    @Override
    public void shutdown() {
        try {
            this.solrServerProvider.close();
            SolrServerRegistry.unregister(this.solrServerConfiguration, SolrServerRegistry.Strategy.INDEXING);
            SolrServerRegistry.unregister(this.solrServerConfiguration, SolrServerRegistry.Strategy.SEARCHING);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

