/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search;

import java.io.IOException;
import org.apache.lucene.index.AtomicReaderContext;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.Scorer;
import org.apache.solr.search.EarlyTerminatingCollectorException;

public class EarlyTerminatingCollector
extends Collector {
    private final int maxDocsToCollect;
    private final Collector delegate;
    private int numCollected = 0;
    private int prevReaderCumulativeSize = 0;
    private int currentReaderSize = 0;

    public EarlyTerminatingCollector(Collector delegate, int maxDocsToCollect) {
        assert (0 < maxDocsToCollect);
        assert (null != delegate);
        this.delegate = delegate;
        this.maxDocsToCollect = maxDocsToCollect;
    }

    @Override
    public boolean acceptsDocsOutOfOrder() {
        return false;
    }

    @Override
    public void collect(int doc) throws IOException {
        this.delegate.collect(doc);
        ++this.numCollected;
        if (this.maxDocsToCollect <= this.numCollected) {
            throw new EarlyTerminatingCollectorException(this.numCollected, this.prevReaderCumulativeSize + (doc + 1));
        }
    }

    @Override
    public void setNextReader(AtomicReaderContext context) throws IOException {
        this.prevReaderCumulativeSize += this.currentReaderSize;
        this.currentReaderSize = context.reader().maxDoc() - 1;
        this.delegate.setNextReader(context);
    }

    @Override
    public void setScorer(Scorer scorer) throws IOException {
        this.delegate.setScorer(scorer);
    }
}

