/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.upgrade.security;

import java.util.Set;
import java.util.TreeSet;
import javax.annotation.Nonnull;
import org.apache.jackrabbit.oak.api.CommitFailedException;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.security.user.MembershipWriter;
import org.apache.jackrabbit.oak.spi.commit.DefaultEditor;
import org.apache.jackrabbit.oak.spi.commit.Editor;
import org.apache.jackrabbit.oak.spi.state.NodeBuilder;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.apache.jackrabbit.util.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class GroupEditor
extends DefaultEditor {
    private static final Logger log = LoggerFactory.getLogger(GroupEditor.class);
    private final String[] groupsRoot;
    private State state;
    private EditorGroup currentGroup;
    private final MembershipWriter writer = new MembershipWriter();

    GroupEditor(@Nonnull NodeBuilder builder, @Nonnull String groupsPath) {
        this.state = new State(builder);
        this.groupsRoot = Text.explode((String)groupsPath, (int)47, (boolean)false);
    }

    private boolean descend(String name) {
        if (this.state.depth < this.groupsRoot.length && !name.equals(this.groupsRoot[this.state.depth])) {
            return false;
        }
        this.state = this.state.push(name);
        return true;
    }

    private void ascend() {
        this.state = this.state.pop();
    }

    public void leave(NodeState before, NodeState after) throws CommitFailedException {
        if (this.currentGroup != null && this.currentGroup.path.equals(this.state.path)) {
            log.info("scanned group {}, {} members", (Object)this.currentGroup.path, (Object)this.currentGroup.members.size());
            this.writer.setMembers(this.state.builder, this.currentGroup.members);
            this.currentGroup = null;
        }
        this.ascend();
    }

    public Editor childNodeAdded(String name, NodeState after) throws CommitFailedException {
        if (!this.descend(name)) {
            return null;
        }
        String nt = after.getName("jcr:primaryType");
        if (nt == null) {
            throw new CommitFailedException("Constraint", 34, "jcr:primaryType missing at " + this.state.path);
        }
        if ("rep:Group".equals(nt)) {
            if (this.currentGroup != null) {
                log.error("rep:Group within rep:Group not supported during upgrade. current group: {}, overwriting group: {}", (Object)this.currentGroup.path, (Object)this.state.path);
            }
            this.currentGroup = new EditorGroup(this.state.path);
            this.currentGroup.addMembers(after.getProperty("rep:members"));
        } else if ("rep:Members".equals(nt)) {
            if (this.currentGroup == null) {
                log.warn("rep:Members detected outside of a rep:Group. ignoring {}", (Object)this.state.path);
            } else {
                this.currentGroup.addMembers(after);
            }
        }
        return this;
    }

    public Editor childNodeChanged(String name, NodeState before, NodeState after) {
        throw new IllegalStateException("changed node during upgrade copy not expected: " + this.state.path + "/" + name);
    }

    public Editor childNodeDeleted(String name, NodeState before) {
        throw new IllegalStateException("deleted node during upgrade copy not expected: " + this.state.path + "/" + name);
    }

    private static class EditorGroup {
        private final String path;
        private final Set<String> members = new TreeSet<String>();

        private EditorGroup(String path) {
            this.path = path;
        }

        private void addMembers(PropertyState repMembers) {
            if (repMembers != null) {
                for (String ref : (Iterable)repMembers.getValue(Type.WEAKREFERENCES)) {
                    this.members.add(ref);
                }
            }
        }

        private void addMembers(NodeState node) {
            for (PropertyState prop : node.getProperties()) {
                if (prop.getType() != Type.WEAKREFERENCE) continue;
                this.members.add((String)prop.getValue(Type.WEAKREFERENCE));
            }
        }
    }

    private static class State {
        private final State parent;
        private final String path;
        private final NodeBuilder builder;
        private final int depth;

        private State(State parent, String name) {
            this.parent = parent;
            this.path = parent.path + "/" + name;
            this.builder = parent.builder.child(name);
            this.depth = parent.depth + 1;
            log.debug("{} --> {}", (Object)this.depth, (Object)this.path);
        }

        private State(NodeBuilder builder) {
            this.parent = null;
            this.path = "";
            this.builder = builder;
            this.depth = 0;
        }

        private State push(String name) {
            return new State(this, name);
        }

        private State pop() {
            log.debug("{} <-- {}", (Object)this.depth, (Object)this.path);
            return this.parent;
        }
    }
}

