/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.s3;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Throwables;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import org.jclouds.Fallback;
import org.jclouds.blobstore.ContainerNotFoundException;
import org.jclouds.http.HttpUtils;
import org.jclouds.util.Throwables2;

public final class S3Fallbacks {
    private S3Fallbacks() {
    }

    public static final class TrueOn404OrNotFoundFalseOnIllegalState
    implements Fallback<Boolean> {
        public ListenableFuture<Boolean> create(Throwable t) throws Exception {
            return Futures.immediateFuture((Object)this.createOrPropagate(t));
        }

        public Boolean createOrPropagate(Throwable t) throws Exception {
            if (Throwables2.getFirstThrowableOfType((Throwable)((Throwable)Preconditions.checkNotNull((Object)t, (Object)"throwable")), IllegalStateException.class) != null) {
                return false;
            }
            if (Throwables2.getFirstThrowableOfType((Throwable)t, ContainerNotFoundException.class) != null) {
                return true;
            }
            if (HttpUtils.returnValueOnCodeOrNull((Throwable)t, (Object)true, (Predicate)Predicates.equalTo((Object)404)) != null) {
                return true;
            }
            throw Throwables.propagate((Throwable)t);
        }
    }
}

