/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.s3.blobstore;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.reflect.Invokable;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.blobstore.BlobRequestSigner;
import org.jclouds.blobstore.domain.Blob;
import org.jclouds.blobstore.functions.BlobToHttpGetOptions;
import org.jclouds.blobstore.util.BlobStoreUtils;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.options.GetOptions;
import org.jclouds.reflect.Invocation;
import org.jclouds.reflect.Reflection2;
import org.jclouds.rest.internal.RestAnnotationProcessor;
import org.jclouds.s3.S3AsyncClient;
import org.jclouds.s3.blobstore.functions.BlobToObject;
import org.jclouds.s3.domain.S3Object;
import org.jclouds.s3.options.PutObjectOptions;

@Singleton
public class S3BlobRequestSigner<T extends S3AsyncClient>
implements BlobRequestSigner {
    protected final RestAnnotationProcessor processor;
    protected final BlobToObject blobToObject;
    protected final BlobToHttpGetOptions blob2HttpGetOptions;
    protected final Invokable<?, ?> getMethod;
    protected final Invokable<?, ?> deleteMethod;
    protected final Invokable<?, ?> createMethod;

    @Inject
    public S3BlobRequestSigner(RestAnnotationProcessor processor, BlobToObject blobToObject, BlobToHttpGetOptions blob2HttpGetOptions, Class<T> interfaceClass) throws SecurityException, NoSuchMethodException {
        this.processor = (RestAnnotationProcessor)Preconditions.checkNotNull((Object)processor, (Object)"processor");
        this.blobToObject = (BlobToObject)Preconditions.checkNotNull((Object)blobToObject, (Object)"blobToObject");
        this.blob2HttpGetOptions = (BlobToHttpGetOptions)Preconditions.checkNotNull((Object)blob2HttpGetOptions, (Object)"blob2HttpGetOptions");
        this.getMethod = Reflection2.method(interfaceClass, (String)"getObject", (Class[])new Class[]{String.class, String.class, GetOptions[].class});
        this.deleteMethod = Reflection2.method(interfaceClass, (String)"deleteObject", (Class[])new Class[]{String.class, String.class});
        this.createMethod = Reflection2.method(interfaceClass, (String)"putObject", (Class[])new Class[]{String.class, S3Object.class, PutObjectOptions[].class});
    }

    public HttpRequest signGetBlob(String container, String name) {
        Preconditions.checkNotNull((Object)container, (Object)"container");
        Preconditions.checkNotNull((Object)name, (Object)"name");
        return BlobStoreUtils.cleanRequest((HttpRequest)this.processor.apply(Invocation.create(this.getMethod, (List)ImmutableList.of((Object)container, (Object)name))));
    }

    public HttpRequest signGetBlob(String container, String name, long timeInSeconds) {
        throw new UnsupportedOperationException();
    }

    public HttpRequest signPutBlob(String container, Blob blob) {
        Preconditions.checkNotNull((Object)container, (Object)"container");
        Preconditions.checkNotNull((Object)blob, (Object)"blob");
        return BlobStoreUtils.cleanRequest((HttpRequest)this.processor.apply(Invocation.create(this.createMethod, (List)ImmutableList.of((Object)container, (Object)this.blobToObject.apply(blob)))));
    }

    public HttpRequest signPutBlob(String container, Blob blob, long timeInSeconds) {
        throw new UnsupportedOperationException();
    }

    public HttpRequest signRemoveBlob(String container, String name) {
        Preconditions.checkNotNull((Object)container, (Object)"container");
        Preconditions.checkNotNull((Object)name, (Object)"name");
        return BlobStoreUtils.cleanRequest((HttpRequest)this.processor.apply(Invocation.create(this.deleteMethod, (List)ImmutableList.of((Object)container, (Object)name))));
    }

    public HttpRequest signGetBlob(String container, String name, org.jclouds.blobstore.options.GetOptions options) {
        Preconditions.checkNotNull((Object)container, (Object)"container");
        Preconditions.checkNotNull((Object)name, (Object)"name");
        return BlobStoreUtils.cleanRequest((HttpRequest)this.processor.apply(Invocation.create(this.getMethod, (List)ImmutableList.of((Object)container, (Object)name, (Object)this.blob2HttpGetOptions.apply((org.jclouds.blobstore.options.GetOptions)Preconditions.checkNotNull((Object)options, (Object)"options"))))));
    }
}

