/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.io.ops;

import java.io.IOException;
import java.util.List;
import java.util.UUID;
import org.apache.solr.client.solrj.io.Tuple;
import org.apache.solr.client.solrj.io.ops.BooleanOperation;
import org.apache.solr.client.solrj.io.ops.StreamOperation;
import org.apache.solr.client.solrj.io.stream.expr.Explanation;
import org.apache.solr.client.solrj.io.stream.expr.Expressible;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpression;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpressionParameter;
import org.apache.solr.client.solrj.io.stream.expr.StreamFactory;

public class NotOperation
implements BooleanOperation {
    private static final long serialVersionUID = 1L;
    private UUID operationNodeId = UUID.randomUUID();
    protected BooleanOperation operand;

    @Override
    public void operate(Tuple tuple) {
        this.operand.operate(tuple);
    }

    public NotOperation(BooleanOperation operand) {
        this.operand = operand;
    }

    public NotOperation(StreamExpression expression, StreamFactory factory) throws IOException {
        StreamOperation streamOp;
        List<StreamExpression> operationExpressions = factory.getExpressionOperandsRepresentingTypes(expression, BooleanOperation.class);
        if (operationExpressions != null && operationExpressions.size() == 1) {
            StreamExpression op = operationExpressions.get(0);
            streamOp = factory.constructOperation(op);
            if (!(streamOp instanceof BooleanOperation)) {
                throw new IOException("The NotOperation requires a BooleanOperation.");
            }
        } else {
            throw new IOException("The NotOperation requires a BooleanOperations.");
        }
        this.operand = (BooleanOperation)streamOp;
    }

    @Override
    public boolean evaluate() {
        return !this.operand.evaluate();
    }

    @Override
    public StreamExpressionParameter toExpression(StreamFactory factory) throws IOException {
        StreamExpression expression = new StreamExpression(factory.getFunctionName(this.getClass()));
        if (!(this.operand instanceof Expressible)) {
            throw new IOException("The operand of the NotOperation contains a non-expressible operation - it cannot be converted to an expression");
        }
        expression.addParameter(this.operand.toExpression(factory));
        return expression;
    }

    @Override
    public Explanation toExplanation(StreamFactory factory) throws IOException {
        return new Explanation(this.operationNodeId.toString()).withExpressionType("operation").withFunctionName(factory.getFunctionName(this.getClass())).withImplementingClass(this.getClass().getName()).withExpression(this.toExpression(factory).toString());
    }
}

