/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.io.stream.metrics;

import java.io.IOException;
import java.util.Locale;
import org.apache.solr.client.solrj.io.Tuple;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpression;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpressionParameter;
import org.apache.solr.client.solrj.io.stream.expr.StreamFactory;
import org.apache.solr.client.solrj.io.stream.metrics.Metric;

public class MeanMetric
extends Metric {
    private String columnName;
    private double doubleSum;
    private long longSum;
    private long count;

    public MeanMetric(String columnName) {
        this.init("avg", columnName);
    }

    public MeanMetric(StreamExpression expression, StreamFactory factory) throws IOException {
        String functionName = expression.getFunctionName();
        String columnName = factory.getValueOperand(expression, 0);
        if (null == columnName) {
            throw new IOException(String.format(Locale.ROOT, "Invalid expression %s - expected %s(columnName)", expression, functionName));
        }
        if (1 != expression.getParameters().size()) {
            throw new IOException(String.format(Locale.ROOT, "Invalid expression %s - unknown operands found", expression));
        }
        this.init(functionName, columnName);
    }

    private void init(String functionName, String columnName) {
        this.columnName = columnName;
        this.setFunctionName(functionName);
        this.setIdentifier(functionName, "(", columnName, ")");
    }

    @Override
    public void update(Tuple tuple) {
        ++this.count;
        Object o = tuple.get(this.columnName);
        if (o instanceof Double) {
            Double d = (Double)tuple.get(this.columnName);
            this.doubleSum += d.doubleValue();
        } else {
            Long l = (Long)tuple.get(this.columnName);
            this.longSum += l.longValue();
        }
    }

    @Override
    public Metric newInstance() {
        return new MeanMetric(this.columnName);
    }

    @Override
    public String[] getColumns() {
        return new String[]{this.columnName};
    }

    @Override
    public Double getValue() {
        double dcount = this.count;
        if (this.longSum == 0L) {
            return this.doubleSum / dcount;
        }
        return (double)this.longSum / dcount;
    }

    @Override
    public StreamExpressionParameter toExpression(StreamFactory factory) throws IOException {
        return new StreamExpression(this.getFunctionName()).withParameter(this.columnName);
    }
}

