/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.attribute;

import org.apache.spark.annotation.DeveloperApi;
import org.apache.spark.ml.attribute.Attribute;
import org.apache.spark.ml.attribute.AttributeGroup;
import org.apache.spark.ml.attribute.AttributeKeys$;
import org.apache.spark.ml.attribute.AttributeType$;
import org.apache.spark.ml.attribute.BinaryAttribute;
import org.apache.spark.ml.attribute.BinaryAttribute$;
import org.apache.spark.ml.attribute.NominalAttribute;
import org.apache.spark.ml.attribute.NominalAttribute$;
import org.apache.spark.ml.attribute.NumericAttribute;
import org.apache.spark.ml.attribute.NumericAttribute$;
import org.apache.spark.mllib.linalg.VectorUDT;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.Metadata;
import org.apache.spark.sql.types.StructField;
import scala.Array$;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;

@DeveloperApi
public final class AttributeGroup$
implements Serializable {
    public static final AttributeGroup$ MODULE$;

    static {
        new AttributeGroup$();
    }

    public AttributeGroup fromMetadata(Metadata metadata, String name) {
        AttributeGroup attributeGroup;
        if (metadata.contains(AttributeKeys$.MODULE$.ATTRIBUTES())) {
            int numAttrs = (int)metadata.getLong(AttributeKeys$.MODULE$.NUM_ATTRIBUTES());
            Attribute[] attributes = new Attribute[numAttrs];
            Metadata attrMetadata = metadata.getMetadata(AttributeKeys$.MODULE$.ATTRIBUTES());
            if (attrMetadata.contains(AttributeType$.MODULE$.Numeric().name())) {
                Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])attrMetadata.getMetadataArray(AttributeType$.MODULE$.Numeric().name())).map((Function1)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final NumericAttribute apply(Metadata metadata) {
                        return NumericAttribute$.MODULE$.fromMetadata(metadata);
                    }
                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(NumericAttribute.class)))).foreach((Function1)new Serializable(attributes){
                    public static final long serialVersionUID = 0L;
                    private final Attribute[] attributes$1;

                    public final void apply(NumericAttribute attr) {
                        this.attributes$1[BoxesRunTime.unboxToInt((Object)attr.index().get())] = attr;
                    }
                    {
                        this.attributes$1 = attributes$1;
                    }
                });
            }
            if (attrMetadata.contains(AttributeType$.MODULE$.Nominal().name())) {
                Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])attrMetadata.getMetadataArray(AttributeType$.MODULE$.Nominal().name())).map((Function1)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final NominalAttribute apply(Metadata metadata) {
                        return NominalAttribute$.MODULE$.fromMetadata(metadata);
                    }
                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(NominalAttribute.class)))).foreach((Function1)new Serializable(attributes){
                    public static final long serialVersionUID = 0L;
                    private final Attribute[] attributes$1;

                    public final void apply(NominalAttribute attr) {
                        this.attributes$1[BoxesRunTime.unboxToInt((Object)attr.index().get())] = attr;
                    }
                    {
                        this.attributes$1 = attributes$1;
                    }
                });
            }
            if (attrMetadata.contains(AttributeType$.MODULE$.Binary().name())) {
                Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])attrMetadata.getMetadataArray(AttributeType$.MODULE$.Binary().name())).map((Function1)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final BinaryAttribute apply(Metadata metadata) {
                        return BinaryAttribute$.MODULE$.fromMetadata(metadata);
                    }
                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(BinaryAttribute.class)))).foreach((Function1)new Serializable(attributes){
                    public static final long serialVersionUID = 0L;
                    private final Attribute[] attributes$1;

                    public final void apply(BinaryAttribute attr) {
                        this.attributes$1[BoxesRunTime.unboxToInt((Object)attr.index().get())] = attr;
                    }
                    {
                        this.attributes$1 = attributes$1;
                    }
                });
            }
            for (int i = 0; i < numAttrs; ++i) {
                if (attributes[i] != null) continue;
                attributes[i] = NumericAttribute$.MODULE$.defaultAttr();
            }
            attributeGroup = new AttributeGroup(name, attributes);
        } else {
            attributeGroup = metadata.contains(AttributeKeys$.MODULE$.NUM_ATTRIBUTES()) ? new AttributeGroup(name, (int)metadata.getLong(AttributeKeys$.MODULE$.NUM_ATTRIBUTES())) : new AttributeGroup(name);
        }
        return attributeGroup;
    }

    public AttributeGroup fromStructField(StructField field) {
        DataType dataType = field.dataType();
        VectorUDT vectorUDT = new VectorUDT();
        Predef$.MODULE$.require(!(dataType != null ? !dataType.equals((Object)vectorUDT) : vectorUDT != null));
        return field.metadata().contains(AttributeKeys$.MODULE$.ML_ATTR()) ? this.fromMetadata(field.metadata().getMetadata(AttributeKeys$.MODULE$.ML_ATTR()), field.name()) : new AttributeGroup(field.name());
    }

    private Object readResolve() {
        return MODULE$;
    }

    private AttributeGroup$() {
        MODULE$ = this;
    }
}

