/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.feature;

import org.apache.spark.annotation.Experimental;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.mllib.feature.VectorTransformer;
import org.apache.spark.mllib.feature.VectorTransformer$class;
import org.apache.spark.mllib.linalg.DenseVector;
import org.apache.spark.mllib.linalg.DenseVector$;
import org.apache.spark.mllib.linalg.SparseVector;
import org.apache.spark.mllib.linalg.SparseVector$;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.linalg.Vectors$;
import org.apache.spark.rdd.RDD;
import scala.Option;
import scala.Predef$;
import scala.Tuple3;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@Experimental
@ScalaSignature(bytes="\u0006\u0001}2A!\u0001\u0002\u0001\u001b\tQaj\u001c:nC2L'0\u001a:\u000b\u0005\r!\u0011a\u00024fCR,(/\u001a\u0006\u0003\u000b\u0019\tQ!\u001c7mS\nT!a\u0002\u0005\u0002\u000bM\u0004\u0018M]6\u000b\u0005%Q\u0011AB1qC\u000eDWMC\u0001\f\u0003\ry'oZ\u0002\u0001'\r\u0001a\u0002\u0006\t\u0003\u001fIi\u0011\u0001\u0005\u0006\u0002#\u0005)1oY1mC&\u00111\u0003\u0005\u0002\u0007\u0003:L(+\u001a4\u0011\u0005U1R\"\u0001\u0002\n\u0005]\u0011!!\u0005,fGR|'\u000f\u0016:b]N4wN]7fe\"A\u0011\u0004\u0001B\u0001B\u0003%!$A\u0001q!\ty1$\u0003\u0002\u001d!\t1Ai\\;cY\u0016DQA\b\u0001\u0005\u0002}\ta\u0001P5oSRtDC\u0001\u0011\"!\t)\u0002\u0001C\u0003\u001a;\u0001\u0007!\u0004K\u0002\u001eG%\u0002\"\u0001J\u0014\u000e\u0003\u0015R!A\n\u0004\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0002)K\t)1+\u001b8dK\u0006\n!&A\u00032]Er\u0003\u0007C\u0003\u001f\u0001\u0011\u0005A\u0006F\u0001!Q\rY3%\u000b\u0005\u0006_\u0001!\t\u0005M\u0001\niJ\fgn\u001d4pe6$\"!M\u001c\u0011\u0005I*T\"A\u001a\u000b\u0005Q\"\u0011A\u00027j]\u0006dw-\u0003\u00027g\t1a+Z2u_JDQ\u0001\u000f\u0018A\u0002E\naA^3di>\u0014\bf\u0001\u0018$S!\u0012\u0001a\u000f\t\u0003IqJ!!P\u0013\u0003\u0019\u0015C\b/\u001a:j[\u0016tG/\u00197)\u0007\u0001\u0019\u0013\u0006")
public class Normalizer
implements VectorTransformer {
    private final double p;

    @Override
    public RDD<Vector> transform(RDD<Vector> data) {
        return VectorTransformer$class.transform((VectorTransformer)this, data);
    }

    @Override
    public JavaRDD<Vector> transform(JavaRDD<Vector> data) {
        return VectorTransformer$class.transform((VectorTransformer)this, data);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Vector transform(Vector vector) {
        Vector vector2;
        double norm2 = Vectors$.MODULE$.norm(vector, this.p);
        if (norm2 != 0.0) {
            Vector vector3;
            DenseVector denseVector;
            Option<double[]> option;
            Vector vector4 = vector;
            if (vector4 instanceof DenseVector && !(option = DenseVector$.MODULE$.unapply(denseVector = (DenseVector)vector4)).isEmpty()) {
                double[] vs = (double[])option.get();
                double[] values = (double[])vs.clone();
                int size = Predef$.MODULE$.doubleArrayOps(values).size();
                int i = 0;
                while (i < size) {
                    int n = i++;
                    values[n] = values[n] / norm2;
                }
                vector3 = Vectors$.MODULE$.dense(values);
            } else {
                SparseVector sparseVector;
                Option<Tuple3<Object, int[], double[]>> option2;
                if (!(vector4 instanceof SparseVector) || (option2 = SparseVector$.MODULE$.unapply(sparseVector = (SparseVector)vector4)).isEmpty()) throw new IllegalArgumentException(new StringBuilder().append((Object)"Do not support vector type ").append(vector4.getClass()).toString());
                int size = BoxesRunTime.unboxToInt((Object)((Tuple3)option2.get())._1());
                int[] ids = (int[])((Tuple3)option2.get())._2();
                double[] vs = (double[])((Tuple3)option2.get())._3();
                double[] values = (double[])vs.clone();
                int nnz = Predef$.MODULE$.doubleArrayOps(values).size();
                int i = 0;
                while (i < nnz) {
                    int n = i++;
                    values[n] = values[n] / norm2;
                }
                vector3 = Vectors$.MODULE$.sparse(size, ids, values);
            }
            vector2 = vector3;
            return vector2;
        } else {
            vector2 = vector;
        }
        return vector2;
    }

    public Normalizer(double p) {
        this.p = p;
        VectorTransformer$class.$init$(this);
        Predef$.MODULE$.require(p >= 1.0);
    }

    public Normalizer() {
        this(2.0);
    }
}

