/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.recommendation;

import org.apache.spark.SparkContext;
import org.apache.spark.SparkContext$;
import org.apache.spark.mllib.recommendation.ALS;
import org.apache.spark.mllib.recommendation.MatrixFactorizationModel;
import org.apache.spark.mllib.recommendation.Rating;
import org.apache.spark.rdd.RDD;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.ScalaObject;
import scala.Serializable;
import scala.Tuple2;
import scala.Tuple5;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassManifest$;
import scala.runtime.BoxesRunTime;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ALS$
implements ScalaObject,
Serializable {
    public static final ALS$ MODULE$;

    static {
        new ALS$();
    }

    public MatrixFactorizationModel train(RDD<Rating> ratings, int rank, int iterations, double lambda, int blocks) {
        return new ALS(blocks, rank, iterations, lambda).run(ratings);
    }

    public MatrixFactorizationModel train(RDD<Rating> ratings, int rank, int iterations, double lambda) {
        return this.train(ratings, rank, iterations, lambda, -1);
    }

    public MatrixFactorizationModel train(RDD<Rating> ratings, int rank, int iterations) {
        return this.train(ratings, rank, iterations, 0.01, -1);
    }

    public void main(String[] args) {
        Tuple5 tuple5;
        if (args.length != 5 && args.length != 6) {
            Predef$.MODULE$.println((Object)"Usage: ALS <master> <ratings_file> <rank> <iterations> <output_dir> [<blocks>]");
            System.exit(1);
        }
        if ((tuple5 = new Tuple5((Object)args[0], (Object)args[1], (Object)BoxesRunTime.boxToInteger((int)Predef$.MODULE$.augmentString(args[2]).toInt()), (Object)BoxesRunTime.boxToInteger((int)Predef$.MODULE$.augmentString(args[3]).toInt()), (Object)args[4])) != null) {
            Tuple5 tuple52 = new Tuple5(tuple5._1(), tuple5._2(), tuple5._3(), tuple5._4(), tuple5._5());
            String master = (String)tuple52._1();
            String ratingsFile = (String)tuple52._2();
            int rank = BoxesRunTime.unboxToInt((Object)tuple52._3());
            int iters = BoxesRunTime.unboxToInt((Object)tuple52._4());
            String outputDir = (String)tuple52._5();
            int blocks = args.length == 6 ? Predef$.MODULE$.augmentString(args[5]).toInt() : -1;
            System.setProperty("spark.serializer", "org.apache.spark.serializer.KryoSerializer");
            System.setProperty("spark.kryo.registrator", ALS.ALSRegistrator.class.getName());
            System.setProperty("spark.kryo.referenceTracking", "false");
            System.setProperty("spark.kryoserializer.buffer.mb", "8");
            System.setProperty("spark.locality.wait", "10000");
            SparkContext sc = new SparkContext(master, "ALS", SparkContext$.MODULE$.init$default$3(), SparkContext$.MODULE$.init$default$4(), SparkContext$.MODULE$.init$default$5(), SparkContext$.MODULE$.init$default$6());
            RDD ratings = sc.textFile(ratingsFile, sc.textFile$default$2()).map((Function1)new Serializable(){
                public static final long serialVersionUID;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final Rating apply(String line) {
                    String[] fields = Predef$.MODULE$.augmentString(line).split(',');
                    return new Rating(Predef$.MODULE$.augmentString(fields[0]).toInt(), Predef$.MODULE$.augmentString(fields[1]).toInt(), Predef$.MODULE$.augmentString(fields[2]).toDouble());
                }
            }, ClassManifest$.MODULE$.classType(Rating.class));
            MatrixFactorizationModel model = this.train((RDD<Rating>)ratings, rank, iters, 0.01, blocks);
            model.userFeatures().map((Function1)new Serializable(){
                public static final long serialVersionUID;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final String apply(Tuple2<Object, double[]> tuple2) {
                    Tuple2<Object, double[]> tuple22 = tuple2;
                    if (tuple22 != null) {
                        return new StringBuilder().append(BoxesRunTime.unboxToInt((Object)tuple22._1())).append((Object)",").append((Object)Predef$.MODULE$.doubleArrayOps((double[])tuple22._2()).mkString(" ")).toString();
                    }
                    throw new MatchError(tuple22);
                }
            }, ClassManifest$.MODULE$.classType(String.class)).saveAsTextFile(new StringBuilder().append((Object)outputDir).append((Object)"/userFeatures").toString());
            model.productFeatures().map((Function1)new Serializable(){
                public static final long serialVersionUID;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final String apply(Tuple2<Object, double[]> tuple2) {
                    Tuple2<Object, double[]> tuple22 = tuple2;
                    if (tuple22 != null) {
                        return new StringBuilder().append(BoxesRunTime.unboxToInt((Object)tuple22._1())).append((Object)",").append((Object)Predef$.MODULE$.doubleArrayOps((double[])tuple22._2()).mkString(" ")).toString();
                    }
                    throw new MatchError(tuple22);
                }
            }, ClassManifest$.MODULE$.classType(String.class)).saveAsTextFile(new StringBuilder().append((Object)outputDir).append((Object)"/productFeatures").toString());
            Predef$.MODULE$.println((Object)new StringBuilder().append((Object)"Final user/product features written to ").append((Object)outputDir).toString());
            System.exit(0);
            return;
        }
        throw new MatchError((Object)tuple5);
    }

    public Object readResolve() {
        return MODULE$;
    }

    private ALS$() {
        MODULE$ = this;
    }
}

