/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.regression;

import org.apache.spark.mllib.optimization.GradientDescent;
import org.apache.spark.mllib.optimization.L1Updater;
import org.apache.spark.mllib.optimization.SquaredGradient;
import org.apache.spark.mllib.regression.GeneralizedLinearAlgorithm;
import org.apache.spark.mllib.regression.LabeledPoint;
import org.apache.spark.mllib.regression.LassoModel;
import org.apache.spark.mllib.regression.LassoWithSGD$;
import org.apache.spark.mllib.util.MLUtils$;
import org.apache.spark.rdd.RDD;
import org.jblas.DoubleMatrix;
import scala.Array$;
import scala.Function1;
import scala.Predef$;
import scala.ScalaObject;
import scala.Serializable;
import scala.Tuple3;
import scala.collection.GenTraversableOnce;
import scala.collection.Seq;
import scala.reflect.ClassManifest;
import scala.reflect.ClassManifest$;
import scala.reflect.Manifest$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ScalaSignature(bytes="\u0006\u0001\u0005-g\u0001B\u0001\u0003\u00015\u0011A\u0002T1tg><\u0016\u000e\u001e5T\u000f\u0012S!a\u0001\u0003\u0002\u0015I,wM]3tg&|gN\u0003\u0002\u0006\r\u0005)Q\u000e\u001c7jE*\u0011q\u0001C\u0001\u0006gB\f'o\u001b\u0006\u0003\u0013)\ta!\u00199bG\",'\"A\u0006\u0002\u0007=\u0014xm\u0001\u0001\u0014\t\u0001qQc\u0007\t\u0004\u001fA\u0011R\"\u0001\u0002\n\u0005E\u0011!AG$f]\u0016\u0014\u0018\r\\5{K\u0012d\u0015N\\3be\u0006cwm\u001c:ji\"l\u0007CA\b\u0014\u0013\t!\"A\u0001\u0006MCN\u001cx.T8eK2\u0004\"AF\r\u000e\u0003]Q\u0011\u0001G\u0001\u0006g\u000e\fG.Y\u0005\u00035]\u0011AbU3sS\u0006d\u0017N_1cY\u0016\u0004\"A\u0006\u000f\n\u0005u9\"aC*dC2\fwJ\u00196fGRD\u0001b\b\u0001\u0003\u0002\u0004%\t\u0001I\u0001\tgR,\u0007oU5{KV\t\u0011\u0005\u0005\u0002\u0017E%\u00111e\u0006\u0002\u0007\t>,(\r\\3\t\u0011\u0015\u0002!\u00111A\u0005\u0002\u0019\nAb\u001d;faNK'0Z0%KF$\"a\n\u0016\u0011\u0005YA\u0013BA\u0015\u0018\u0005\u0011)f.\u001b;\t\u000f-\"\u0013\u0011!a\u0001C\u0005\u0019\u0001\u0010J\u0019\t\u00115\u0002!\u0011!Q!\n\u0005\n\u0011b\u001d;faNK'0\u001a\u0011\t\u0011=\u0002!\u00111A\u0005\u0002A\nQB\\;n\u0013R,'/\u0019;j_:\u001cX#A\u0019\u0011\u0005Y\u0011\u0014BA\u001a\u0018\u0005\rIe\u000e\u001e\u0005\tk\u0001\u0011\t\u0019!C\u0001m\u0005\tb.^7Ji\u0016\u0014\u0018\r^5p]N|F%Z9\u0015\u0005\u001d:\u0004bB\u00165\u0003\u0003\u0005\r!\r\u0005\ts\u0001\u0011\t\u0011)Q\u0005c\u0005qa.^7Ji\u0016\u0014\u0018\r^5p]N\u0004\u0003\u0002C\u001e\u0001\u0005\u0003\u0007I\u0011\u0001\u0011\u0002\u0011I,w\rU1sC6D\u0001\"\u0010\u0001\u0003\u0002\u0004%\tAP\u0001\re\u0016<\u0007+\u0019:b[~#S-\u001d\u000b\u0003O}Bqa\u000b\u001f\u0002\u0002\u0003\u0007\u0011\u0005\u0003\u0005B\u0001\t\u0005\t\u0015)\u0003\"\u0003%\u0011Xm\u001a)be\u0006l\u0007\u0005\u0003\u0005D\u0001\t\u0005\r\u0011\"\u0001!\u0003Ei\u0017N\\5CCR\u001c\u0007N\u0012:bGRLwN\u001c\u0005\t\u000b\u0002\u0011\t\u0019!C\u0001\r\u0006)R.\u001b8j\u0005\u0006$8\r\u001b$sC\u000e$\u0018n\u001c8`I\u0015\fHCA\u0014H\u0011\u001dYC)!AA\u0002\u0005B\u0001\"\u0013\u0001\u0003\u0002\u0003\u0006K!I\u0001\u0013[&t\u0017NQ1uG\"4%/Y2uS>t\u0007\u0005C\u0003L\u0001\u0011%A*\u0001\u0004=S:LGO\u0010\u000b\u0006\u001b:{\u0005+\u0015\t\u0003\u001f\u0001AQa\b&A\u0002\u0005BQa\f&A\u0002EBQa\u000f&A\u0002\u0005BQa\u0011&A\u0002\u0005Bqa\u0015\u0001C\u0002\u0013\u0005A+\u0001\u0005he\u0006$\u0017.\u001a8u+\u0005)\u0006C\u0001,Z\u001b\u00059&B\u0001-\u0005\u00031y\u0007\u000f^5nSj\fG/[8o\u0013\tQvKA\bTcV\f'/\u001a3He\u0006$\u0017.\u001a8u\u0011\u0019a\u0006\u0001)A\u0005+\u0006IqM]1eS\u0016tG\u000f\t\u0005\b=\u0002\u0011\r\u0011\"\u0001`\u0003\u001d)\b\u000fZ1uKJ,\u0012\u0001\u0019\t\u0003-\u0006L!AY,\u0003\u00131\u000bT\u000b\u001d3bi\u0016\u0014\bB\u00023\u0001A\u0003%\u0001-\u0001\u0005va\u0012\fG/\u001a:!\u0011\u001d1\u0007A1A\u0005\u0002\u001d\f\u0011b\u001c9uS6L'0\u001a:\u0016\u0003!\u0004\"AV5\n\u0005)<&aD$sC\u0012LWM\u001c;EKN\u001cWM\u001c;\t\r1\u0004\u0001\u0015!\u0003i\u0003)y\u0007\u000f^5nSj,'\u000f\t\u0015\u0003W:\u0004\"AF8\n\u0005A<\"!\u0003;sC:\u001c\u0018.\u001a8u\u0011\u001d\u0011\b\u00011A\u0005\u0002\u0001\nQ!_'fC:Dq\u0001\u001e\u0001A\u0002\u0013\u0005Q/A\u0005z\u001b\u0016\fgn\u0018\u0013fcR\u0011qE\u001e\u0005\bWM\f\t\u00111\u0001\"\u0011\u0019A\b\u0001)Q\u0005C\u00051\u00110T3b]\u0002BqA\u001f\u0001A\u0002\u0013\u000510\u0001\u0005y\u0007>dW*Z1o+\u0005a\bcA?\u0002\u00025\taP\u0003\u0002\u0000\u0015\u0005)!N\u00197bg&\u0019\u00111\u0001@\u0003\u0019\u0011{WO\u00197f\u001b\u0006$(/\u001b=\t\u0013\u0005\u001d\u0001\u00011A\u0005\u0002\u0005%\u0011\u0001\u0004=D_2lU-\u00198`I\u0015\fHcA\u0014\u0002\f!A1&!\u0002\u0002\u0002\u0003\u0007A\u0010C\u0004\u0002\u0010\u0001\u0001\u000b\u0015\u0002?\u0002\u0013a\u001cu\u000e\\'fC:\u0004\u0003\u0002CA\n\u0001\u0001\u0007I\u0011A>\u0002\ra\u001cu\u000e\\*e\u0011%\t9\u0002\u0001a\u0001\n\u0003\tI\"\u0001\u0006y\u0007>d7\u000bZ0%KF$2aJA\u000e\u0011!Y\u0013QCA\u0001\u0002\u0004a\bbBA\u0010\u0001\u0001\u0006K\u0001`\u0001\bq\u000e{Gn\u00153!\u0011\u0019Y\u0005\u0001\"\u0001\u0002$Q\tQ\nC\u0004\u0002(\u0001!\t!!\u000b\u0002\u0017\r\u0014X-\u0019;f\u001b>$W\r\u001c\u000b\u0006%\u0005-\u0012Q\u0007\u0005\t\u0003[\t)\u00031\u0001\u00020\u00059q/Z5hQR\u001c\b\u0003\u0002\f\u00022\u0005J1!a\r\u0018\u0005\u0015\t%O]1z\u0011\u001d\t9$!\nA\u0002\u0005\n\u0011\"\u001b8uKJ\u001cW\r\u001d;\t\u000f\u0005m\u0002\u0001\"\u0011\u0002>\u0005\u0019!/\u001e8\u0015\u000bI\ty$!\u0016\t\u0011\u0005\u0005\u0013\u0011\ba\u0001\u0003\u0007\nQ!\u001b8qkR\u0004b!!\u0012\u0002L\u0005=SBAA$\u0015\r\tIEB\u0001\u0004e\u0012$\u0017\u0002BA'\u0003\u000f\u00121A\u0015#E!\ry\u0011\u0011K\u0005\u0004\u0003'\u0012!\u0001\u0004'bE\u0016dW\r\u001a)pS:$\b\u0002CA,\u0003s\u0001\r!a\f\u0002\u001d%t\u0017\u000e^5bY^+\u0017n\u001a5ug\u001e9\u00111\f\u0002\t\u0006\u0005u\u0013\u0001\u0004'bgN|w+\u001b;i'\u001e#\u0005cA\b\u0002`\u00191\u0011A\u0001E\u0003\u0003C\u001ab!a\u0018\u0002dm)\u0002\u0003BA3\u0003_j!!a\u001a\u000b\t\u0005%\u00141N\u0001\u0005Y\u0006twM\u0003\u0002\u0002n\u0005!!.\u0019<b\u0013\u0011\t\t(a\u001a\u0003\r=\u0013'.Z2u\u0011\u001dY\u0015q\fC\u0001\u0003k\"\"!!\u0018\t\u0011\u0005e\u0014q\fC\u0001\u0003w\nQ\u0001\u001e:bS:$RBEA?\u0003\u007f\n\t)a!\u0002\u0006\u0006\u001d\u0005\u0002CA!\u0003o\u0002\r!a\u0011\t\r=\n9\b1\u00012\u0011\u0019y\u0012q\u000fa\u0001C!11(a\u001eA\u0002\u0005BaaQA<\u0001\u0004\t\u0003\u0002CA,\u0003o\u0002\r!a\f\t\u0011\u0005e\u0014q\fC\u0001\u0003\u0017#2BEAG\u0003\u001f\u000b\t*a%\u0002\u0016\"A\u0011\u0011IAE\u0001\u0004\t\u0019\u0005\u0003\u00040\u0003\u0013\u0003\r!\r\u0005\u0007?\u0005%\u0005\u0019A\u0011\t\rm\nI\t1\u0001\"\u0011\u0019\u0019\u0015\u0011\u0012a\u0001C!A\u0011\u0011PA0\t\u0003\tI\nF\u0005\u0013\u00037\u000bi*a(\u0002\"\"A\u0011\u0011IAL\u0001\u0004\t\u0019\u0005\u0003\u00040\u0003/\u0003\r!\r\u0005\u0007?\u0005]\u0005\u0019A\u0011\t\rm\n9\n1\u0001\"\u0011!\tI(a\u0018\u0005\u0002\u0005\u0015F#\u0002\n\u0002(\u0006%\u0006\u0002CA!\u0003G\u0003\r!a\u0011\t\r=\n\u0019\u000b1\u00012\u0011!\ti+a\u0018\u0005\u0002\u0005=\u0016\u0001B7bS:$2aJAY\u0011!\t\u0019,a+A\u0002\u0005U\u0016\u0001B1sON\u0004RAFA\u0019\u0003o\u0003B!!/\u0002@:\u0019a#a/\n\u0007\u0005uv#\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003\u0003\f\u0019M\u0001\u0004TiJLgn\u001a\u0006\u0004\u0003{;\u0002\u0002CAd\u0003?\"\t\"!3\u0002\u0017I,\u0017\r\u001a*fg>dg/\u001a\u000b\u0003\u0003G\u0002")
public class LassoWithSGD
extends GeneralizedLinearAlgorithm<LassoModel>
implements Serializable,
ScalaObject {
    private double stepSize;
    private int numIterations;
    private double regParam;
    private double miniBatchFraction;
    private final SquaredGradient gradient;
    private final L1Updater updater;
    private final transient GradientDescent optimizer;
    private double yMean;
    private DoubleMatrix xColMean;
    private DoubleMatrix xColSd;

    public static final void main(String[] stringArray) {
        LassoWithSGD$.MODULE$.main(stringArray);
    }

    public static final LassoModel train(RDD<LabeledPoint> rDD, int n) {
        return LassoWithSGD$.MODULE$.train(rDD, n);
    }

    public static final LassoModel train(RDD<LabeledPoint> rDD, int n, double d, double d2) {
        return LassoWithSGD$.MODULE$.train(rDD, n, d, d2);
    }

    public static final LassoModel train(RDD<LabeledPoint> rDD, int n, double d, double d2, double d3) {
        return LassoWithSGD$.MODULE$.train(rDD, n, d, d2, d3);
    }

    public static final LassoModel train(RDD<LabeledPoint> rDD, int n, double d, double d2, double d3, double[] dArray) {
        return LassoWithSGD$.MODULE$.train(rDD, n, d, d2, d3, dArray);
    }

    public double stepSize() {
        return this.stepSize;
    }

    public void stepSize_$eq(double d) {
        this.stepSize = d;
    }

    public int numIterations() {
        return this.numIterations;
    }

    public void numIterations_$eq(int n) {
        this.numIterations = n;
    }

    public double regParam() {
        return this.regParam;
    }

    public void regParam_$eq(double d) {
        this.regParam = d;
    }

    public double miniBatchFraction() {
        return this.miniBatchFraction;
    }

    public void miniBatchFraction_$eq(double d) {
        this.miniBatchFraction = d;
    }

    public SquaredGradient gradient() {
        return this.gradient;
    }

    public L1Updater updater() {
        return this.updater;
    }

    @Override
    public GradientDescent optimizer() {
        return this.optimizer;
    }

    public double yMean() {
        return this.yMean;
    }

    public void yMean_$eq(double d) {
        this.yMean = d;
    }

    public DoubleMatrix xColMean() {
        return this.xColMean;
    }

    public void xColMean_$eq(DoubleMatrix doubleMatrix) {
        this.xColMean = doubleMatrix;
    }

    public DoubleMatrix xColSd() {
        return this.xColSd;
    }

    public void xColSd_$eq(DoubleMatrix doubleMatrix) {
        this.xColSd = doubleMatrix;
    }

    @Override
    public LassoModel createModel(double[] weights, double intercept) {
        DoubleMatrix weightsMat = new DoubleMatrix(weights.length + 1, 1, (double[])Predef$.MODULE$.doubleArrayOps(Array$.MODULE$.apply(intercept, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[0]))).$plus$plus((GenTraversableOnce)Predef$.MODULE$.doubleArrayOps(weights), Array$.MODULE$.canBuildFrom((ClassManifest)Manifest$.MODULE$.Double())));
        DoubleMatrix weightsScaled = weightsMat.div(this.xColSd());
        double interceptScaled = this.yMean() - weightsMat.transpose().mmul(this.xColMean().div(this.xColSd())).get(0);
        return new LassoModel(weightsScaled.data, interceptScaled);
    }

    @Override
    public LassoModel run(RDD<LabeledPoint> input, double[] initialWeights) {
        int nfeatures$1 = ((LabeledPoint)input.first()).features().length;
        long nexamples = input.count();
        Tuple3<Object, DoubleMatrix, DoubleMatrix> stats = MLUtils$.MODULE$.computeStats(input, nfeatures$1, nexamples);
        this.yMean_$eq(BoxesRunTime.unboxToDouble((Object)stats._1()));
        this.xColMean_$eq((DoubleMatrix)stats._2());
        this.xColSd_$eq((DoubleMatrix)stats._3());
        RDD normalizedData = input.map((Function1)new Serializable(this, nfeatures$1){
            public static final long serialVersionUID;
            public final LassoWithSGD $outer;
            public final int nfeatures$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final LabeledPoint apply(LabeledPoint point) {
                double yNormalized = point.label() - this.$outer.yMean();
                DoubleMatrix featuresMat = new DoubleMatrix(this.nfeatures$1, 1, point.features());
                DoubleMatrix featuresNormalized = featuresMat.sub(this.$outer.xColMean()).divi(this.$outer.xColSd());
                return new LabeledPoint(yNormalized, featuresNormalized.toArray());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.nfeatures$1 = n;
            }
        }, ClassManifest$.MODULE$.classType(LabeledPoint.class));
        return (LassoModel)super.run((RDD<LabeledPoint>)normalizedData, initialWeights);
    }

    public LassoWithSGD(double stepSize, int numIterations, double regParam, double miniBatchFraction) {
        this.stepSize = stepSize;
        this.numIterations = numIterations;
        this.regParam = regParam;
        this.miniBatchFraction = miniBatchFraction;
        this.gradient = new SquaredGradient();
        this.updater = new L1Updater();
        this.optimizer = new GradientDescent(this.gradient(), this.updater()).setStepSize(this.stepSize()).setNumIterations(this.numIterations()).setRegParam(this.regParam()).setMiniBatchFraction(this.miniBatchFraction());
        this.setIntercept(false);
        this.yMean = 0.0;
    }

    public LassoWithSGD() {
        this(1.0, 100, 1.0, 1.0);
    }
}

