/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.json;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Timestamp;
import org.apache.spark.Logging;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.catalyst.ScalaReflection$;
import org.apache.spark.sql.catalyst.analysis.HiveTypeCoercion$;
import org.apache.spark.sql.catalyst.expressions.GenericMutableRow;
import org.apache.spark.sql.json.JsonRDD$;
import org.apache.spark.sql.json.JsonRDD$$anonfun$org$apache$spark$sql$json$JsonRDD$;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DataTypeConversions$;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.DateUtils$;
import org.apache.spark.sql.types.Decimal;
import org.apache.spark.sql.types.Decimal$;
import org.apache.spark.sql.types.DecimalType$;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.NullType$;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.apache.spark.sql.types.TimestampType$;
import org.apache.spark.sql.types.UserDefinedType;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.Iterator;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.SetLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.convert.Wrappers;
import scala.collection.convert.Wrappers$;
import scala.collection.immutable.Iterable$;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.Set$;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.StringBuilder;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.sys.package$;

public final class JsonRDD$
implements Logging {
    public static final JsonRDD$ MODULE$;
    private transient Logger org$apache$spark$Logging$$log_;

    static {
        new JsonRDD$();
    }

    public Logger org$apache$spark$Logging$$log_() {
        return this.org$apache$spark$Logging$$log_;
    }

    public void org$apache$spark$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$Logging$$log_ = x$1;
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public RDD<Row> jsonStringToRow(RDD<String> json, StructType schema, String columnNameOfCorruptRecords) {
        return this.parseJson(json, columnNameOfCorruptRecords).map((Function1)new Serializable(schema){
            public static final long serialVersionUID = 0L;
            private final StructType schema$1;

            public final Row apply(Map<String, Object> parsed) {
                return JsonRDD$.MODULE$.org$apache$spark$sql$json$JsonRDD$$asRow(parsed, this.schema$1);
            }
            {
                this.schema$1 = schema$1;
            }
        }, ClassTag$.MODULE$.apply(Row.class));
    }

    public StructType inferSchema(RDD<String> json, double samplingRatio, String columnNameOfCorruptRecords) {
        Predef$.MODULE$.require(samplingRatio > 0.0, (Function0)new Serializable(samplingRatio){
            public static final long serialVersionUID = 0L;
            private final double samplingRatio$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"samplingRatio (", ") should be greater than 0"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)this.samplingRatio$1)}));
            }
            {
                this.samplingRatio$1 = samplingRatio$1;
            }
        });
        RDD schemaData = samplingRatio > 0.99 ? json : json.sample(false, samplingRatio, 1L);
        Set allKeys = (Set)this.parseJson((RDD<String>)schemaData, columnNameOfCorruptRecords).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Set<Tuple2<String, DataType>> apply(Map<String, Object> m) {
                return JsonRDD$.MODULE$.org$apache$spark$sql$json$JsonRDD$$allKeysWithValueTypes(m);
            }
        }, ClassTag$.MODULE$.apply(Set.class)).reduce((Function2)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Set<Tuple2<String, DataType>> apply(Set<Tuple2<String, DataType>> x$1, Set<Tuple2<String, DataType>> x$2) {
                return (Set)x$1.$plus$plus(x$2);
            }
        });
        return this.createSchema((Set<Tuple2<String, DataType>>)allKeys);
    }

    public double inferSchema$default$2() {
        return 1.0;
    }

    private StructType createSchema(Set<Tuple2<String, DataType>> allKeys) {
        scala.collection.immutable.Map resolved = (scala.collection.immutable.Map)allKeys.groupBy((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(Tuple2<String, DataType> x0$3) {
                Tuple2<String, DataType> tuple2 = x0$3;
                if (tuple2 != null) {
                    String key;
                    String string = key = (String)tuple2._1();
                    return string;
                }
                throw new MatchError(tuple2);
            }
        }).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Tuple2<Seq<String>, DataType> apply(Tuple2<String, Set<Tuple2<String, DataType>>> x0$4) {
                Tuple2<String, Set<Tuple2<String, DataType>>> tuple2 = x0$4;
                if (tuple2 != null) {
                    String key = (String)tuple2._1();
                    Set typeSet = (Set)tuple2._2();
                    Seq fieldName = Predef$.MODULE$.refArrayOps((Object[])key.substring(1, key.length() - 1).split("`.`")).toSeq();
                    DataType dataType2 = (DataType)((TraversableOnce)typeSet.map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final DataType apply(Tuple2<String, DataType> x0$5) {
                            Tuple2<String, DataType> tuple2 = x0$5;
                            if (tuple2 != null) {
                                DataType dataType2;
                                DataType dataType3 = dataType2 = (DataType)tuple2._2();
                                return dataType3;
                            }
                            throw new MatchError(tuple2);
                        }
                    }, Set$.MODULE$.canBuildFrom())).reduce((Function2)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final DataType apply(DataType type1, DataType type2) {
                            return JsonRDD$.MODULE$.compatibleType(type1, type2);
                        }
                    });
                    Tuple2 tuple22 = new Tuple2((Object)fieldName, (Object)dataType2);
                    return tuple22;
                }
                throw new MatchError(tuple2);
            }
        }, scala.collection.immutable.Map$.MODULE$.canBuildFrom());
        return this.org$apache$spark$sql$json$JsonRDD$$makeStruct$1(resolved.keySet().toSeq(), (Seq)Nil$.MODULE$, resolved);
    }

    public StructType nullTypeToStringType(StructType struct) {
        StructField[] fields = (StructField[])Predef$.MODULE$.refArrayOps((Object[])struct.fields()).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final StructField apply(StructField x0$8) {
                StructField structField2;
                block2: {
                    DataType dataType2;
                    block8: {
                        StringType$ stringType$;
                        boolean nullable;
                        String fieldName;
                        block4: {
                            block7: {
                                block6: {
                                    ArrayType arrayType2;
                                    boolean bl;
                                    block5: {
                                        block3: {
                                            structField2 = x0$8;
                                            if (structField2 == null) break block2;
                                            fieldName = structField2.name();
                                            DataType dataType3 = structField2.dataType();
                                            nullable = structField2.nullable();
                                            bl = false;
                                            arrayType2 = null;
                                            dataType2 = dataType3;
                                            NullType$ nullType$ = NullType$.MODULE$;
                                            DataType dataType4 = dataType2;
                                            if (nullType$ != null ? !nullType$.equals(dataType4) : dataType4 != null) break block3;
                                            stringType$ = StringType$.MODULE$;
                                            break block4;
                                        }
                                        if (!(dataType2 instanceof ArrayType)) break block5;
                                        bl = true;
                                        arrayType2 = (ArrayType)dataType2;
                                        DataType dataType5 = arrayType2.elementType();
                                        boolean containsNull = arrayType2.containsNull();
                                        NullType$ nullType$ = NullType$.MODULE$;
                                        DataType dataType6 = dataType5;
                                        if (nullType$ != null ? !nullType$.equals(dataType6) : dataType6 != null) break block5;
                                        stringType$ = new ArrayType((DataType)StringType$.MODULE$, containsNull);
                                        break block4;
                                    }
                                    if (!bl) break block6;
                                    DataType struct = arrayType2.elementType();
                                    boolean containsNull = arrayType2.containsNull();
                                    if (!(struct instanceof StructType)) break block6;
                                    StructType structType2 = (StructType)struct;
                                    stringType$ = new ArrayType((DataType)JsonRDD$.MODULE$.nullTypeToStringType(structType2), containsNull);
                                    break block4;
                                }
                                if (!(dataType2 instanceof StructType)) break block7;
                                StructType structType3 = (StructType)dataType2;
                                stringType$ = JsonRDD$.MODULE$.nullTypeToStringType(structType3);
                                break block4;
                            }
                            if (dataType2 == null) break block8;
                            DataType dataType7 = dataType2;
                            stringType$ = dataType7;
                        }
                        StringType$ newType = stringType$;
                        StructField structField3 = new StructField(fieldName, (DataType)newType, nullable, StructField$.MODULE$.apply$default$4());
                        return structField3;
                    }
                    throw new MatchError((Object)dataType2);
                }
                throw new MatchError((Object)structField2);
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(StructField.class)));
        return new StructType(fields);
    }

    public DataType compatibleType(DataType t1, DataType t2) {
        Option option;
        block4: {
            Tuple2 tuple2;
            block10: {
                DataType dataType2;
                block3: {
                    StringType$ stringType$;
                    block6: {
                        block9: {
                            block8: {
                                block7: {
                                    block5: {
                                        block2: {
                                            DataType commonType;
                                            option = HiveTypeCoercion$.MODULE$.findTightestCommonType(t1, t2);
                                            if (!(option instanceof Some)) break block2;
                                            Some some = (Some)option;
                                            dataType2 = commonType = (DataType)some.x();
                                            break block3;
                                        }
                                        None$ none$ = None$.MODULE$;
                                        Option option2 = option;
                                        if (none$ != null ? !none$.equals(option2) : option2 != null) break block4;
                                        tuple2 = new Tuple2((Object)t1, (Object)t2);
                                        if (tuple2 == null) break block5;
                                        DataType other = (DataType)tuple2._1();
                                        DataType dataType3 = (DataType)tuple2._2();
                                        if (other == null) break block5;
                                        DataType dataType4 = other;
                                        NullType$ nullType$ = NullType$.MODULE$;
                                        DataType dataType5 = dataType3;
                                        if (nullType$ != null ? !nullType$.equals(dataType5) : dataType5 != null) break block5;
                                        stringType$ = dataType4;
                                        break block6;
                                    }
                                    if (tuple2 == null) break block7;
                                    DataType dataType6 = (DataType)tuple2._1();
                                    DataType other = (DataType)tuple2._2();
                                    NullType$ nullType$ = NullType$.MODULE$;
                                    DataType dataType7 = dataType6;
                                    if ((nullType$ != null ? !nullType$.equals(dataType7) : dataType7 != null) || other == null) break block7;
                                    DataType dataType8 = other;
                                    stringType$ = dataType8;
                                    break block6;
                                }
                                if (tuple2 == null) break block8;
                                DataType dataType9 = (DataType)tuple2._1();
                                DataType dataType10 = (DataType)tuple2._2();
                                if (!(dataType9 instanceof StructType)) break block8;
                                StructType structType2 = (StructType)dataType9;
                                StructField[] fields1 = structType2.fields();
                                if (!(dataType10 instanceof StructType)) break block8;
                                StructType structType3 = (StructType)dataType10;
                                StructField[] fields2 = structType3.fields();
                                scala.collection.immutable.Iterable newFields = (scala.collection.immutable.Iterable)Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])fields1).$plus$plus((GenTraversableOnce)Predef$.MODULE$.refArrayOps((Object[])fields2), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(StructField.class)))).groupBy((Function1)new Serializable(){
                                    public static final long serialVersionUID = 0L;

                                    public final String apply(StructField field) {
                                        return field.name();
                                    }
                                }).map((Function1)new Serializable(){
                                    public static final long serialVersionUID = 0L;

                                    public final StructField apply(Tuple2<String, StructField[]> x0$9) {
                                        Tuple2<String, StructField[]> tuple2 = x0$9;
                                        if (tuple2 != null) {
                                            String name = (String)tuple2._1();
                                            StructField[] fieldTypes = (StructField[])tuple2._2();
                                            DataType dataType2 = (DataType)Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])fieldTypes).map((Function1)new Serializable(this){
                                                public static final long serialVersionUID = 0L;

                                                public final DataType apply(StructField field) {
                                                    return field.dataType();
                                                }
                                            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(DataType.class)))).reduce((Function2)new Serializable(this){
                                                public static final long serialVersionUID = 0L;

                                                public final DataType apply(DataType type1, DataType type2) {
                                                    return JsonRDD$.MODULE$.compatibleType(type1, type2);
                                                }
                                            });
                                            StructField structField2 = new StructField(name, dataType2, true, StructField$.MODULE$.apply$default$4());
                                            return structField2;
                                        }
                                        throw new MatchError(tuple2);
                                    }
                                }, Iterable$.MODULE$.canBuildFrom());
                                stringType$ = StructType$.MODULE$.apply((Seq)newFields.toSeq().sortBy((Function1)new Serializable(){
                                    public static final long serialVersionUID = 0L;

                                    public final String apply(StructField x$9) {
                                        return x$9.name();
                                    }
                                }, (Ordering)Ordering.String$.MODULE$));
                                break block6;
                            }
                            if (tuple2 == null) break block9;
                            DataType dataType11 = (DataType)tuple2._1();
                            DataType dataType12 = (DataType)tuple2._2();
                            if (!(dataType11 instanceof ArrayType)) break block9;
                            ArrayType arrayType2 = (ArrayType)dataType11;
                            DataType elementType1 = arrayType2.elementType();
                            boolean containsNull1 = arrayType2.containsNull();
                            if (!(dataType12 instanceof ArrayType)) break block9;
                            ArrayType arrayType3 = (ArrayType)dataType12;
                            DataType elementType2 = arrayType3.elementType();
                            boolean containsNull2 = arrayType3.containsNull();
                            stringType$ = new ArrayType(this.compatibleType(elementType1, elementType2), containsNull1 || containsNull2);
                            break block6;
                        }
                        if (tuple2 == null) break block10;
                        stringType$ = StringType$.MODULE$;
                    }
                    dataType2 = stringType$;
                }
                return dataType2;
            }
            throw new MatchError((Object)tuple2);
        }
        throw new MatchError((Object)option);
    }

    public PartialFunction<Object, DataType> org$apache$spark$sql$json$JsonRDD$$typeOfPrimitiveValue() {
        Serializable useLongType = new Serializable(){
            public static final long serialVersionUID = 0L;

            public final <A1, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                Object object = A1 instanceof Integer ? LongType$.MODULE$ : function1.apply(x1);
                return (B1)object;
            }

            public final boolean isDefinedAt(Object x1) {
                Object object = x1;
                boolean bl = object instanceof Integer;
                return bl;
            }
        };
        return useLongType.orElse(ScalaReflection$.MODULE$.typeOfObject()).orElse((PartialFunction)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final <A1, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                A1 A1 = x2;
                Object object = A1 instanceof BigInteger ? DecimalType$.MODULE$.Unlimited() : (A1 instanceof BigDecimal ? DecimalType$.MODULE$.Unlimited() : StringType$.MODULE$);
                return (B1)object;
            }

            public final boolean isDefinedAt(Object x2) {
                Object object = x2;
                boolean bl = object instanceof BigInteger ? true : (object instanceof BigDecimal ? true : true);
                return bl;
            }
        });
    }

    public ArrayType org$apache$spark$sql$json$JsonRDD$$typeOfArray(Seq<Object> l) {
        ArrayType arrayType2;
        Seq elements = (Seq)l.flatMap((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Iterable<Object> apply(Object v) {
                return Option$.MODULE$.option2Iterable(Option$.MODULE$.apply(v));
            }
        }, Seq$.MODULE$.canBuildFrom());
        if (elements.isEmpty()) {
            arrayType2 = new ArrayType((DataType)NullType$.MODULE$, true);
        } else {
            DataType elementType = (DataType)((TraversableOnce)elements.map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final DataType apply(Object e) {
                    StructType structType2;
                    Object object = e;
                    if (object instanceof Map) {
                        structType2 = StructType$.MODULE$.apply((Seq)Nil$.MODULE$);
                    } else if (object instanceof Seq) {
                        Seq seq = (Seq)object;
                        structType2 = JsonRDD$.MODULE$.org$apache$spark$sql$json$JsonRDD$$typeOfArray((Seq<Object>)seq);
                    } else {
                        structType2 = (DataType)JsonRDD$.MODULE$.org$apache$spark$sql$json$JsonRDD$$typeOfPrimitiveValue().apply(object);
                    }
                    return structType2;
                }
            }, Seq$.MODULE$.canBuildFrom())).reduce((Function2)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final DataType apply(DataType type1, DataType type2) {
                    return JsonRDD$.MODULE$.compatibleType(type1, type2);
                }
            });
            arrayType2 = new ArrayType(elementType, true);
        }
        return arrayType2;
    }

    public Set<Tuple2<String, DataType>> org$apache$spark$sql$json$JsonRDD$$allKeysWithValueTypes(Map<String, Object> m) {
        Set keyValuePairs = ((TraversableOnce)m.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Tuple2<String, Object> apply(Tuple2<String, Object> x0$10) {
                Tuple2<String, Object> tuple2 = x0$10;
                if (tuple2 != null) {
                    String key = (String)tuple2._1();
                    Object value = tuple2._2();
                    Tuple2 tuple22 = new Tuple2((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"`", "`"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{key})), value);
                    return tuple22;
                }
                throw new MatchError(tuple2);
            }
        }, Map$.MODULE$.canBuildFrom())).toSet();
        return (Set)keyValuePairs.flatMap((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Iterable<Tuple2<String, DataType>> apply(Tuple2<String, Object> x0$11) {
                Tuple2<String, Object> tuple2;
                block6: {
                    List list;
                    block3: {
                        block5: {
                            block4: {
                                block2: {
                                    tuple2 = x0$11;
                                    if (tuple2 == null) break block2;
                                    String key = (String)tuple2._1();
                                    Object struct = tuple2._2();
                                    if (key == null) break block2;
                                    String string = key;
                                    if (!(struct instanceof Map)) break block2;
                                    Map map = (Map)struct;
                                    list = ((SetLike)JsonRDD$.MODULE$.org$apache$spark$sql$json$JsonRDD$$allKeysWithValueTypes((Map<String, Object>)map).map((Function1)new Serializable(this, string){
                                        public static final long serialVersionUID = 0L;
                                        private final String x2$1;

                                        public final Tuple2<String, DataType> apply(Tuple2<String, DataType> x0$12) {
                                            Tuple2<String, DataType> tuple2 = x0$12;
                                            if (tuple2 != null) {
                                                String k = (String)tuple2._1();
                                                DataType dataType2 = (DataType)tuple2._2();
                                                Tuple2 tuple22 = new Tuple2((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.x2$1, k})), (Object)dataType2);
                                                return tuple22;
                                            }
                                            throw new MatchError(tuple2);
                                        }
                                        {
                                            this.x2$1 = x2$1;
                                        }
                                    }, Set$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)string, (Object)StructType$.MODULE$.apply((Seq)Nil$.MODULE$))})));
                                    break block3;
                                }
                                if (tuple2 == null) break block4;
                                String key = (String)tuple2._1();
                                Object array = tuple2._2();
                                if (key == null) break block4;
                                String string = key;
                                if (!(array instanceof Seq)) break block4;
                                Seq seq = (Seq)array;
                                ArrayType elementType = JsonRDD$.MODULE$.org$apache$spark$sql$json$JsonRDD$$typeOfArray((Seq<Object>)seq);
                                list = (Iterable)this.org$apache$spark$sql$json$JsonRDD$$anonfun$$buildKeyPathForInnerStructs$1(seq, (DataType)elementType, string).$colon$plus((Object)new Tuple2((Object)string, (Object)elementType), Seq$.MODULE$.canBuildFrom());
                                break block3;
                            }
                            if (tuple2 == null) break block5;
                            String key = (String)tuple2._1();
                            Object value = tuple2._2();
                            if (key == null) break block5;
                            String string = key;
                            Object object = value;
                            String string2 = "";
                            if ((object == null ? string2 != null : !object.equals(string2)) && value != null) break block5;
                            Tuple2 tuple22 = new Tuple2((Object)string, (Object)NullType$.MODULE$);
                            list = Nil$.MODULE$.$colon$colon((Object)tuple22);
                            break block3;
                        }
                        if (tuple2 == null) break block6;
                        String key = (String)tuple2._1();
                        Object value = tuple2._2();
                        if (key == null) break block6;
                        String string = key;
                        Tuple2 tuple23 = new Tuple2((Object)string, JsonRDD$.MODULE$.org$apache$spark$sql$json$JsonRDD$$typeOfPrimitiveValue().apply(value));
                        list = Nil$.MODULE$.$colon$colon((Object)tuple23);
                    }
                    return list;
                }
                throw new MatchError(tuple2);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Seq org$apache$spark$sql$json$JsonRDD$$anonfun$$buildKeyPathForInnerStructs$1(Object v, DataType t, String x4$1) {
                boolean bl = false;
                ArrayType arrayType2 = null;
                DataType dataType2 = t;
                if (dataType2 instanceof ArrayType) {
                    bl = true;
                    arrayType2 = (ArrayType)dataType2;
                    DataType e = arrayType2.elementType();
                    if (e instanceof StructType) {
                        return (Seq)((TraversableLike)((TraversableLike)((Seq)v).flatMap((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final Iterable<Map<String, Object>> apply(Map<String, Object> x$10) {
                                return Option$.MODULE$.option2Iterable(Option$.MODULE$.apply(x$10));
                            }
                        }, Seq$.MODULE$.canBuildFrom())).flatMap((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final Set<Tuple2<String, DataType>> apply(Map<String, Object> element) {
                                return JsonRDD$.MODULE$.org$apache$spark$sql$json$JsonRDD$$allKeysWithValueTypes(element);
                            }
                        }, Seq$.MODULE$.canBuildFrom())).map((Function1)new Serializable(this, x4$1){
                            public static final long serialVersionUID = 0L;
                            private final String x4$1;

                            public final Tuple2<String, DataType> apply(Tuple2<String, DataType> x0$13) {
                                Tuple2<String, DataType> tuple2 = x0$13;
                                if (tuple2 != null) {
                                    String k = (String)tuple2._1();
                                    DataType t = (DataType)tuple2._2();
                                    Tuple2 tuple22 = new Tuple2((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.x4$1, k})), (Object)t);
                                    return tuple22;
                                }
                                throw new MatchError(tuple2);
                            }
                            {
                                this.x4$1 = x4$1;
                            }
                        }, Seq$.MODULE$.canBuildFrom());
                    }
                }
                if (!bl) return Nil$.MODULE$;
                DataType t1 = arrayType2.elementType();
                return (Seq)((TraversableLike)((Seq)v).flatMap((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Iterable<Object> apply(Object x$11) {
                        return Option$.MODULE$.option2Iterable(Option$.MODULE$.apply(x$11));
                    }
                }, Seq$.MODULE$.canBuildFrom())).flatMap((Function1)new Serializable(this, t1, x4$1){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun$org$apache$spark$sql$json$JsonRDD$$allKeysWithValueTypes$1 $outer;
                    private final DataType t1$1;
                    private final String x4$1;

                    public final Seq<Tuple2<String, DataType>> apply(Object element) {
                        return this.$outer.org$apache$spark$sql$json$JsonRDD$$anonfun$$buildKeyPathForInnerStructs$1(element, this.t1$1, this.x4$1);
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.t1$1 = t1$1;
                        this.x4$1 = x4$1;
                    }
                }, Seq$.MODULE$.canBuildFrom());
            }
        }, Set$.MODULE$.canBuildFrom());
    }

    public Object org$apache$spark$sql$json$JsonRDD$$scalafy(Object obj) {
        Object object;
        Object object2 = obj;
        if (object2 instanceof java.util.Map) {
            java.util.Map map = (java.util.Map)object2;
            object = new Wrappers.JMapWrapper((Wrappers)Wrappers$.MODULE$, map).mapValues((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final Object apply(Object obj) {
                    return JsonRDD$.MODULE$.org$apache$spark$sql$json$JsonRDD$$scalafy(obj);
                }
            }).map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final Tuple2<Object, Object> apply(Tuple2<Object, Object> x) {
                    return (Tuple2)Predef$.MODULE$.identity(x);
                }
            }, Map$.MODULE$.canBuildFrom());
        } else if (object2 instanceof java.util.List) {
            java.util.List list = (java.util.List)object2;
            object = new Wrappers.JListWrapper((Wrappers)Wrappers$.MODULE$, list).map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final Object apply(Object obj) {
                    return JsonRDD$.MODULE$.org$apache$spark$sql$json$JsonRDD$$scalafy(obj);
                }
            }, Buffer$.MODULE$.canBuildFrom());
        } else {
            object = object2;
        }
        return object;
    }

    private RDD<Map<String, Object>> parseJson(RDD<String> json, String columnNameOfCorruptRecords) {
        return json.mapPartitions((Function1)new Serializable(columnNameOfCorruptRecords){
            public static final long serialVersionUID = 0L;
            public final String columnNameOfCorruptRecords$1;

            public final Iterator<Map<String, Object>> apply(Iterator<String> iter) {
                ObjectMapper mapper = new ObjectMapper();
                return iter.flatMap((Function1)new Serializable(this, mapper){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.parseJson.1 $outer;
                    private final ObjectMapper mapper$1;

                    public final GenTraversableOnce<Map<String, Object>> apply(String record) {
                        Seq seq;
                        try {
                            Seq parsed;
                            Seq seq2;
                            Object object = this.mapper$1.readValue(record, Object.class);
                            if (object instanceof java.util.Map) {
                                java.util.Map map = (java.util.Map)object;
                                Map map2 = (Map)JsonRDD$.MODULE$.org$apache$spark$sql$json$JsonRDD$$scalafy(map);
                                seq2 = Nil$.MODULE$.$colon$colon((Object)map2);
                            } else if (object instanceof java.util.List) {
                                java.util.List list = (java.util.List)object;
                                seq2 = (Seq)JsonRDD$.MODULE$.org$apache$spark$sql$json$JsonRDD$$scalafy(list);
                            } else {
                                throw package$.MODULE$.error(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Failed to parse record ", ". Please make sure that each line of the file "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{record}))).append((Object)"(or each string in the RDD) is a valid JSON object or an array of JSON objects.").toString());
                            }
                            seq = parsed = seq2;
                        }
                        catch (JsonProcessingException jsonProcessingException) {
                            Map map = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)this.$outer.columnNameOfCorruptRecords$1), (Object)record)}));
                            seq = Nil$.MODULE$.$colon$colon((Object)map);
                        }
                        return seq;
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.mapper$1 = mapper$1;
                    }
                });
            }
            {
                this.columnNameOfCorruptRecords$1 = columnNameOfCorruptRecords$1;
            }
        }, json.mapPartitions$default$2(), ClassTag$.MODULE$.apply(Map.class));
    }

    private long toLong(Object value) {
        Object object;
        block4: {
            long l;
            block3: {
                block2: {
                    object = value;
                    if (!(object instanceof Integer)) break block2;
                    Integer n = (Integer)object;
                    l = BoxesRunTime.unboxToInt((Object)n);
                    break block3;
                }
                if (!(object instanceof Long)) break block4;
                Long l2 = (Long)object;
                l = BoxesRunTime.unboxToLong((Object)l2);
            }
            return l;
        }
        throw new MatchError(object);
    }

    private double toDouble(Object value) {
        Object object;
        block5: {
            double d;
            block3: {
                block4: {
                    block2: {
                        object = value;
                        if (!(object instanceof Integer)) break block2;
                        Integer n = (Integer)object;
                        d = BoxesRunTime.unboxToInt((Object)n);
                        break block3;
                    }
                    if (!(object instanceof Long)) break block4;
                    Long l = (Long)object;
                    d = BoxesRunTime.unboxToLong((Object)l);
                    break block3;
                }
                if (!(object instanceof Double)) break block5;
                Double d2 = (Double)object;
                d = BoxesRunTime.unboxToDouble((Object)d2);
            }
            return d;
        }
        throw new MatchError(object);
    }

    private Decimal toDecimal(Object value) {
        Object object;
        block7: {
            Decimal decimal;
            block3: {
                block6: {
                    block5: {
                        block4: {
                            block2: {
                                object = value;
                                if (!(object instanceof Integer)) break block2;
                                Integer n = (Integer)object;
                                decimal = Decimal$.MODULE$.apply(Predef$.MODULE$.Integer2int(n));
                                break block3;
                            }
                            if (!(object instanceof Long)) break block4;
                            Long l = (Long)object;
                            decimal = Decimal$.MODULE$.apply(Predef$.MODULE$.Long2long(l));
                            break block3;
                        }
                        if (!(object instanceof BigInteger)) break block5;
                        BigInteger bigInteger = (BigInteger)object;
                        decimal = Decimal$.MODULE$.apply(new BigDecimal(bigInteger));
                        break block3;
                    }
                    if (!(object instanceof Double)) break block6;
                    Double d = (Double)object;
                    decimal = Decimal$.MODULE$.apply(Predef$.MODULE$.Double2double(d));
                    break block3;
                }
                if (!(object instanceof BigDecimal)) break block7;
                BigDecimal bigDecimal = (BigDecimal)object;
                decimal = Decimal$.MODULE$.apply(bigDecimal);
            }
            return decimal;
        }
        throw new MatchError(object);
    }

    private String toJsonArrayString(Seq<Object> seq) {
        StringBuilder builder = new StringBuilder();
        builder.append("[");
        IntRef count = new IntRef(0);
        seq.foreach((Function1)new Serializable(builder, count){
            public static final long serialVersionUID = 0L;
            private final StringBuilder builder$1;
            private final IntRef count$1;

            public final StringBuilder apply(Object element) {
                Object object = this.count$1.elem > 0 ? this.builder$1.append(",") : BoxedUnit.UNIT;
                ++this.count$1.elem;
                return this.builder$1.append(JsonRDD$.MODULE$.org$apache$spark$sql$json$JsonRDD$$toString(element));
            }
            {
                this.builder$1 = builder$1;
                this.count$1 = count$1;
            }
        });
        builder.append("]");
        return builder.toString();
    }

    private String toJsonObjectString(Map<String, Object> map) {
        StringBuilder builder = new StringBuilder();
        builder.append("{");
        IntRef count = new IntRef(0);
        map.foreach((Function1)new Serializable(builder, count){
            public static final long serialVersionUID = 0L;
            private final StringBuilder builder$2;
            private final IntRef count$2;

            public final StringBuilder apply(Tuple2<String, Object> x0$14) {
                Tuple2<String, Object> tuple2 = x0$14;
                if (tuple2 != null) {
                    String key = (String)tuple2._1();
                    Object value = tuple2._2();
                    Object object = this.count$2.elem > 0 ? this.builder$2.append(",") : BoxedUnit.UNIT;
                    ++this.count$2.elem;
                    String stringValue = value instanceof String ? new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\\\"", "\\\""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{value})) : JsonRDD$.MODULE$.org$apache$spark$sql$json$JsonRDD$$toString(value);
                    StringBuilder stringBuilder = this.builder$2.append(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\\\"", "\\\":", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{key, stringValue})));
                    return stringBuilder;
                }
                throw new MatchError(tuple2);
            }
            {
                this.builder$2 = builder$2;
                this.count$2 = count$2;
            }
        });
        builder.append("}");
        return builder.toString();
    }

    public String org$apache$spark$sql$json$JsonRDD$$toString(Object value) {
        String string;
        Object object = value;
        if (object instanceof Map) {
            Map map = (Map)object;
            string = this.toJsonObjectString((Map<String, Object>)map);
        } else if (object instanceof Seq) {
            Seq seq = (Seq)object;
            string = this.toJsonArrayString((Seq<Object>)seq);
        } else {
            string = (String)Option$.MODULE$.apply(object).map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final String apply(Object x$16) {
                    return x$16.toString();
                }
            }).orNull(Predef$.MODULE$.conforms());
        }
        return string;
    }

    private int toDate(Object value) {
        Object object;
        block4: {
            int n;
            block3: {
                block2: {
                    object = value;
                    if (!(object instanceof String)) break block2;
                    String string = (String)object;
                    n = DateUtils$.MODULE$.millisToDays(DataTypeConversions$.MODULE$.stringToTime(string).getTime());
                    break block3;
                }
                if (!(object instanceof Date)) break block4;
                Date date = (Date)object;
                n = DateUtils$.MODULE$.fromJavaDate(date);
            }
            return n;
        }
        throw new MatchError(object);
    }

    private Timestamp toTimestamp(Object value) {
        Object object;
        while (true) {
            block5: {
                Timestamp timestamp;
                block4: {
                    block3: {
                        if (!((object = value) instanceof Integer)) break block3;
                        Integer n = (Integer)object;
                        timestamp = new Timestamp(BoxesRunTime.unboxToInt((Object)n));
                        break block4;
                    }
                    if (!(object instanceof Long)) break block5;
                    Long l = (Long)object;
                    timestamp = new Timestamp(Predef$.MODULE$.Long2long(l));
                }
                return timestamp;
            }
            if (!(object instanceof String)) break;
            String string = (String)object;
            value = BoxesRunTime.boxToLong((long)DataTypeConversions$.MODULE$.stringToTime(string).getTime());
        }
        throw new MatchError(object);
    }

    public Object enforceCorrectType(Object value, DataType desiredType) {
        DataType dataType2;
        block18: {
            String string;
            block3: {
                Object object;
                block5: {
                    block17: {
                        block16: {
                            block15: {
                                block14: {
                                    block13: {
                                        block12: {
                                            block11: {
                                                block10: {
                                                    block9: {
                                                        block8: {
                                                            block7: {
                                                                block6: {
                                                                    block4: {
                                                                        block2: {
                                                                            if (value != null) break block2;
                                                                            string = null;
                                                                            break block3;
                                                                        }
                                                                        dataType2 = desiredType;
                                                                        StringType$ stringType$ = StringType$.MODULE$;
                                                                        DataType dataType3 = dataType2;
                                                                        if (stringType$ != null ? !stringType$.equals(dataType3) : dataType3 != null) break block4;
                                                                        object = this.org$apache$spark$sql$json$JsonRDD$$toString(value);
                                                                        break block5;
                                                                    }
                                                                    if (value == null) break block6;
                                                                    Object object2 = value;
                                                                    String string2 = "";
                                                                    if (object2 != null ? !object2.equals(string2) : string2 != null) break block7;
                                                                }
                                                                object = null;
                                                                break block5;
                                                            }
                                                            IntegerType$ integerType$ = IntegerType$.MODULE$;
                                                            DataType dataType4 = dataType2;
                                                            if (integerType$ != null ? !integerType$.equals(dataType4) : dataType4 != null) break block8;
                                                            object = BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)value));
                                                            break block5;
                                                        }
                                                        LongType$ longType$ = LongType$.MODULE$;
                                                        DataType dataType5 = dataType2;
                                                        if (longType$ != null ? !longType$.equals(dataType5) : dataType5 != null) break block9;
                                                        object = BoxesRunTime.boxToLong((long)this.toLong(value));
                                                        break block5;
                                                    }
                                                    DoubleType$ doubleType$ = DoubleType$.MODULE$;
                                                    DataType dataType6 = dataType2;
                                                    if (doubleType$ != null ? !doubleType$.equals(dataType6) : dataType6 != null) break block10;
                                                    object = BoxesRunTime.boxToDouble((double)this.toDouble(value));
                                                    break block5;
                                                }
                                                if (!DecimalType$.MODULE$.unapply(dataType2)) break block11;
                                                object = this.toDecimal(value);
                                                break block5;
                                            }
                                            BooleanType$ booleanType$ = BooleanType$.MODULE$;
                                            DataType dataType7 = dataType2;
                                            if (booleanType$ != null ? !booleanType$.equals(dataType7) : dataType7 != null) break block12;
                                            object = BoxesRunTime.boxToBoolean((boolean)BoxesRunTime.unboxToBoolean((Object)value));
                                            break block5;
                                        }
                                        NullType$ nullType$ = NullType$.MODULE$;
                                        DataType dataType8 = dataType2;
                                        if (nullType$ != null ? !nullType$.equals(dataType8) : dataType8 != null) break block13;
                                        object = null;
                                        break block5;
                                    }
                                    if (!(dataType2 instanceof ArrayType)) break block14;
                                    ArrayType arrayType2 = (ArrayType)dataType2;
                                    DataType elementType = arrayType2.elementType();
                                    object = ((Seq)value).map((Function1)new Serializable(elementType){
                                        public static final long serialVersionUID = 0L;
                                        private final DataType elementType$1;

                                        public final Object apply(Object x$17) {
                                            return JsonRDD$.MODULE$.enforceCorrectType(x$17, this.elementType$1);
                                        }
                                        {
                                            this.elementType$1 = elementType$1;
                                        }
                                    }, Seq$.MODULE$.canBuildFrom());
                                    break block5;
                                }
                                if (!(dataType2 instanceof MapType)) break block15;
                                MapType mapType2 = (MapType)dataType2;
                                DataType dataType9 = mapType2.keyType();
                                DataType valueType = mapType2.valueType();
                                StringType$ stringType$ = StringType$.MODULE$;
                                DataType dataType10 = dataType9;
                                if (stringType$ != null ? !stringType$.equals(dataType10) : dataType10 != null) break block15;
                                Map map = (Map)value;
                                object = map.mapValues((Function1)new Serializable(valueType){
                                    public static final long serialVersionUID = 0L;
                                    private final DataType valueType$1;

                                    public final Object apply(Object x$18) {
                                        return JsonRDD$.MODULE$.enforceCorrectType(x$18, this.valueType$1);
                                    }
                                    {
                                        this.valueType$1 = valueType$1;
                                    }
                                }).map((Function1)new Serializable(){
                                    public static final long serialVersionUID = 0L;

                                    public final Tuple2<String, Object> apply(Tuple2<String, Object> x) {
                                        return (Tuple2)Predef$.MODULE$.identity(x);
                                    }
                                }, Map$.MODULE$.canBuildFrom());
                                break block5;
                            }
                            if (!(dataType2 instanceof StructType)) break block16;
                            StructType structType2 = (StructType)dataType2;
                            object = this.org$apache$spark$sql$json$JsonRDD$$asRow((Map<String, Object>)((Map)value), structType2);
                            break block5;
                        }
                        DateType$ dateType$ = DateType$.MODULE$;
                        DataType dataType11 = dataType2;
                        if (dateType$ != null ? !dateType$.equals(dataType11) : dataType11 != null) break block17;
                        object = BoxesRunTime.boxToInteger((int)this.toDate(value));
                        break block5;
                    }
                    TimestampType$ timestampType$ = TimestampType$.MODULE$;
                    DataType dataType12 = dataType2;
                    if (timestampType$ != null ? !timestampType$.equals(dataType12) : dataType12 != null) break block18;
                    object = this.toTimestamp(value);
                }
                string = object;
            }
            return string;
        }
        throw new MatchError((Object)dataType2);
    }

    /*
     * WARNING - void declaration
     */
    public Row org$apache$spark$sql$json$JsonRDD$$asRow(Map<String, Object> json, StructType schema) {
        void var3_3;
        GenericMutableRow row = new GenericMutableRow(schema.fields().length);
        Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])schema.fields()).zipWithIndex(Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))).foreach((Function1)new Serializable(json, row){
            public static final long serialVersionUID = 0L;
            private final Map json$1;
            private final GenericMutableRow row$1;

            public final void apply(Tuple2<StructField, Object> x0$15) {
                Tuple2<StructField, Object> tuple2 = x0$15;
                if (tuple2 != null) {
                    StructField structField2 = (StructField)tuple2._1();
                    int i = tuple2._2$mcI$sp();
                    if (structField2 != null) {
                        String name = structField2.name();
                        DataType dataType2 = structField2.dataType();
                        this.row$1.update(i, this.json$1.get((Object)name).flatMap((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final Option<Object> apply(Object v) {
                                return Option$.MODULE$.apply(v);
                            }
                        }).map((Function1)new Serializable(this, dataType2){
                            public static final long serialVersionUID = 0L;
                            private final DataType dataType$1;

                            public final Object apply(Object x$19) {
                                return JsonRDD$.MODULE$.enforceCorrectType(x$19, this.dataType$1);
                            }
                            {
                                this.dataType$1 = dataType$1;
                            }
                        }).orNull(Predef$.MODULE$.conforms()));
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        return;
                    }
                }
                throw new MatchError(tuple2);
            }
            {
                this.json$1 = json$1;
                this.row$1 = row$1;
            }
        });
        return var3_3;
    }

    public void rowToJSON(StructType rowSchema, JsonGenerator gen, Row row) {
        this.org$apache$spark$sql$json$JsonRDD$$valWriter$1(gen).apply((Object)rowSchema, (Object)row);
    }

    public final StructType org$apache$spark$sql$json$JsonRDD$$makeStruct$1(Seq values, Seq prefix, scala.collection.immutable.Map resolved$1) {
        Tuple2 tuple2 = values.partition((Function1)new anonfun.8());
        if (tuple2 != null) {
            Tuple2 tuple22;
            Seq topLevel = (Seq)tuple2._1();
            Seq structLike = (Seq)tuple2._2();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)topLevel, (Object)structLike);
            Seq topLevel2 = (Seq)tuple23._1();
            Seq structLike2 = (Seq)tuple23._2();
            Seq topLevelFields = (Seq)((TraversableLike)topLevel2.filter((Function1)new Serializable(resolved$1, prefix){
                public static final long serialVersionUID = 0L;
                private final scala.collection.immutable.Map resolved$1;
                private final Seq prefix$1;

                public final boolean apply(Seq<String> name) {
                    ArrayType arrayType2;
                    DataType elementType;
                    DataType dataType2 = (DataType)this.resolved$1.get(this.prefix$1.$plus$plus(name, Seq$.MODULE$.canBuildFrom())).get();
                    boolean bl = dataType2 instanceof ArrayType ? !this.hasInnerStruct$1(elementType = (arrayType2 = (ArrayType)dataType2).elementType()) : !(dataType2 instanceof StructType);
                    return bl;
                }

                private final boolean hasInnerStruct$1(DataType t) {
                    boolean bl;
                    block2: {
                        while (true) {
                            DataType t1;
                            DataType dataType2;
                            if ((dataType2 = t) instanceof StructType) {
                                bl = true;
                                break block2;
                            }
                            if (!(dataType2 instanceof ArrayType)) break;
                            ArrayType arrayType2 = (ArrayType)dataType2;
                            t = t1 = arrayType2.elementType();
                        }
                        bl = false;
                    }
                    return bl;
                }
                {
                    this.resolved$1 = resolved$1;
                    this.prefix$1 = prefix$1;
                }
            })).map((Function1)new Serializable(resolved$1, prefix){
                public static final long serialVersionUID = 0L;
                private final scala.collection.immutable.Map resolved$1;
                private final Seq prefix$1;

                public final StructField apply(Seq<String> a) {
                    return new StructField((String)a.head(), (DataType)this.resolved$1.get(this.prefix$1.$plus$plus(a, Seq$.MODULE$.canBuildFrom())).get(), true, StructField$.MODULE$.apply$default$4());
                }
                {
                    this.resolved$1 = resolved$1;
                    this.prefix$1 = prefix$1;
                }
            }, Seq$.MODULE$.canBuildFrom());
            Seq topLevelFieldNameSet = (Seq)topLevelFields.map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final String apply(StructField x$5) {
                    return x$5.name();
                }
            }, Seq$.MODULE$.canBuildFrom());
            Seq structFields = ((TraversableOnce)((TraversableLike)((TraversableLike)structLike2.groupBy((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final String apply(Seq<String> x$6) {
                    return (String)x$6.apply(0);
                }
            }).filter((Function1)new Serializable(topLevelFieldNameSet){
                public static final long serialVersionUID = 0L;
                private final Seq topLevelFieldNameSet$1;

                public final boolean apply(Tuple2<String, Seq<Seq<String>>> x0$6) {
                    Tuple2<String, Seq<Seq<String>>> tuple2 = x0$6;
                    if (tuple2 != null) {
                        String name = (String)tuple2._1();
                        boolean bl = !this.topLevelFieldNameSet$1.contains((Object)name);
                        return bl;
                    }
                    throw new MatchError(tuple2);
                }
                {
                    this.topLevelFieldNameSet$1 = topLevelFieldNameSet$1;
                }
            })).map((Function1)new Serializable(resolved$1, prefix){
                public static final long serialVersionUID = 0L;
                private final scala.collection.immutable.Map resolved$1;
                private final Seq prefix$1;

                public final Option<StructField> apply(Tuple2<String, Seq<Seq<String>>> x0$7) {
                    Tuple2<String, Seq<Seq<String>>> tuple2;
                    block2: {
                        DataType dataType2;
                        block6: {
                            None$ none$;
                            block4: {
                                block5: {
                                    StructType structType2;
                                    String name;
                                    block3: {
                                        tuple2 = x0$7;
                                        if (tuple2 == null) break block2;
                                        name = (String)tuple2._1();
                                        Seq fields = (Seq)tuple2._2();
                                        Seq nestedFields = (Seq)fields.map((Function1)new Serializable(this){
                                            public static final long serialVersionUID = 0L;

                                            public final Seq<String> apply(Seq<String> x$7) {
                                                return (Seq)x$7.tail();
                                            }
                                        }, Seq$.MODULE$.canBuildFrom());
                                        structType2 = JsonRDD$.MODULE$.org$apache$spark$sql$json$JsonRDD$$makeStruct$1(nestedFields, (Seq)this.prefix$1.$colon$plus((Object)name, Seq$.MODULE$.canBuildFrom()), this.resolved$1);
                                        DataType dataType3 = (DataType)this.resolved$1.get(this.prefix$1.$colon$plus((Object)name, Seq$.MODULE$.canBuildFrom())).get();
                                        dataType2 = dataType3;
                                        if (!(dataType2 instanceof ArrayType)) break block3;
                                        ArrayType arrayType2 = (ArrayType)dataType2;
                                        none$ = new Some((Object)new StructField(name, (DataType)this.getActualArrayType$1(structType2, arrayType2), true, StructField$.MODULE$.apply$default$4()));
                                        break block4;
                                    }
                                    if (!(dataType2 instanceof StructType)) break block5;
                                    none$ = new Some((Object)new StructField(name, (DataType)structType2, true, StructField$.MODULE$.apply$default$4()));
                                    break block4;
                                }
                                StringType$ stringType$ = StringType$.MODULE$;
                                DataType dataType4 = dataType2;
                                if (stringType$ != null ? !stringType$.equals(dataType4) : dataType4 != null) break block6;
                                none$ = None$.MODULE$;
                            }
                            None$ none$2 = none$;
                            return none$2;
                        }
                        throw new MatchError((Object)dataType2);
                    }
                    throw new MatchError(tuple2);
                }

                private final ArrayType getActualArrayType$1(StructType innerStruct, ArrayType currentArray) {
                    ArrayType arrayType2;
                    block4: {
                        ArrayType arrayType3;
                        block3: {
                            block2: {
                                arrayType2 = currentArray;
                                if (arrayType2 == null) break block2;
                                DataType s = arrayType2.elementType();
                                boolean containsNull = arrayType2.containsNull();
                                if (!(s instanceof StructType)) break block2;
                                arrayType3 = new ArrayType((DataType)innerStruct, containsNull);
                                break block3;
                            }
                            if (arrayType2 == null) break block4;
                            DataType a = arrayType2.elementType();
                            boolean containsNull = arrayType2.containsNull();
                            if (!(a instanceof ArrayType)) break block4;
                            ArrayType arrayType4 = (ArrayType)a;
                            arrayType3 = new ArrayType((DataType)this.getActualArrayType$1(innerStruct, arrayType4), containsNull);
                        }
                        return arrayType3;
                    }
                    throw new MatchError((Object)arrayType2);
                }
                {
                    this.resolved$1 = resolved$1;
                    this.prefix$1 = prefix$1;
                }
            }, Iterable$.MODULE$.canBuildFrom())).flatMap((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final Iterable<StructField> apply(Option<StructField> field) {
                    return Option$.MODULE$.option2Iterable(field);
                }
            }, Iterable$.MODULE$.canBuildFrom())).toSeq();
            return StructType$.MODULE$.apply((Seq)((SeqLike)topLevelFields.$plus$plus((GenTraversableOnce)structFields, Seq$.MODULE$.canBuildFrom())).sortBy((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final String apply(StructField x$8) {
                    return x$8.name();
                }
            }, (Ordering)Ordering.String$.MODULE$));
        }
        throw new MatchError((Object)tuple2);
    }

    public final Function2 org$apache$spark$sql$json$JsonRDD$$valWriter$1(JsonGenerator gen$1) {
        return new Serializable(gen$1){
            public static final long serialVersionUID = 0L;
            public final JsonGenerator gen$1;

            /*
             * Unable to fully structure code
             */
            public final void apply(DataType x0$1, Object x1$1) {
                block24: {
                    block8: {
                        block23: {
                            block22: {
                                block21: {
                                    block20: {
                                        block19: {
                                            block18: {
                                                block17: {
                                                    block16: {
                                                        block15: {
                                                            block14: {
                                                                block13: {
                                                                    block12: {
                                                                        block11: {
                                                                            block10: {
                                                                                block9: {
                                                                                    block7: {
                                                                                        block6: {
                                                                                            block5: {
                                                                                                var3_3 = new Tuple2((Object)x0$1, x1$1);
                                                                                                if (var3_3 == null || (var4_4 = var3_3._2()) != null) break block5;
                                                                                                var5_5 = true;
                                                                                                break block6;
                                                                                            }
                                                                                            if (var3_3 == null) ** GOTO lbl-1000
                                                                                            var6_6 = (DataType)var3_3._1();
                                                                                            v0 = NullType$.MODULE$;
                                                                                            var7_7 = var6_6;
                                                                                            if (!(v0 != null ? v0.equals(var7_7) == false : var7_7 != null)) {
                                                                                                var5_5 = true;
                                                                                            } else lbl-1000:
                                                                                            // 2 sources

                                                                                            {
                                                                                                var5_5 = false;
                                                                                            }
                                                                                        }
                                                                                        if (!var5_5) break block7;
                                                                                        this.gen$1.writeNull();
                                                                                        var8_8 = BoxedUnit.UNIT;
                                                                                        break block8;
                                                                                    }
                                                                                    if (var3_3 == null) break block9;
                                                                                    var9_25 = (DataType)var3_3._1();
                                                                                    v = var3_3._2();
                                                                                    v1 = StringType$.MODULE$;
                                                                                    var11_27 = var9_25;
                                                                                    if ((v1 != null ? v1.equals(var11_27) == false : var11_27 != null) || !(v instanceof String)) break block9;
                                                                                    var12_28 = (String)v;
                                                                                    this.gen$1.writeString(var12_28);
                                                                                    var8_9 = BoxedUnit.UNIT;
                                                                                    break block8;
                                                                                }
                                                                                if (var3_3 == null) break block10;
                                                                                var13_29 = (DataType)var3_3._1();
                                                                                v = var3_3._2();
                                                                                v2 = TimestampType$.MODULE$;
                                                                                var15_31 = var13_29;
                                                                                if ((v2 != null ? v2.equals(var15_31) == false : var15_31 != null) || !(v instanceof Timestamp)) break block10;
                                                                                var16_32 = (Timestamp)v;
                                                                                this.gen$1.writeString(var16_32.toString());
                                                                                var8_10 = BoxedUnit.UNIT;
                                                                                break block8;
                                                                            }
                                                                            if (var3_3 == null) break block11;
                                                                            var17_33 = (DataType)var3_3._1();
                                                                            v = var3_3._2();
                                                                            v3 = IntegerType$.MODULE$;
                                                                            var19_35 = var17_33;
                                                                            if ((v3 != null ? v3.equals(var19_35) == false : var19_35 != null) || !(v instanceof Integer)) break block11;
                                                                            var20_36 = BoxesRunTime.unboxToInt((Object)v);
                                                                            this.gen$1.writeNumber(var20_36);
                                                                            var8_11 = BoxedUnit.UNIT;
                                                                            break block8;
                                                                        }
                                                                        if (var3_3 == null) break block12;
                                                                        var21_37 = (DataType)var3_3._1();
                                                                        v = var3_3._2();
                                                                        v4 = ShortType$.MODULE$;
                                                                        var23_39 = var21_37;
                                                                        if ((v4 != null ? v4.equals(var23_39) == false : var23_39 != null) || !(v instanceof Short)) break block12;
                                                                        var24_40 = BoxesRunTime.unboxToShort((Object)v);
                                                                        this.gen$1.writeNumber(var24_40);
                                                                        var8_12 = BoxedUnit.UNIT;
                                                                        break block8;
                                                                    }
                                                                    if (var3_3 == null) break block13;
                                                                    var25_41 = (DataType)var3_3._1();
                                                                    v = var3_3._2();
                                                                    v5 = FloatType$.MODULE$;
                                                                    var27_43 = var25_41;
                                                                    if ((v5 != null ? v5.equals(var27_43) == false : var27_43 != null) || !(v instanceof Float)) break block13;
                                                                    var28_44 = BoxesRunTime.unboxToFloat((Object)v);
                                                                    this.gen$1.writeNumber(var28_44);
                                                                    var8_13 = BoxedUnit.UNIT;
                                                                    break block8;
                                                                }
                                                                if (var3_3 == null) break block14;
                                                                var29_45 = (DataType)var3_3._1();
                                                                v = var3_3._2();
                                                                v6 = DoubleType$.MODULE$;
                                                                var31_47 = var29_45;
                                                                if ((v6 != null ? v6.equals(var31_47) == false : var31_47 != null) || !(v instanceof Double)) break block14;
                                                                var32_48 = BoxesRunTime.unboxToDouble((Object)v);
                                                                this.gen$1.writeNumber(var32_48);
                                                                var8_14 = BoxedUnit.UNIT;
                                                                break block8;
                                                            }
                                                            if (var3_3 == null) break block15;
                                                            var34_49 = (DataType)var3_3._1();
                                                            v = var3_3._2();
                                                            v7 = LongType$.MODULE$;
                                                            var36_51 = var34_49;
                                                            if ((v7 != null ? v7.equals(var36_51) == false : var36_51 != null) || !(v instanceof Long)) break block15;
                                                            var37_52 = BoxesRunTime.unboxToLong((Object)v);
                                                            this.gen$1.writeNumber(var37_52);
                                                            var8_15 = BoxedUnit.UNIT;
                                                            break block8;
                                                        }
                                                        if (var3_3 == null) break block16;
                                                        var39_53 = (DataType)var3_3._1();
                                                        v = var3_3._2();
                                                        if (!DecimalType$.MODULE$.unapply(var39_53) || !(v instanceof BigDecimal)) break block16;
                                                        var41_55 = (BigDecimal)v;
                                                        this.gen$1.writeNumber(var41_55);
                                                        var8_16 = BoxedUnit.UNIT;
                                                        break block8;
                                                    }
                                                    if (var3_3 == null) break block17;
                                                    var42_56 = (DataType)var3_3._1();
                                                    v = var3_3._2();
                                                    v8 = ByteType$.MODULE$;
                                                    var44_58 = var42_56;
                                                    if ((v8 != null ? v8.equals(var44_58) == false : var44_58 != null) || !(v instanceof Byte)) break block17;
                                                    var45_59 = BoxesRunTime.unboxToByte((Object)v);
                                                    this.gen$1.writeNumber((int)var45_59);
                                                    var8_17 = BoxedUnit.UNIT;
                                                    break block8;
                                                }
                                                if (var3_3 == null) break block18;
                                                var46_60 = (DataType)var3_3._1();
                                                v = var3_3._2();
                                                v9 = BinaryType$.MODULE$;
                                                var48_62 = var46_60;
                                                if ((v9 != null ? v9.equals(var48_62) == false : var48_62 != null) || !(v instanceof byte[])) break block18;
                                                var49_63 = (byte[])v;
                                                this.gen$1.writeBinary(var49_63);
                                                var8_18 = BoxedUnit.UNIT;
                                                break block8;
                                            }
                                            if (var3_3 == null) break block19;
                                            var50_64 = (DataType)var3_3._1();
                                            v = var3_3._2();
                                            v10 = BooleanType$.MODULE$;
                                            var52_66 = var50_64;
                                            if ((v10 != null ? v10.equals(var52_66) == false : var52_66 != null) || !(v instanceof Boolean)) break block19;
                                            var53_67 = BoxesRunTime.unboxToBoolean((Object)v);
                                            this.gen$1.writeBoolean(var53_67);
                                            var8_19 = BoxedUnit.UNIT;
                                            break block8;
                                        }
                                        if (var3_3 == null) break block20;
                                        var54_68 = (DataType)var3_3._1();
                                        v = var3_3._2();
                                        v11 = DateType$.MODULE$;
                                        var56_70 = var54_68;
                                        if (v11 != null ? v11.equals(var56_70) == false : var56_70 != null) break block20;
                                        this.gen$1.writeString(v.toString());
                                        var8_20 = BoxedUnit.UNIT;
                                        break block8;
                                    }
                                    if (var3_3 == null) break block21;
                                    udt = (DataType)var3_3._1();
                                    v = var3_3._2();
                                    if (!(udt instanceof UserDefinedType)) break block21;
                                    var59_73 = (UserDefinedType)udt;
                                    var8_21 = (BoxedUnit)JsonRDD$.MODULE$.org$apache$spark$sql$json$JsonRDD$$valWriter$1(this.gen$1).apply((Object)var59_73.sqlType(), v);
                                    break block8;
                                }
                                if (var3_3 == null) break block22;
                                var60_74 = (DataType)var3_3._1();
                                v = var3_3._2();
                                if (!(var60_74 instanceof ArrayType)) break block22;
                                var62_76 = (ArrayType)var60_74;
                                ty = var62_76.elementType();
                                if (!(v instanceof Seq)) break block22;
                                var64_78 = (Seq)v;
                                this.gen$1.writeStartArray();
                                var64_78.foreach((Function1)new Serializable(this, ty){
                                    public static final long serialVersionUID = 0L;
                                    private final /* synthetic */ anonfun$org$apache$spark$sql$json$JsonRDD$$valWriter$1$1 $outer;
                                    private final DataType ty$1;

                                    public final void apply(Object x$20) {
                                        JsonRDD$.MODULE$.org$apache$spark$sql$json$JsonRDD$$valWriter$1(this.$outer.gen$1).apply((Object)this.ty$1, x$20);
                                    }
                                    {
                                        if ($outer == null) {
                                            throw new NullPointerException();
                                        }
                                        this.$outer = $outer;
                                        this.ty$1 = ty$1;
                                    }
                                });
                                this.gen$1.writeEndArray();
                                var8_22 = BoxedUnit.UNIT;
                                break block8;
                            }
                            if (var3_3 == null) break block23;
                            var65_79 = (DataType)var3_3._1();
                            v = var3_3._2();
                            if (!(var65_79 instanceof MapType)) break block23;
                            var67_81 = (MapType)var65_79;
                            vv = var67_81.valueType();
                            if (!(v instanceof Map)) break block23;
                            var69_83 = (Map)v;
                            this.gen$1.writeStartObject();
                            var69_83.foreach((Function1)new Serializable(this, vv){
                                public static final long serialVersionUID = 0L;
                                private final /* synthetic */ anonfun$org$apache$spark$sql$json$JsonRDD$$valWriter$1$1 $outer;
                                private final DataType vv$1;

                                public final void apply(Tuple2<Object, Object> p) {
                                    this.$outer.gen$1.writeFieldName(p._1().toString());
                                    JsonRDD$.MODULE$.org$apache$spark$sql$json$JsonRDD$$valWriter$1(this.$outer.gen$1).apply((Object)this.vv$1, p._2());
                                }
                                {
                                    if ($outer == null) {
                                        throw new NullPointerException();
                                    }
                                    this.$outer = $outer;
                                    this.vv$1 = vv$1;
                                }
                            });
                            this.gen$1.writeEndObject();
                            var8_23 = BoxedUnit.UNIT;
                            break block8;
                        }
                        if (var3_3 == null) break block24;
                        var70_84 = (DataType)var3_3._1();
                        v = var3_3._2();
                        if (!(var70_84 instanceof StructType)) break block24;
                        var72_86 = (StructType)var70_84;
                        ty = var72_86.fields();
                        if (!(v instanceof Row)) break block24;
                        var74_88 = (Row)v;
                        this.gen$1.writeStartObject();
                        Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])ty).zip((GenIterable)var74_88.toSeq(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))).foreach((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ anonfun$org$apache$spark$sql$json$JsonRDD$$valWriter$1$1 $outer;

                            public final void apply(Tuple2<StructField, Object> x0$2) {
                                Tuple2<StructField, Object> tuple2;
                                block4: {
                                    block3: {
                                        block2: {
                                            Object object;
                                            tuple2 = x0$2;
                                            if (tuple2 == null || (object = tuple2._2()) != null) break block2;
                                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                            break block3;
                                        }
                                        if (tuple2 == null) break block4;
                                        StructField field = (StructField)tuple2._1();
                                        Object v = tuple2._2();
                                        this.$outer.gen$1.writeFieldName(field.name());
                                        BoxedUnit boxedUnit = (BoxedUnit)JsonRDD$.MODULE$.org$apache$spark$sql$json$JsonRDD$$valWriter$1(this.$outer.gen$1).apply((Object)field.dataType(), v);
                                    }
                                    return;
                                }
                                throw new MatchError(tuple2);
                            }
                            {
                                if ($outer == null) {
                                    throw new NullPointerException();
                                }
                                this.$outer = $outer;
                            }
                        });
                        this.gen$1.writeEndObject();
                        var8_24 = BoxedUnit.UNIT;
                    }
                    return;
                }
                throw new MatchError((Object)var3_3);
            }
            {
                this.gen$1 = gen$1;
            }
        };
    }

    private JsonRDD$() {
        MODULE$ = this;
        Logging.class.$init$((Logging)this);
    }
}

