/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.parquet;

import java.sql.Timestamp;
import java.util.HashMap;
import org.apache.hadoop.conf.Configuration;
import org.apache.spark.Logging;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.parquet.CatalystConverter$;
import org.apache.spark.sql.parquet.CatalystTimestampConverter$;
import org.apache.spark.sql.parquet.ParquetRelation$;
import org.apache.spark.sql.parquet.ParquetTypesConverter$;
import org.apache.spark.sql.parquet.RowReadSupport$;
import org.apache.spark.sql.parquet.RowWriteSupport$;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.Decimal;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.NativeType;
import org.apache.spark.sql.types.PrecisionInfo;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.TimestampType$;
import org.apache.spark.sql.types.UserDefinedType;
import org.slf4j.Logger;
import parquet.hadoop.api.WriteSupport;
import parquet.io.api.Binary;
import parquet.io.api.RecordConsumer;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.sys.package$;

@ScalaSignature(bytes="\u0006\u0001\tEb!B\u0001\u0003\u0001\ta!a\u0004*po^\u0013\u0018\u000e^3TkB\u0004xN\u001d;\u000b\u0005\r!\u0011a\u00029beF,X\r\u001e\u0006\u0003\u000b\u0019\t1a]9m\u0015\t9\u0001\"A\u0003ta\u0006\u00148N\u0003\u0002\n\u0015\u00051\u0011\r]1dQ\u0016T\u0011aC\u0001\u0004_J<7c\u0001\u0001\u000ecA\u0019a\u0002\u0006\f\u000e\u0003=Q!\u0001E\t\u0002\u0007\u0005\u0004\u0018N\u0003\u0002\u0013'\u00051\u0001.\u00193p_BT\u0011aA\u0005\u0003+=\u0011Ab\u0016:ji\u0016\u001cV\u000f\u001d9peR\u0004\"a\u0006\u0018\u000f\u0005aYcBA\r)\u001d\tQbE\u0004\u0002\u001cK9\u0011A\u0004\n\b\u0003;\rr!A\b\u0012\u000e\u0003}Q!\u0001I\u0011\u0002\rq\u0012xn\u001c;?\u0007\u0001I\u0011aC\u0005\u0003\u0013)I!a\u0002\u0005\n\u0005\u00151\u0011BA\u0014\u0005\u0003!\u0019\u0017\r^1msN$\u0018BA\u0015+\u0003-)\u0007\u0010\u001d:fgNLwN\\:\u000b\u0005\u001d\"\u0011B\u0001\u0017.\u0003\u001d\u0001\u0018mY6bO\u0016T!!\u000b\u0016\n\u0005=\u0002$a\u0001*po*\u0011A&\f\t\u0003eMj\u0011AB\u0005\u0003i\u0019\u0011q\u0001T8hO&tw\rC\u00037\u0001\u0011\u0005q'\u0001\u0004=S:LGO\u0010\u000b\u0002qA\u0011\u0011\bA\u0007\u0002\u0005!A1\b\u0001a\u0001\n\u0003\u0011A(\u0001\u0004xe&$XM]\u000b\u0002{A\u0011aHQ\u0007\u0002\u007f)\u0011\u0001\u0003\u0011\u0006\u0003\u0003N\t!![8\n\u0005\r{$A\u0004*fG>\u0014HmQ8ogVlWM\u001d\u0005\t\u000b\u0002\u0001\r\u0011\"\u0001\u0003\r\u0006QqO]5uKJ|F%Z9\u0015\u0005\u001dk\u0005C\u0001%L\u001b\u0005I%\"\u0001&\u0002\u000bM\u001c\u0017\r\\1\n\u00051K%\u0001B+oSRDqA\u0014#\u0002\u0002\u0003\u0007Q(A\u0002yIEBa\u0001\u0015\u0001!B\u0013i\u0014aB<sSR,'\u000f\t\u0005\t%\u0002\u0001\r\u0011\"\u0001\u0003'\u0006Q\u0011\r\u001e;sS\n,H/Z:\u0016\u0003Q\u00032\u0001S+X\u0013\t1\u0016JA\u0003BeJ\f\u0017\u0010\u0005\u0002Y36\tQ&\u0003\u0002[[\tI\u0011\t\u001e;sS\n,H/\u001a\u0005\t9\u0002\u0001\r\u0011\"\u0001\u0003;\u0006q\u0011\r\u001e;sS\n,H/Z:`I\u0015\fHCA$_\u0011\u001dq5,!AA\u0002QCa\u0001\u0019\u0001!B\u0013!\u0016aC1uiJL'-\u001e;fg\u0002BQA\u0019\u0001\u0005B\r\fA!\u001b8jiR\u0011Am\u001b\t\u0003K\"t!A\u00044\n\u0005\u001d|\u0011\u0001D,sSR,7+\u001e9q_J$\u0018BA5k\u000519&/\u001b;f\u0007>tG/\u001a=u\u0015\t9w\u0002C\u0003mC\u0002\u0007Q.A\u0007d_:4\u0017nZ;sCRLwN\u001c\t\u0003]Jl\u0011a\u001c\u0006\u0003aF\fAaY8oM*\u0011!\u0003C\u0005\u0003g>\u0014QbQ8oM&<WO]1uS>t\u0007\"B;\u0001\t\u00032\u0018a\u00049sKB\f'/\u001a$pe^\u0013\u0018\u000e^3\u0015\u0005\u001d;\b\"\u0002=u\u0001\u0004i\u0014A\u0004:fG>\u0014HmQ8ogVlWM\u001d\u0005\u0006u\u0002!\te_\u0001\u0006oJLG/\u001a\u000b\u0003\u000frDQ!`=A\u0002Y\taA]3d_J$\u0007bB@\u0001\t\u0003\u0011\u0011\u0011A\u0001\u000boJLG/\u001a,bYV,G#B$\u0002\u0004\u0005M\u0001bBA\u0003}\u0002\u0007\u0011qA\u0001\u0007g\u000eDW-\\1\u0011\t\u0005%\u0011qB\u0007\u0003\u0003\u0017Q1!!\u0004\u0005\u0003\u0015!\u0018\u0010]3t\u0013\u0011\t\t\"a\u0003\u0003\u0011\u0011\u000bG/\u0019+za\u0016Dq!!\u0006\u007f\u0001\u0004\t9\"A\u0003wC2,X\rE\u0002I\u00033I1!a\u0007J\u0005\r\te.\u001f\u0005\t\u0003?\u0001A\u0011\u0001\u0002\u0002\"\u0005qqO]5uKB\u0013\u0018.\\5uSZ,G#B$\u0002$\u0005\u0015\u0002\u0002CA\u0003\u0003;\u0001\r!a\u0002\t\u0011\u0005U\u0011Q\u0004a\u0001\u0003/A\u0001\"!\u000b\u0001\t\u0003\u0011\u00111F\u0001\foJLG/Z*ueV\u001cG\u000fF\u0003H\u0003[\t)\u0004\u0003\u0005\u0002\u0006\u0005\u001d\u0002\u0019AA\u0018!\u0011\tI!!\r\n\t\u0005M\u00121\u0002\u0002\u000b'R\u0014Xo\u0019;UsB,\u0007\u0002CA\u001c\u0003O\u0001\r!!\u000f\u0002\rM$(/^2ua\u0011\tY$!\u0014\u0011\r\u0005u\u00121IA%\u001d\rI\u0014qH\u0005\u0004\u0003\u0003\u0012\u0011!E\"bi\u0006d\u0017p\u001d;D_:4XM\u001d;fe&!\u0011QIA$\u0005=\u0019FO];diN\u001b\u0017\r\\1UsB,'bAA!\u0005A!\u00111JA'\u0019\u0001!A\"a\u0014\u00026\u0005\u0005\t\u0011!B\u0001\u0003#\u00121a\u0018\u00136#\u0011\t\u0019&a\u0006\u0011\u0007!\u000b)&C\u0002\u0002X%\u0013qAT8uQ&tw\r\u0003\u0005\u0002\\\u0001!\tAAA/\u0003)9(/\u001b;f\u0003J\u0014\u0018-\u001f\u000b\u0006\u000f\u0006}\u0013q\r\u0005\t\u0003\u000b\tI\u00061\u0001\u0002bA!\u0011\u0011BA2\u0013\u0011\t)'a\u0003\u0003\u0013\u0005\u0013(/Y=UsB,\u0007\u0002CA5\u00033\u0002\r!a\u001b\u0002\u000b\u0005\u0014(/Y=1\t\u00055\u0014Q\u000f\t\u0007\u0003{\ty'a\u001d\n\t\u0005E\u0014q\t\u0002\u000f\u0003J\u0014\u0018-_*dC2\fG+\u001f9f!\u0011\tY%!\u001e\u0005\u0019\u0005]\u0014qMA\u0001\u0002\u0003\u0015\t!!\u0015\u0003\u0007}#c\u0007\u0003\u0005\u0002|\u0001!\tAAA?\u0003!9(/\u001b;f\u001b\u0006\u0004H#B$\u0002\u0000\u0005\u001d\u0005\u0002CA\u0003\u0003s\u0002\r!!!\u0011\t\u0005%\u00111Q\u0005\u0005\u0003\u000b\u000bYAA\u0004NCB$\u0016\u0010]3\t\u0011\u0005%\u0015\u0011\u0010a\u0001\u0003\u0017\u000b1!\\1qa\u0019\ti)!&\u0002\u001cBA\u0011QHAH\u0003'\u000bI*\u0003\u0003\u0002\u0012\u0006\u001d#\u0001D'baN\u001b\u0017\r\\1UsB,\u0007\u0003BA&\u0003+#A\"a&\u0002\b\u0006\u0005\t\u0011!B\u0001\u0003#\u00121a\u0018\u00138!\u0011\tY%a'\u0005\u0019\u0005u\u0015qQA\u0001\u0002\u0003\u0015\t!!\u0015\u0003\u0007}#\u0003\bC\u0005\u0002\"\u0002\u0011\r\u0011\"\u0003\u0002$\u0006a1o\u0019:bi\u000eD')\u001f;fgV\u0011\u0011Q\u0015\t\u0005\u0011V\u000b9\u000bE\u0002I\u0003SK1!a+J\u0005\u0011\u0011\u0015\u0010^3\t\u0011\u0005=\u0006\u0001)A\u0005\u0003K\u000bQb]2sCR\u001c\u0007NQ=uKN\u0004\u0003\u0002CAZ\u0001\u0011\u0005!!!.\u0002\u0019]\u0014\u0018\u000e^3EK\u000eLW.\u00197\u0015\u000b\u001d\u000b9,!1\t\u0011\u0005e\u0016\u0011\u0017a\u0001\u0003w\u000bq\u0001Z3dS6\fG\u000e\u0005\u0003\u0002\n\u0005u\u0016\u0002BA`\u0003\u0017\u0011q\u0001R3dS6\fG\u000e\u0003\u0005\u0002D\u0006E\u0006\u0019AAc\u0003%\u0001(/Z2jg&|g\u000eE\u0002I\u0003\u000fL1!!3J\u0005\rIe\u000e\u001e\u0005\t\u0003\u001b\u0004A\u0011\u0001\u0002\u0002P\u0006qqO]5uKRKW.Z:uC6\u0004HcA$\u0002R\"A\u00111[Af\u0001\u0004\t).\u0001\u0002ugB!\u0011q[Ap\u001b\t\tINC\u0002\u0006\u00037T!!!8\u0002\t)\fg/Y\u0005\u0005\u0003C\fINA\u0005US6,7\u000f^1na\u001eA\u0011Q\u001d\u0002\t\u0002\t\t9/A\bS_^<&/\u001b;f'V\u0004\bo\u001c:u!\rI\u0014\u0011\u001e\u0004\b\u0003\tA\tAAAv'\u0011\tI/!<\u0011\u0007!\u000by/C\u0002\u0002r&\u0013a!\u00118z%\u00164\u0007b\u0002\u001c\u0002j\u0012\u0005\u0011Q\u001f\u000b\u0003\u0003OD!\"!?\u0002j\n\u0007I\u0011AA~\u0003A\u0019\u0006+\u0011*L?J{ukX*D\u0011\u0016k\u0015)\u0006\u0002\u0002~B!\u0011q B\u0003\u001d\rA%\u0011A\u0005\u0004\u0005\u0007I\u0015A\u0002)sK\u0012,g-\u0003\u0003\u0003\b\t%!AB*ue&twMC\u0002\u0003\u0004%C\u0011B!\u0004\u0002j\u0002\u0006I!!@\u0002#M\u0003\u0016IU&`%>;vlU\"I\u000b6\u000b\u0005\u0005\u0003\u0005\u0003\u0012\u0005%H\u0011\u0001B\n\u0003%9W\r^*dQ\u0016l\u0017\r\u0006\u0003\u0003\u0016\t\u0015\u0002#\u0002B\f\u0005?9f\u0002\u0002B\r\u0005;q1A\bB\u000e\u0013\u0005Q\u0015B\u0001\u0017J\u0013\u0011\u0011\tCa\t\u0003\u0007M+\u0017O\u0003\u0002-\u0013\"1ANa\u0004A\u00025D\u0001B!\u000b\u0002j\u0012\u0005!1F\u0001\ng\u0016$8k\u00195f[\u0006$Ra\u0012B\u0017\u0005_A\u0001\"!\u0002\u0003(\u0001\u0007!Q\u0003\u0005\u0007Y\n\u001d\u0002\u0019A7")
public class RowWriteSupport
extends WriteSupport<Row>
implements Logging {
    private RecordConsumer writer;
    private Attribute[] attributes;
    private final byte[] scratchBytes;
    private transient Logger org$apache$spark$Logging$$log_;

    public static void setSchema(Seq<Attribute> seq, Configuration configuration) {
        RowWriteSupport$.MODULE$.setSchema(seq, configuration);
    }

    public static Seq<Attribute> getSchema(Configuration configuration) {
        return RowWriteSupport$.MODULE$.getSchema(configuration);
    }

    public static String SPARK_ROW_SCHEMA() {
        return RowWriteSupport$.MODULE$.SPARK_ROW_SCHEMA();
    }

    public Logger org$apache$spark$Logging$$log_() {
        return this.org$apache$spark$Logging$$log_;
    }

    public void org$apache$spark$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$Logging$$log_ = x$1;
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public RecordConsumer writer() {
        return this.writer;
    }

    public void writer_$eq(RecordConsumer x$1) {
        this.writer = x$1;
    }

    public Attribute[] attributes() {
        return this.attributes;
    }

    public void attributes_$eq(Attribute[] x$1) {
        this.attributes = x$1;
    }

    public WriteSupport.WriteContext init(Configuration configuration) {
        String origAttributesStr = configuration.get(RowWriteSupport$.MODULE$.SPARK_ROW_SCHEMA());
        HashMap<String, String> metadata = new HashMap<String, String>();
        metadata.put(RowReadSupport$.MODULE$.SPARK_METADATA_KEY(), origAttributesStr);
        if (this.attributes() == null) {
            this.attributes_$eq((Attribute[])ParquetTypesConverter$.MODULE$.convertFromString(origAttributesStr).toArray(ClassTag$.MODULE$.apply(Attribute.class)));
        }
        this.log().debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"write support initialized for requested schema ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.attributes()})));
        ParquetRelation$.MODULE$.enableLogForwarding();
        return new WriteSupport.WriteContext(ParquetTypesConverter$.MODULE$.convertFromAttributes((Seq<Attribute>)Predef$.MODULE$.wrapRefArray((Object[])this.attributes()), ParquetTypesConverter$.MODULE$.convertFromAttributes$default$2()), metadata);
    }

    public void prepareForWrite(RecordConsumer recordConsumer) {
        this.writer_$eq(recordConsumer);
        this.log().debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"preparing for write with schema ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.attributes()})));
    }

    public void write(Row record) {
        int attributesSize = Predef$.MODULE$.refArrayOps((Object[])this.attributes()).size();
        if (attributesSize > record.size()) {
            throw new IndexOutOfBoundsException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Trying to write more fields than contained in row (", " > ", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)attributesSize), BoxesRunTime.boxToInteger((int)record.size())})));
        }
        this.writer().startMessage();
        for (int index = 0; index < attributesSize; ++index) {
            if (record.apply(index) == null) continue;
            this.writer().startField(this.attributes()[index].name(), index);
            this.writeValue(this.attributes()[index].dataType(), record.apply(index));
            this.writer().endField(this.attributes()[index].name(), index);
        }
        this.writer().endMessage();
    }

    public void writeValue(DataType schema, Object value) {
        if (value != null) {
            DataType dataType2 = schema;
            if (dataType2 instanceof UserDefinedType) {
                UserDefinedType userDefinedType = (UserDefinedType)dataType2;
                this.writeValue(userDefinedType.sqlType(), value);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (dataType2 instanceof ArrayType) {
                ArrayType arrayType2 = (ArrayType)dataType2;
                this.writeArray(arrayType2, (Seq<Object>)((Seq)value));
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (dataType2 instanceof MapType) {
                MapType mapType2 = (MapType)dataType2;
                this.writeMap(mapType2, (Map)value);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (dataType2 instanceof StructType) {
                StructType structType2 = (StructType)dataType2;
                this.writeStruct(structType2, (Row)value);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                this.writePrimitive((DataType)((NativeType)schema), value);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
        }
    }

    public void writePrimitive(DataType schema, Object value) {
        block15: {
            block4: {
                DataType dataType2;
                block14: {
                    block13: {
                        block12: {
                            block11: {
                                block10: {
                                    block9: {
                                        block8: {
                                            block7: {
                                                block6: {
                                                    block5: {
                                                        if (value == null) break block4;
                                                        dataType2 = schema;
                                                        StringType$ stringType$ = StringType$.MODULE$;
                                                        DataType dataType3 = dataType2;
                                                        if (stringType$ != null ? !stringType$.equals(dataType3) : dataType3 != null) break block5;
                                                        this.writer().addBinary(Binary.fromByteArray((byte[])((String)value).getBytes("utf-8")));
                                                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                        break block4;
                                                    }
                                                    BinaryType$ binaryType$ = BinaryType$.MODULE$;
                                                    DataType dataType4 = dataType2;
                                                    if (binaryType$ != null ? !binaryType$.equals(dataType4) : dataType4 != null) break block6;
                                                    this.writer().addBinary(Binary.fromByteArray((byte[])((byte[])value)));
                                                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                    break block4;
                                                }
                                                IntegerType$ integerType$ = IntegerType$.MODULE$;
                                                DataType dataType5 = dataType2;
                                                if (integerType$ != null ? !integerType$.equals(dataType5) : dataType5 != null) break block7;
                                                this.writer().addInteger(BoxesRunTime.unboxToInt((Object)value));
                                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                break block4;
                                            }
                                            ShortType$ shortType$ = ShortType$.MODULE$;
                                            DataType dataType6 = dataType2;
                                            if (shortType$ != null ? !shortType$.equals(dataType6) : dataType6 != null) break block8;
                                            this.writer().addInteger((int)BoxesRunTime.unboxToShort((Object)value));
                                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                            break block4;
                                        }
                                        LongType$ longType$ = LongType$.MODULE$;
                                        DataType dataType7 = dataType2;
                                        if (longType$ != null ? !longType$.equals(dataType7) : dataType7 != null) break block9;
                                        this.writer().addLong(BoxesRunTime.unboxToLong((Object)value));
                                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                        break block4;
                                    }
                                    TimestampType$ timestampType$ = TimestampType$.MODULE$;
                                    DataType dataType8 = dataType2;
                                    if (timestampType$ != null ? !timestampType$.equals(dataType8) : dataType8 != null) break block10;
                                    this.writeTimestamp((Timestamp)value);
                                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                    break block4;
                                }
                                ByteType$ byteType$ = ByteType$.MODULE$;
                                DataType dataType9 = dataType2;
                                if (byteType$ != null ? !byteType$.equals(dataType9) : dataType9 != null) break block11;
                                this.writer().addInteger((int)BoxesRunTime.unboxToByte((Object)value));
                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                break block4;
                            }
                            DoubleType$ doubleType$ = DoubleType$.MODULE$;
                            DataType dataType10 = dataType2;
                            if (doubleType$ != null ? !doubleType$.equals(dataType10) : dataType10 != null) break block12;
                            this.writer().addDouble(BoxesRunTime.unboxToDouble((Object)value));
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            break block4;
                        }
                        FloatType$ floatType$ = FloatType$.MODULE$;
                        DataType dataType11 = dataType2;
                        if (floatType$ != null ? !floatType$.equals(dataType11) : dataType11 != null) break block13;
                        this.writer().addFloat(BoxesRunTime.unboxToFloat((Object)value));
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        break block4;
                    }
                    BooleanType$ booleanType$ = BooleanType$.MODULE$;
                    DataType dataType12 = dataType2;
                    if (booleanType$ != null ? !booleanType$.equals(dataType12) : dataType12 != null) break block14;
                    this.writer().addBoolean(BoxesRunTime.unboxToBoolean((Object)value));
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    break block4;
                }
                if (!(dataType2 instanceof DecimalType)) break block15;
                DecimalType decimalType = (DecimalType)dataType2;
                Option option = decimalType.precisionInfo();
                None$ none$ = None$.MODULE$;
                if (!(option == null ? none$ != null : !option.equals(none$)) || ((PrecisionInfo)decimalType.precisionInfo().get()).precision() > 18) {
                    throw package$.MODULE$.error(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unsupported datatype ", ", cannot write to consumer"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{decimalType})));
                }
                this.writeDecimal((Decimal)value, ((PrecisionInfo)decimalType.precisionInfo().get()).precision());
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            return;
        }
        throw package$.MODULE$.error(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Do not know how to writer ", " to consumer"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{schema})));
    }

    public void writeStruct(StructType schema, Row struct) {
        if (struct != null) {
            StructField[] fields = (StructField[])Predef$.MODULE$.refArrayOps((Object[])schema.fields()).toArray(ClassTag$.MODULE$.apply(StructField.class));
            this.writer().startGroup();
            for (int i = 0; i < Predef$.MODULE$.refArrayOps((Object[])fields).size(); ++i) {
                if (struct.apply(i) == null) continue;
                this.writer().startField(fields[i].name(), i);
                this.writeValue(fields[i].dataType(), struct.apply(i));
                this.writer().endField(fields[i].name(), i);
            }
            this.writer().endGroup();
        }
    }

    public void writeArray(ArrayType schema, Seq<Object> array) {
        DataType elementType = schema.elementType();
        this.writer().startGroup();
        if (array.size() > 0) {
            if (schema.containsNull()) {
                this.writer().startField(CatalystConverter$.MODULE$.ARRAY_CONTAINS_NULL_BAG_SCHEMA_NAME(), 0);
                for (int i = 0; i < array.size(); ++i) {
                    this.writer().startGroup();
                    if (array.apply(i) != null) {
                        this.writer().startField(CatalystConverter$.MODULE$.ARRAY_ELEMENTS_SCHEMA_NAME(), 0);
                        this.writeValue(elementType, array.apply(i));
                        this.writer().endField(CatalystConverter$.MODULE$.ARRAY_ELEMENTS_SCHEMA_NAME(), 0);
                    }
                    this.writer().endGroup();
                }
                this.writer().endField(CatalystConverter$.MODULE$.ARRAY_CONTAINS_NULL_BAG_SCHEMA_NAME(), 0);
            } else {
                this.writer().startField(CatalystConverter$.MODULE$.ARRAY_ELEMENTS_SCHEMA_NAME(), 0);
                for (int i = 0; i < array.size(); ++i) {
                    this.writeValue(elementType, array.apply(i));
                }
                this.writer().endField(CatalystConverter$.MODULE$.ARRAY_ELEMENTS_SCHEMA_NAME(), 0);
            }
        }
        this.writer().endGroup();
    }

    public void writeMap(MapType schema, Map<?, Object> map) {
        this.writer().startGroup();
        if (map.size() > 0) {
            this.writer().startField(CatalystConverter$.MODULE$.MAP_SCHEMA_NAME(), 0);
            map.withFilter((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final boolean apply(Tuple2<Object, Object> check$ifrefutable$1) {
                    Tuple2<Object, Object> tuple2 = check$ifrefutable$1;
                    boolean bl = tuple2 != null;
                    return bl;
                }
            }).foreach((Function1)new Serializable(this, schema){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ RowWriteSupport $outer;
                private final MapType schema$1;

                public final void apply(Tuple2<Object, Object> x$1) {
                    Tuple2<Object, Object> tuple2 = x$1;
                    if (tuple2 != null) {
                        Object key = tuple2._1();
                        Object value = tuple2._2();
                        this.$outer.writer().startGroup();
                        this.$outer.writer().startField(CatalystConverter$.MODULE$.MAP_KEY_SCHEMA_NAME(), 0);
                        this.$outer.writeValue(this.schema$1.keyType(), key);
                        this.$outer.writer().endField(CatalystConverter$.MODULE$.MAP_KEY_SCHEMA_NAME(), 0);
                        if (value != null) {
                            this.$outer.writer().startField(CatalystConverter$.MODULE$.MAP_VALUE_SCHEMA_NAME(), 1);
                            this.$outer.writeValue(this.schema$1.valueType(), value);
                            this.$outer.writer().endField(CatalystConverter$.MODULE$.MAP_VALUE_SCHEMA_NAME(), 1);
                        }
                        this.$outer.writer().endGroup();
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        return;
                    }
                    throw new MatchError(tuple2);
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                    this.schema$1 = schema$1;
                }
            });
            this.writer().endField(CatalystConverter$.MODULE$.MAP_SCHEMA_NAME(), 0);
        }
        this.writer().endGroup();
    }

    private byte[] scratchBytes() {
        return this.scratchBytes;
    }

    public void writeDecimal(Decimal decimal, int precision) {
        int numBytes = ParquetTypesConverter$.MODULE$.BYTES_FOR_PRECISION()[precision];
        long unscaledLong = decimal.toUnscaledLong();
        int i = 0;
        int shift = 8 * (numBytes - 1);
        while (i < numBytes) {
            this.scratchBytes()[i] = (byte)(unscaledLong >> shift);
            ++i;
            shift -= 8;
        }
        this.writer().addBinary(Binary.fromByteArray((byte[])this.scratchBytes(), (int)0, (int)numBytes));
    }

    public void writeTimestamp(Timestamp ts) {
        Binary binaryNanoTime = CatalystTimestampConverter$.MODULE$.convertFromTimestamp(ts);
        this.writer().addBinary(binaryNanoTime);
    }

    public RowWriteSupport() {
        Logging.class.$init$((Logging)this);
        this.writer = null;
        this.attributes = null;
        this.scratchBytes = new byte[8];
    }
}

