/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.client.io;

import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.websocket.api.BatchMode;
import org.eclipse.jetty.websocket.api.WebSocketPolicy;
import org.eclipse.jetty.websocket.api.WriteCallback;
import org.eclipse.jetty.websocket.api.extensions.Frame;
import org.eclipse.jetty.websocket.api.extensions.IncomingFrames;
import org.eclipse.jetty.websocket.client.io.ConnectPromise;
import org.eclipse.jetty.websocket.client.io.ConnectionManager;
import org.eclipse.jetty.websocket.client.masks.Masker;
import org.eclipse.jetty.websocket.common.WebSocketFrame;
import org.eclipse.jetty.websocket.common.WebSocketSession;
import org.eclipse.jetty.websocket.common.io.AbstractWebSocketConnection;

public class WebSocketClientConnection
extends AbstractWebSocketConnection {
    private static final Logger LOG = Log.getLogger(WebSocketClientConnection.class);
    private final ConnectPromise connectPromise;
    private final Masker masker;
    private final AtomicBoolean opened = new AtomicBoolean(false);

    public WebSocketClientConnection(EndPoint endp, Executor executor, ConnectPromise connectPromise, WebSocketPolicy policy) {
        super(endp, executor, connectPromise.getClient().getScheduler(), policy, connectPromise.getClient().getBufferPool(), connectPromise.getClient().isDispatchIO());
        this.connectPromise = connectPromise;
        this.masker = connectPromise.getMasker();
        assert (this.masker != null);
    }

    @Override
    public InetSocketAddress getLocalAddress() {
        return this.getEndPoint().getLocalAddress();
    }

    @Override
    public InetSocketAddress getRemoteAddress() {
        return this.getEndPoint().getRemoteAddress();
    }

    @Override
    public void onClose() {
        super.onClose();
        ConnectionManager connectionManager = this.connectPromise.getClient().getConnectionManager();
        connectionManager.removeSession(this.getSession());
    }

    @Override
    public void onOpen() {
        boolean beenOpened = this.opened.getAndSet(true);
        if (!beenOpened) {
            WebSocketSession session = this.getSession();
            ConnectionManager connectionManager = this.connectPromise.getClient().getConnectionManager();
            connectionManager.addSession(session);
            this.connectPromise.succeeded(session);
            ByteBuffer extraBuf = this.connectPromise.getResponse().getRemainingBuffer();
            if (extraBuf.hasRemaining()) {
                LOG.debug("Parsing extra remaining buffer from UpgradeConnection", new Object[0]);
                this.getParser().parse(extraBuf);
            }
        }
        super.onOpen();
    }

    @Override
    public void outgoingFrame(Frame frame, WriteCallback callback, BatchMode batchMode) {
        if (frame instanceof WebSocketFrame) {
            this.masker.setMask((WebSocketFrame)frame);
        }
        super.outgoingFrame(frame, callback, batchMode);
    }

    @Override
    public void setNextIncomingFrames(IncomingFrames incoming) {
        this.getParser().setIncomingFramesHandler(incoming);
    }
}

