/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import org.eclipse.jetty.http.HostPortHttpField;
import org.eclipse.jetty.http.HttpField;
import org.eclipse.jetty.http.HttpFields;
import org.eclipse.jetty.http.HttpGenerator;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http.HttpHeaderValue;
import org.eclipse.jetty.http.HttpMethod;
import org.eclipse.jetty.http.HttpParser;
import org.eclipse.jetty.http.HttpURI;
import org.eclipse.jetty.http.HttpVersion;
import org.eclipse.jetty.http.MetaData;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.HttpChannel;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpConnection;
import org.eclipse.jetty.server.HttpInput;
import org.eclipse.jetty.server.HttpTransport;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

class HttpChannelOverHttp
extends HttpChannel
implements HttpParser.RequestHandler,
HttpParser.ProxyHandler {
    private static final Logger LOG = Log.getLogger(HttpChannelOverHttp.class);
    private final HttpConnection _httpConnection;
    private final HttpFields _fields = new HttpFields();
    private HttpField _connection;
    private boolean _expect = false;
    private boolean _expect100Continue = false;
    private boolean _expect102Processing = false;
    private final MetaData.Request _metadata = new MetaData.Request();

    public HttpChannelOverHttp(HttpConnection httpConnection, Connector connector, HttpConfiguration config, EndPoint endPoint, HttpTransport transport, HttpInput input) {
        super(connector, config, endPoint, transport, input);
        this._httpConnection = httpConnection;
        this._metadata.setFields(this._fields);
        this._metadata.setURI(new HttpURI());
    }

    @Override
    public void recycle() {
        super.recycle();
        this._expect = false;
        this._expect100Continue = false;
        this._expect102Processing = false;
        this._metadata.getURI().clear();
        this._connection = null;
        this._fields.clear();
    }

    @Override
    public boolean isExpecting100Continue() {
        return this._expect100Continue;
    }

    @Override
    public boolean isExpecting102Processing() {
        return this._expect102Processing;
    }

    public boolean startRequest(String method, String uri, HttpVersion version) {
        this._metadata.setMethod(method);
        this._metadata.getURI().parse(uri);
        this._metadata.setHttpVersion(version);
        this._expect = false;
        this._expect100Continue = false;
        this._expect102Processing = false;
        return false;
    }

    public void proxied(String protocol, String sAddr, String dAddr, int sPort, int dPort) {
        this._metadata.setMethod(HttpMethod.CONNECT.asString());
        Request request = this.getRequest();
        request.setAttribute("PROXY", protocol);
        request.setAuthority(sAddr, dPort);
        request.setRemoteAddr(InetSocketAddress.createUnresolved(sAddr, sPort));
    }

    public void parsedHeader(HttpField field) {
        HttpHeader header = field.getHeader();
        String value = field.getValue();
        if (header != null) {
            block0 : switch (header) {
                case CONNECTION: {
                    this._connection = field;
                    break;
                }
                case HOST: {
                    if (this._metadata.getURI().isAbsolute() || !(field instanceof HostPortHttpField)) break;
                    HostPortHttpField hp = (HostPortHttpField)field;
                    this._metadata.getURI().setAuthority(hp.getHost(), hp.getPort());
                    break;
                }
                case EXPECT: {
                    if (this._metadata.getVersion() != HttpVersion.HTTP_1_1) break;
                    HttpHeaderValue expect = (HttpHeaderValue)HttpHeaderValue.CACHE.get(value);
                    switch (expect == null ? HttpHeaderValue.UNKNOWN : expect) {
                        case CONTINUE: {
                            this._expect100Continue = true;
                            break block0;
                        }
                        case PROCESSING: {
                            this._expect102Processing = true;
                            break block0;
                        }
                    }
                    String[] values = field.getValues();
                    block13: for (int i = 0; values != null && i < values.length; ++i) {
                        expect = (HttpHeaderValue)HttpHeaderValue.CACHE.get(values[i].trim());
                        if (expect == null) {
                            this._expect = true;
                            continue;
                        }
                        switch (expect) {
                            case CONTINUE: {
                                this._expect100Continue = true;
                                continue block13;
                            }
                            case PROCESSING: {
                                this._expect102Processing = true;
                                continue block13;
                            }
                            default: {
                                this._expect = true;
                            }
                        }
                    }
                    break;
                }
            }
        }
        this._fields.add(field);
    }

    @Override
    public void continue100(int available) throws IOException {
        if (this.isExpecting100Continue()) {
            this._expect100Continue = false;
            if (available == 0) {
                if (this.getResponse().isCommitted()) {
                    throw new IOException("Committed before 100 Continues");
                }
                boolean committed = this.sendResponse(HttpGenerator.CONTINUE_100_INFO, null, false);
                if (!committed) {
                    throw new IOException("Concurrent commit while trying to send 100-Continue");
                }
            }
        }
    }

    public void earlyEOF() {
        if (this._metadata.getMethod() == null) {
            this._httpConnection.close();
        } else {
            this.onEarlyEOF();
        }
    }

    public boolean content(ByteBuffer content) {
        this.onContent(new HttpInput.Content(content));
        return true;
    }

    public void badMessage(int status, String reason) {
        this._httpConnection._generator.setPersistent(false);
        try {
            this.onRequest(this._metadata);
        }
        catch (Exception e) {
            LOG.ignore((Throwable)e);
        }
        this.onBadMessage(status, reason);
    }

    public boolean headerComplete() {
        boolean persistent;
        switch (this._metadata.getVersion()) {
            case HTTP_1_0: {
                persistent = this._connection != null ? (this._connection.contains(HttpHeaderValue.KEEP_ALIVE.asString()) ? true : this._fields.contains(HttpHeader.CONNECTION, HttpHeaderValue.KEEP_ALIVE.asString())) : false;
                if (!persistent) {
                    persistent = HttpMethod.CONNECT.is(this._metadata.getMethod());
                }
                if (!persistent) break;
                this.getResponse().getHttpFields().add(HttpHeader.CONNECTION, HttpHeaderValue.KEEP_ALIVE);
                break;
            }
            case HTTP_1_1: {
                if (this._expect) {
                    this.badMessage(417, null);
                    return true;
                }
                persistent = this._connection != null ? (this._connection.contains(HttpHeaderValue.CLOSE.asString()) ? false : !this._fields.contains(HttpHeader.CONNECTION, HttpHeaderValue.CLOSE.asString())) : true;
                if (!persistent) {
                    persistent = HttpMethod.CONNECT.is(this._metadata.getMethod());
                }
                if (persistent) break;
                this.getResponse().getHttpFields().add(HttpHeader.CONNECTION, HttpHeaderValue.CLOSE);
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        if (!persistent) {
            this._httpConnection._generator.setPersistent(false);
        }
        this.onRequest(this._metadata);
        return true;
    }

    @Override
    protected void handleException(Throwable x) {
        this._httpConnection._generator.setPersistent(false);
        super.handleException(x);
    }

    @Override
    public void abort(Throwable failure) {
        super.abort(failure);
        this._httpConnection._generator.setPersistent(false);
    }

    public boolean messageComplete() {
        this.onRequestComplete();
        return false;
    }

    public int getHeaderCacheSize() {
        return this.getHttpConfiguration().getHeaderCacheSize();
    }
}

