/*
 * Decompiled with CFR 0.152.
 */
package org.jibx.schema.codegen;

import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.Javadoc;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.TagElement;
import org.eclipse.jdt.core.dom.TextElement;
import org.jibx.schema.codegen.ASTBuilderBase;
import org.jibx.schema.codegen.ClassBuilder;

public class BodyBuilderBase
extends ASTBuilderBase {
    protected final ClassBuilder m_source;
    protected final BodyDeclaration m_declaration;

    public BodyBuilderBase(ClassBuilder source, BodyDeclaration decl) {
        super(source.getAST());
        this.m_source = source;
        this.m_declaration = decl;
    }

    public void setPublic() {
        this.m_declaration.modifiers().add(this.m_ast.newModifier(Modifier.ModifierKeyword.PUBLIC_KEYWORD));
    }

    public void setPrivate() {
        this.m_declaration.modifiers().add(this.m_ast.newModifier(Modifier.ModifierKeyword.PRIVATE_KEYWORD));
    }

    public void setStatic() {
        this.m_declaration.modifiers().add(this.m_ast.newModifier(Modifier.ModifierKeyword.STATIC_KEYWORD));
    }

    public void setFinal() {
        this.m_declaration.modifiers().add(this.m_ast.newModifier(Modifier.ModifierKeyword.FINAL_KEYWORD));
    }

    public void setPrivateFinal() {
        this.setPrivate();
        this.setFinal();
    }

    public void setPrivateStaticFinal() {
        this.setPrivate();
        this.setStatic();
        this.setFinal();
    }

    public void setPublicStatic() {
        this.setPublic();
        this.setStatic();
    }

    public void setPublicStaticFinal() {
        this.setPublic();
        this.setStatic();
        this.setFinal();
    }

    public void addSourceComment(String name, String text) {
        if (text != null) {
            AST ast = this.m_source.getAST();
            TextElement element = ast.newTextElement();
            element.setText(text);
            TagElement tag = ast.newTagElement();
            tag.setTagName(name);
            tag.fragments().add(element);
            Javadoc javadoc = this.m_declaration.getJavadoc();
            if (javadoc == null) {
                javadoc = ast.newJavadoc();
                this.m_declaration.setJavadoc(javadoc);
            }
            javadoc.tags().add(tag);
        }
    }

    public void addSourceComment(String text) {
        this.addSourceComment(null, text);
    }
}

