/*
 * Decompiled with CFR 0.152.
 */
package org.jibx.schema.codegen;

import org.eclipse.jdt.core.dom.CharacterLiteral;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.StringLiteral;
import org.jibx.schema.codegen.ASTBuilderBase;
import org.jibx.schema.codegen.ClassBuilder;

public abstract class ExpressionBuilderBase
extends ASTBuilderBase {
    protected final ClassBuilder m_source;
    protected final Expression m_expression;

    public ExpressionBuilderBase(ClassBuilder source, Expression expr) {
        super(source.getAST());
        this.m_source = source;
        this.m_expression = expr;
    }

    Expression getExpression() {
        return this.m_expression;
    }

    protected abstract void addOperand(Expression var1);

    public void addVariableOperand(String name) {
        this.addOperand((Expression)this.m_ast.newSimpleName(name));
    }

    public void addStringLiteralOperand(String value) {
        StringLiteral strlit = this.m_ast.newStringLiteral();
        strlit.setLiteralValue(value);
        this.addOperand((Expression)strlit);
    }

    public void addCharacterLiteralOperand(char value) {
        CharacterLiteral literal = this.m_ast.newCharacterLiteral();
        literal.setCharValue(value);
        this.addOperand((Expression)literal);
    }

    public void addNumberLiteralOperand(String value) {
        this.addOperand((Expression)this.m_ast.newNumberLiteral(value));
    }

    public void addNullOperand() {
        this.addOperand((Expression)this.m_ast.newNullLiteral());
    }

    public void addOperand(ExpressionBuilderBase builder) {
        this.addOperand(builder.m_expression);
    }
}

