/*
 * Decompiled with CFR 0.152.
 */
package org.jibx.schema.codegen;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.jdt.core.dom.AST;
import org.jibx.binding.model.BindingHolder;
import org.jibx.binding.model.BindingOrganizer;
import org.jibx.schema.codegen.ClassHolder;
import org.jibx.schema.codegen.EnumerationClassHolder;
import org.jibx.schema.codegen.IClassHolder;
import org.jibx.schema.codegen.SourceBuilder;
import org.jibx.schema.codegen.StringObjectPair;
import org.jibx.schema.codegen.StructureClassHolder;
import org.jibx.schema.codegen.TypeData;
import org.jibx.schema.codegen.extend.ClassDecorator;
import org.jibx.schema.codegen.extend.NameConverter;
import org.jibx.util.UniqueNameSet;

public class PackageHolder {
    private final String m_packageName;
    private final File m_generateDirectory;
    private final PackageHolder m_parentPackage;
    private final UniqueNameSet m_nameSet;
    private final ArrayList m_classes;
    private final ArrayList m_allClasses;
    private int m_subpackageCount;

    public PackageHolder(String name, File dir, PackageHolder parent) {
        this.m_packageName = name;
        this.m_generateDirectory = dir;
        this.m_parentPackage = parent;
        if (this.m_parentPackage != null) {
            ++this.m_parentPackage.m_subpackageCount;
        }
        this.m_nameSet = new UniqueNameSet();
        this.m_classes = new ArrayList();
        this.m_allClasses = new ArrayList();
    }

    public File getGenerateDirectory() {
        return this.m_generateDirectory;
    }

    public PackageHolder getParent() {
        return this.m_parentPackage;
    }

    public String getName() {
        return this.m_packageName;
    }

    public int getTopClassCount() {
        return this.m_classes.size();
    }

    public int getClassCount() {
        return this.m_allClasses.size();
    }

    public int getSubpackageCount() {
        return this.m_subpackageCount;
    }

    public ClassHolder addClass(String name, NameConverter nconv, ClassDecorator[] decorators, boolean inner, boolean enumer, BindingHolder holder) {
        String actual = this.m_nameSet.add(name);
        ClassHolder def = enumer ? new EnumerationClassHolder(actual, actual, this, holder, nconv, decorators, inner) : new StructureClassHolder(actual, actual, this, holder, nconv, decorators, inner);
        this.m_classes.add(def);
        this.m_allClasses.add(def);
        return def;
    }

    public ClassHolder addClass(String name, String base, NameConverter nconv, ClassDecorator[] decorators, boolean enumer, BindingHolder holder) {
        ClassHolder def = enumer ? new EnumerationClassHolder(this.m_nameSet.add(name), base, this, holder, nconv, decorators, false) : new StructureClassHolder(this.m_nameSet.add(name), base, this, holder, nconv, decorators, false);
        this.m_classes.add(def);
        this.m_allClasses.add(def);
        return def;
    }

    public void addInnerClass(IClassHolder clas) {
        this.m_allClasses.add(clas);
    }

    public void generate(boolean verbose, TypeData clasdata, AST ast) {
        ClassHolder clashold;
        if (!clasdata.isPregenerated() && !(clashold = (ClassHolder)clasdata).isGenerated()) {
            if (this.m_generateDirectory != null) {
                this.m_generateDirectory.mkdirs();
                if (!this.m_generateDirectory.exists()) {
                    throw new IllegalStateException("Unable to create directory " + this.m_generateDirectory.getAbsolutePath());
                }
            }
            SourceBuilder builder = new SourceBuilder(ast, this, clashold.getName(), clashold.getImports());
            clashold.generate(verbose, builder);
            builder.finish(verbose);
        }
    }

    public void generate(boolean verbose, AST ast, BindingOrganizer directory) {
        for (int i = 0; i < this.m_classes.size(); ++i) {
            ClassHolder clashold = (ClassHolder)this.m_classes.get(i);
            this.generate(verbose, clashold, ast);
        }
    }

    public StringObjectPair[] getClassFields() {
        Object[] pairs = new StringObjectPair[this.m_allClasses.size()];
        for (int i = 0; i < this.m_allClasses.size(); ++i) {
            ClassHolder clas = (ClassHolder)this.m_allClasses.get(i);
            pairs[i] = new StringObjectPair(clas.getFullName(), clas.getBuilder().getSortedFields());
        }
        Arrays.sort(pairs);
        return pairs;
    }
}

