/*
 * Decompiled with CFR 0.152.
 */
package org.jinq.jpa.jpqlquery;

import org.jinq.jpa.jpqlquery.ColumnExpressions;
import org.jinq.jpa.jpqlquery.Expression;
import org.jinq.jpa.jpqlquery.OperatorPrecedenceLevel;
import org.jinq.jpa.jpqlquery.QueryGenerationState;
import org.jinq.jpa.jpqlquery.SelectFromWhere;

public class GroupedSelectFromWhere<T, U>
extends SelectFromWhere<T> {
    public ColumnExpressions<U> groupingCols;
    public Expression having;

    @Override
    protected void prepareQueryGeneration(Expression.QueryGenerationPreparationPhase preparePhase, QueryGenerationState queryState) {
        super.prepareQueryGeneration(preparePhase, queryState);
        for (Expression col : this.groupingCols.columns) {
            col.prepareQueryGeneration(preparePhase, queryState);
        }
        if (this.having != null) {
            this.having.prepareQueryGeneration(preparePhase, queryState);
        }
    }

    @Override
    protected String generateQueryContents(QueryGenerationState queryState) {
        this.generateSelectFromWhere(queryState);
        this.generateGroupBy(queryState);
        this.generateSort(queryState);
        return queryState.queryString;
    }

    protected void generateGroupBy(QueryGenerationState queryState) {
        queryState.queryString = queryState.queryString + " GROUP BY ";
        boolean isFirst = true;
        for (Expression col : this.groupingCols.columns) {
            if (!isFirst) {
                queryState.queryString = queryState.queryString + ", ";
            }
            isFirst = false;
            col.generateQuery(queryState, OperatorPrecedenceLevel.JPQL_UNRESTRICTED_OPERATOR_PRECEDENCE);
        }
        if (this.having != null) {
            queryState.queryString = queryState.queryString + " HAVING ";
            this.having.generateQuery(queryState, OperatorPrecedenceLevel.JPQL_UNRESTRICTED_OPERATOR_PRECEDENCE);
        }
    }

    @Override
    public boolean isSelectFromWhere() {
        return false;
    }

    @Override
    public boolean isSelectFromWhereGroupHaving() {
        return this.sort.isEmpty() && this.limit < 0L && this.skip < 0L;
    }

    @Override
    public GroupedSelectFromWhere<T, U> shallowCopy() {
        GroupedSelectFromWhere<T, U> copy = new GroupedSelectFromWhere<T, U>();
        this.copySelectFromWhereTo(copy);
        copy.groupingCols = this.groupingCols;
        copy.having = this.having;
        return copy;
    }
}

