/*
 * Decompiled with CFR 0.152.
 */
package org.jinq.jpa.transform;

import ch.epfl.labos.iu.orm.queryll2.symbolic.TypedValueVisitorException;
import org.jinq.jpa.jpqlquery.AggregateFunctionExpression;
import org.jinq.jpa.jpqlquery.ColumnExpressions;
import org.jinq.jpa.jpqlquery.ConstantExpression;
import org.jinq.jpa.jpqlquery.Expression;
import org.jinq.jpa.jpqlquery.JPQLQuery;
import org.jinq.jpa.jpqlquery.SelectFromWhere;
import org.jinq.jpa.jpqlquery.SelectOnly;
import org.jinq.jpa.jpqlquery.SimpleRowReader;
import org.jinq.jpa.transform.JPQLOneLambdaQueryTransform;
import org.jinq.jpa.transform.LambdaInfo;
import org.jinq.jpa.transform.MetamodelUtil;
import org.jinq.jpa.transform.QueryTransformException;
import org.jinq.jpa.transform.SelectFromWhereLambdaArgumentHandler;
import org.jinq.jpa.transform.SymbExArgumentHandler;
import org.jinq.jpa.transform.SymbExToColumns;

public class AggregateTransform
extends JPQLOneLambdaQueryTransform {
    private AggregateType type;

    public AggregateTransform(MetamodelUtil metamodel, ClassLoader alternateClassLoader, AggregateType type) {
        super(metamodel, alternateClassLoader);
        this.type = type;
    }

    @Override
    public <U, V> JPQLQuery<U> apply(JPQLQuery<V> query, LambdaInfo lambda, SymbExArgumentHandler parentArgumentScope) throws QueryTransformException {
        try {
            if (query.isSelectFromWhere() || query instanceof SelectOnly) {
                SelectOnly select = (SelectOnly)query;
                Expression aggregatedExpr = null;
                if (this.type != AggregateType.COUNT) {
                    SelectFromWhereLambdaArgumentHandler argumentHandler;
                    SymbExToColumns translator;
                    if (select.isDistinct && (aggregatedExpr = this.makeSelectExpression(translator = new SymbExToColumns(this.metamodel, this.alternateClassLoader, argumentHandler = SelectFromWhereLambdaArgumentHandler.forPassthroughTest(lambda, this.metamodel, parentArgumentScope, false)), lambda).getOnlyColumn()) != SelectFromWhereLambdaArgumentHandler.passthroughColsForTesting.getOnlyColumn()) {
                        throw new TypedValueVisitorException("Applying an aggregation to a distinct stream, but modifying the stream after the distinct but before the aggregation");
                    }
                    if (select.isSelectFromWhere()) {
                        SelectFromWhere sfw = (SelectFromWhere)select;
                        argumentHandler = SelectFromWhereLambdaArgumentHandler.fromSelectFromWhere(sfw, lambda, this.metamodel, parentArgumentScope, false);
                    } else {
                        argumentHandler = SelectFromWhereLambdaArgumentHandler.fromSelectOnly(select, lambda, this.metamodel, parentArgumentScope, false);
                    }
                    translator = new SymbExToColumns(this.metamodel, this.alternateClassLoader, argumentHandler);
                    aggregatedExpr = this.makeSelectExpression(translator, lambda).getOnlyColumn();
                } else {
                    aggregatedExpr = select.cols.isSingleColumn() ? select.cols.getOnlyColumn() : new ConstantExpression("1");
                }
                JPQLQuery toReturn = select.shallowCopy();
                ((SelectOnly)toReturn).isAggregated = true;
                ((SelectOnly)toReturn).cols = ColumnExpressions.singleColumn(new SimpleRowReader(), new AggregateFunctionExpression(aggregatedExpr, this.type.name(), select.isDistinct));
                return toReturn;
            }
            throw new QueryTransformException("Existing query cannot be transformed further");
        }
        catch (TypedValueVisitorException e) {
            throw new QueryTransformException(e);
        }
    }

    public static enum AggregateType {
        SUM,
        AVG,
        MAX,
        MIN,
        COUNT;

    }
}

