/*
 * Decompiled with CFR 0.152.
 */
package org.jinq.jpa.transform;

import ch.epfl.labos.iu.orm.queryll2.symbolic.TypedValueVisitorException;
import java.util.Arrays;
import org.jinq.jpa.jpqlquery.ColumnExpressions;
import org.jinq.jpa.jpqlquery.GroupedSelectFromWhere;
import org.jinq.jpa.jpqlquery.JPQLQuery;
import org.jinq.jpa.jpqlquery.RowReader;
import org.jinq.jpa.jpqlquery.SelectFromWhere;
import org.jinq.jpa.jpqlquery.SelectOnly;
import org.jinq.jpa.jpqlquery.TupleRowReader;
import org.jinq.jpa.transform.GroupingLambdasArgumentHandler;
import org.jinq.jpa.transform.JPQLMultiLambdaQueryTransform;
import org.jinq.jpa.transform.LambdaInfo;
import org.jinq.jpa.transform.MetamodelUtil;
import org.jinq.jpa.transform.QueryTransformException;
import org.jinq.jpa.transform.SelectTransform;
import org.jinq.jpa.transform.SymbExArgumentHandler;
import org.jinq.jpa.transform.SymbExToColumns;

public class GroupingTransform
extends JPQLMultiLambdaQueryTransform {
    public GroupingTransform(MetamodelUtil metamodel, ClassLoader alternateClassLoader) {
        super(metamodel, alternateClassLoader);
    }

    private <U, V, W> JPQLQuery<U> apply(JPQLQuery<V> query, LambdaInfo groupingLambda, LambdaInfo[] lambdas, SymbExArgumentHandler parentArgumentScope) throws QueryTransformException {
        try {
            if (query.isSelectFromWhere()) {
                SelectFromWhere sfw = (SelectFromWhere)query;
                SelectTransform keyTransform = new SelectTransform(this.metamodel, this.alternateClassLoader, false);
                JPQLQuery keyQuery = keyTransform.apply(query, groupingLambda, parentArgumentScope);
                if (!keyQuery.isSelectFromWhere()) {
                    throw new QueryTransformException("Expecting the result of the key calculation to be a SelectFromWhere query");
                }
                SelectOnly keySelect = new SelectOnly();
                keySelect.cols = ((SelectFromWhere)keyQuery).cols;
                SelectOnly streamTee = new SelectOnly();
                streamTee.cols = sfw.cols;
                ColumnExpressions[] aggregatedQueryEntries = new ColumnExpressions[lambdas.length];
                for (int n = 0; n < lambdas.length; ++n) {
                    ColumnExpressions returnQuery;
                    LambdaInfo lambda = lambdas[n];
                    SymbExToColumns translator = new SymbExToColumns(this.metamodel, this.alternateClassLoader, new GroupingLambdasArgumentHandler(keySelect, streamTee, lambdas[n], this.metamodel, parentArgumentScope, false));
                    aggregatedQueryEntries[n] = returnQuery = this.makeSelectExpression(translator, lambda);
                }
                GroupedSelectFromWhere toReturn = sfw.shallowCopyWithGrouping();
                toReturn.isAggregated = true;
                RowReader[] readers = new RowReader[aggregatedQueryEntries.length + 1];
                for (int n = 0; n < aggregatedQueryEntries.length; ++n) {
                    readers[n + 1] = aggregatedQueryEntries[n].reader;
                }
                readers[0] = keySelect.getRowReader();
                ColumnExpressions cols = new ColumnExpressions(TupleRowReader.createReaderForTuple(readers));
                cols.columns.addAll(keySelect.cols.columns);
                for (int n = 0; n < aggregatedQueryEntries.length; ++n) {
                    cols.columns.addAll(aggregatedQueryEntries[n].columns);
                }
                toReturn.groupingCols = keySelect.cols;
                toReturn.cols = cols;
                return toReturn;
            }
            throw new QueryTransformException("Existing query cannot be transformed further");
        }
        catch (TypedValueVisitorException e) {
            throw new QueryTransformException(e);
        }
    }

    @Override
    public <U, V> JPQLQuery<U> apply(JPQLQuery<V> query, LambdaInfo[] lambdas, SymbExArgumentHandler parentArgumentScope) throws QueryTransformException {
        return this.apply(query, lambdas[0], Arrays.copyOfRange(lambdas, 1, lambdas.length), parentArgumentScope);
    }
}

